/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Cartesian {
    public static <T> Iterable<T[]> product(Class<T> resultType, Iterable<? extends Iterable<? extends T>> axes) {
        return new Product<T>(resultType, Cartesian.newArray(Iterable.class, axes));
    }

    public static <T> Iterable<T[]> product(Class<T> resultType, Iterable<? extends T> ... axes) {
        return new Product<T>(resultType, (Iterable[])axes.clone());
    }

    public static <T> Iterable<List<T>> product(Iterable<? extends Iterable<? extends T>> axes) {
        return Cartesian.asLists(Cartesian.product(Object.class, axes));
    }

    public static <T> Iterable<List<T>> product(Iterable<? extends T> ... axes) {
        return Cartesian.asLists(Cartesian.product(Object.class, axes));
    }

    private static <T> Iterable<List<T>> asLists(Iterable<Object[]> arrays) {
        return Iterables.transform(arrays, new AsList());
    }

    private static <T> T[] newArray(Class<? super T> elementType, Iterable<? extends T> from) {
        ArrayList<T> list = new ArrayList<T>();
        for (T f : from) {
            list.add(f);
        }
        return list.toArray(Cartesian.newArray(elementType, list.size()));
    }

    private static <T> T[] newArray(Class<? super T> elementType, int length) {
        return (Object[])Array.newInstance(elementType, length);
    }

    private static class Product<T>
    implements Iterable<T[]> {
        private final Class<T> _resultType;
        private final Iterable<? extends T>[] _axes;

        Product(Class<T> resultType, Iterable<? extends T>[] axes) {
            this._resultType = resultType;
            this._axes = axes;
        }

        @Override
        public Iterator<T[]> iterator() {
            if (this._axes.length <= 0) {
                return Collections.singletonList(Cartesian.newArray(this._resultType, 0)).iterator();
            }
            return new ProductIterator<T>(this._resultType, this._axes);
        }

        public String toString() {
            return "Cartesian.product(" + Arrays.toString(this._axes) + ")";
        }

        private static class ProductIterator<T>
        implements Iterator<T[]> {
            private final Iterable<? extends T>[] _axes;
            private final Iterator<? extends T>[] _iterators;
            private final T[] _result;
            private int _nextIndex = -2;
            private static final int NEW = -2;
            private static final int DONE = -1;

            ProductIterator(Class<T> resultType, Iterable<? extends T>[] axes) {
                this._axes = axes;
                this._iterators = (Iterator[])Cartesian.newArray(Iterator.class, this._axes.length);
                for (int a = 0; a < this._axes.length; ++a) {
                    this._iterators[a] = axes[a].iterator();
                }
                this._result = Cartesian.newArray(resultType, this._iterators.length);
            }

            private void close() {
                this._nextIndex = -1;
                Arrays.fill(this._iterators, null);
                Arrays.fill(this._result, null);
            }

            @Override
            public boolean hasNext() {
                block4: {
                    Iterator<T> iter;
                    block5: {
                        if (this._nextIndex != -2) break block5;
                        this._nextIndex = 0;
                        for (Iterator<T> iterator : this._iterators) {
                            if (iterator.hasNext()) continue;
                            this.close();
                            break block4;
                        }
                        break block4;
                    }
                    if (this._nextIndex < this._iterators.length) break block4;
                    this._nextIndex = this._iterators.length - 1;
                    while (this._nextIndex >= 0 && !(iter = this._iterators[this._nextIndex]).hasNext()) {
                        if (this._nextIndex == 0) {
                            this.close();
                            break;
                        }
                        iter = this._axes[this._nextIndex].iterator();
                        this._iterators[this._nextIndex] = iter;
                        if (!iter.hasNext()) {
                            this.close();
                            break;
                        }
                        --this._nextIndex;
                    }
                }
                return this._nextIndex >= 0;
            }

            @Override
            public T[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("!hasNext");
                }
                while (this._nextIndex < this._iterators.length) {
                    this._result[this._nextIndex] = this._iterators[this._nextIndex].next();
                    ++this._nextIndex;
                }
                return (Object[])this._result.clone();
            }

            @Override
            public void remove() {
                for (Iterator<T> iterator : this._iterators) {
                    iterator.remove();
                }
            }

            public String toString() {
                return "Cartesian.product(" + Arrays.toString(this._axes) + ").iterator()";
            }
        }
    }

    private static class AsList<T>
    implements Function<Object[], List<T>> {
        private AsList() {
        }

        public List<T> apply(Object[] array) {
            return Arrays.asList(array);
        }
    }
}

