/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.Cartesian;
import org.sosy_lab.cpachecker.util.precondition.segkro.FormulaUtils;
import org.sosy_lab.cpachecker.util.precondition.segkro.interfaces.Rule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.EliminationRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.EquivalenceRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.InEqualityRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.RuleEngine;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class ExtractNewPreds {
    private final FormulaManagerView mgrv;
    private final RuleEngine ruleEngine;
    private Ordering<Integer> ordering = new Ordering<Integer>(){

        public int compare(Integer left, Integer right) {
            return Ints.compare((int)left, (int)right);
        }
    };

    public ExtractNewPreds(Solver pSolver, RuleEngine ruleEngine) {
        this.ruleEngine = (RuleEngine)Preconditions.checkNotNull((Object)ruleEngine);
        this.mgrv = pSolver.getFormulaManager();
    }

    private Collection<BooleanFormula> extractLiterals(BooleanFormula pInputFormula) {
        return this.mgrv.extractLiterals(pInputFormula, false, false, false);
    }

    private void printFormulaCollection(PrintStream pOut, Collection<BooleanFormula> pC) {
        for (BooleanFormula f : pC) {
            pOut.println("===" + f);
        }
    }

    public List<BooleanFormula> extractNewPreds(Collection<BooleanFormula> pBasePredicates) throws SolverException, InterruptedException {
        ArrayList resultPredicates = Lists.newArrayList();
        LinkedList resultPredicatesPrime = Lists.newLinkedList();
        resultPredicatesPrime.addAll(this.ruleEngine.canonicalize(pBasePredicates));
        do {
            resultPredicates.clear();
            resultPredicates.addAll(resultPredicatesPrime);
            for (Rule rule : this.ruleEngine.getRules()) {
                int premiseCount = rule.getPremises().size();
                assert (premiseCount != 0);
                ArrayList<ArrayList> dimensions = new ArrayList<ArrayList>(premiseCount);
                for (int i = 0; i < premiseCount; ++i) {
                    dimensions.add(resultPredicates);
                }
                for (List<BooleanFormula> tuple : Cartesian.product(dimensions)) {
                    Set<BooleanFormula> concluded;
                    boolean isBasicPredicatesOnlyRule;
                    boolean tupleContainsOnlyBasePredicates = !FormulaUtils.containsFormulasNotFrom(tuple, pBasePredicates);
                    boolean bl = isBasicPredicatesOnlyRule = rule instanceof InEqualityRule || rule instanceof EliminationRule || rule instanceof EquivalenceRule;
                    if (isBasicPredicatesOnlyRule && !tupleContainsOnlyBasePredicates || (concluded = rule.applyWithInputRelatingPremises(tuple)).isEmpty()) continue;
                    ArrayList positions = Lists.newArrayList();
                    for (int posInResult = 0; posInResult < resultPredicates.size(); ++posInResult) {
                        for (BooleanFormula tf : tuple) {
                            if (!FormulaUtils.equalFormula((BooleanFormula)resultPredicates.get(posInResult), tf)) continue;
                            positions.add(posInResult);
                        }
                    }
                    int maxPosInResult = (Integer)this.ordering.max((Iterable)positions);
                    for (BooleanFormula p : concluded) {
                        if (resultPredicatesPrime.contains(p)) continue;
                        resultPredicatesPrime.add(maxPosInResult + 1, p);
                    }
                }
            }
        } while (!resultPredicates.equals(resultPredicatesPrime));
        return resultPredicates;
    }

    public List<BooleanFormula> extractNewPreds(BooleanFormula pConjunctiveFormula) throws SolverException, InterruptedException {
        Collection<BooleanFormula> literals = this.extractLiterals(pConjunctiveFormula);
        return this.extractNewPreds(literals);
    }
}

