/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro;

import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.ExtractNewPreds;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.RuleEngine;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.ArrayFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.QuantifiedFormulaManagerView;
import org.sosy_lab.cpachecker.util.test.SolverBasedTest0;

public class ExtractNewPredsTest0
extends SolverBasedTest0 {
    private ExtractNewPreds enp;
    private RuleEngine rulesEngine;
    private FormulaManagerView mgrv;
    private ArrayFormulaManagerView afm;
    private QuantifiedFormulaManagerView qfm;
    private BooleanFormulaManagerView bfm;
    private NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> ifm;
    private BooleanFormula _i1_EQUAL_0;
    private BooleanFormula _b0_at_i1_NOTEQUAL_0;
    private NumeralFormula.IntegerFormula _a0_at_i1;
    private NumeralFormula.IntegerFormula _b0_at_i1;
    private BooleanFormula _i1_GEQ_al0;
    private BooleanFormula _a0_at_i1_EQUAL_b0_at_i1;
    private NumeralFormula.IntegerFormula _i1_plus_1;
    private BooleanFormula _i0_EQUAL_i1_plus_1;
    private BooleanFormula _b0_at_i0_EQUAL_0;
    private NumeralFormula.IntegerFormula _b0_at_i0;
    private BooleanFormula _i2_EQUAL_0;
    private NumeralFormula.IntegerFormula _b0_at_i2;
    private BooleanFormula _b0_at_i2_NOTEQUAL_0;
    private BooleanFormula _i2_GEQ_al0;
    private BooleanFormula _a1_at_i2_EQUAL_b0_at_i2;
    private NumeralFormula.IntegerFormula _i2_plus_1;
    private BooleanFormula _i1_EQUAL_i2_plus_1;
    private BooleanFormula _b0_at_i0_NOTEQUAL_0;
    private BooleanFormula _i0_LESS_al0;
    private NumeralFormula.IntegerFormula _a1_at_i2;
    private BooleanFormula _safeTrace;
    private BooleanFormula _errorTrace;
    private NumeralFormula.IntegerFormula _0;
    private NumeralFormula.IntegerFormula _1;
    private NumeralFormula.IntegerFormula _i;
    private NumeralFormula.IntegerFormula _n;
    private NumeralFormula.IntegerFormula _al;
    private NumeralFormula.IntegerFormula _bl;
    private ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> _b0;
    private ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> _b;
    private NumeralFormula.IntegerFormula _k;

    @Override
    protected FormulaManagerFactory.Solvers solverToUse() {
        return FormulaManagerFactory.Solvers.Z3;
    }

    @Before
    public void setUp() throws Exception {
        this.mgrv = new FormulaManagerView(this.factory, this.config, TestLogManager.getInstance());
        Solver solver = new Solver(this.mgrv, this.factory, this.config, TestLogManager.getInstance());
        this.afm = this.mgrv.getArrayFormulaManager();
        this.bfm = this.mgrv.getBooleanFormulaManager();
        this.ifm = this.mgrv.getIntegerFormulaManager();
        this.qfm = this.mgrv.getQuantifiedFormulaManager();
        this.rulesEngine = new RuleEngine(this.logger, solver);
        this.enp = new ExtractNewPreds(solver, this.rulesEngine);
        this.setupTestdata();
    }

    public void setupTestdata() {
        this._0 = this.ifm.makeNumber(0L);
        this._1 = this.ifm.makeNumber(1L);
        this._i = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "i");
        this._k = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "k");
        this._al = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "al");
        this._bl = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "bl");
        this._n = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "n");
        this._b = this.afm.makeArray("b", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        NumeralFormula.IntegerFormula _i0 = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "i0");
        NumeralFormula.IntegerFormula _i1 = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "i1");
        NumeralFormula.IntegerFormula _i2 = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "i2");
        NumeralFormula.IntegerFormula _al0 = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "al0");
        ArrayFormula _a0 = this.afm.makeArray("a0", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        ArrayFormula _a1 = this.afm.makeArray("a1", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        ArrayFormula _b0 = this.afm.makeArray("b0", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        this._i0_LESS_al0 = this.ifm.lessThan(_i0, _al0);
        this._i1_plus_1 = this.ifm.add(_i1, this._1);
        this._i2_plus_1 = this.ifm.add(_i2, this._1);
        this._a0_at_i1 = (NumeralFormula.IntegerFormula)this.afm.select(_a0, _i1);
        this._a1_at_i2 = (NumeralFormula.IntegerFormula)this.afm.select(_a1, _i2);
        this._b0_at_i1 = (NumeralFormula.IntegerFormula)this.afm.select(_b0, _i1);
        this._b0_at_i0 = (NumeralFormula.IntegerFormula)this.afm.select(_b0, _i0);
        this._i1_EQUAL_0 = this.ifm.equal(_i1, this._0);
        this._b0_at_i1_NOTEQUAL_0 = this.ifm.equal(this._b0_at_i1, this._0);
        this._i1_GEQ_al0 = this.ifm.greaterOrEquals(_i1, _al0);
        this._a0_at_i1_EQUAL_b0_at_i1 = this.ifm.equal(this._a0_at_i1, this._b0_at_i1);
        this._i0_EQUAL_i1_plus_1 = this.ifm.equal(_i0, this._i1_plus_1);
        this._b0_at_i0_EQUAL_0 = this.ifm.equal(this._b0_at_i0, this._0);
        this._b0_at_i0_NOTEQUAL_0 = this.bfm.not(this._b0_at_i0_EQUAL_0);
        this._i2_EQUAL_0 = this.ifm.equal(_i2, this._0);
        this._b0_at_i2 = (NumeralFormula.IntegerFormula)this.afm.select(_b0, _i2);
        this._b0_at_i2_NOTEQUAL_0 = this.bfm.not(this.ifm.equal(this._b0_at_i2, this._0));
        this._i2_GEQ_al0 = this.ifm.greaterOrEquals(_i2, _al0);
        this._a1_at_i2_EQUAL_b0_at_i2 = this.ifm.equal(this._a1_at_i2, this._b0_at_i2);
        this._i1_EQUAL_i2_plus_1 = this.ifm.equal(_i1, this._i2_plus_1);
        this._safeTrace = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this._i1_EQUAL_0, this._b0_at_i1_NOTEQUAL_0, this._i1_GEQ_al0, this._a0_at_i1_EQUAL_b0_at_i1, this._i0_EQUAL_i1_plus_1, this._b0_at_i0_EQUAL_0}));
        this._errorTrace = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this._i2_EQUAL_0, this._b0_at_i2_NOTEQUAL_0, this._i2_GEQ_al0, this._a1_at_i2_EQUAL_b0_at_i2, this._i1_EQUAL_i2_plus_1, this._b0_at_i1_NOTEQUAL_0, this._i1_GEQ_al0, this._a0_at_i1_EQUAL_b0_at_i1, this._i0_EQUAL_i1_plus_1, this._b0_at_i0_NOTEQUAL_0, this._i0_LESS_al0}));
    }

    private BooleanFormula rangePredicate(boolean pForall, NumeralFormula.IntegerFormula pLowerLimit, NumeralFormula.IntegerFormula pUpperLimit) {
        NumeralFormula.IntegerFormula _x = this.ifm.makeVariable("x");
        BooleanFormula _range = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, _x)), this.ifm.makeNumber(0L))), this.ifm.greaterOrEquals(_x, pLowerLimit), this.ifm.lessOrEquals(_x, pUpperLimit)}));
        if (pForall) {
            return this.qfm.forall(Lists.newArrayList((Object[])new NumeralFormula.IntegerFormula[]{_x}), _range);
        }
        return this.qfm.exists(Lists.newArrayList((Object[])new NumeralFormula.IntegerFormula[]{_x}), _range);
    }

    public void testOnTraceX() throws SolverException, InterruptedException {
        BooleanFormula _safeWp1 = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._i)), this._0)), this.ifm.lessOrEquals(this.ifm.add(this._i, this._1), this._0), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.add(this._i, this._1))), this._0)}));
        List<BooleanFormula> result = this.enp.extractNewPreds(_safeWp1);
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testOnSafeWp3() throws SolverException, InterruptedException {
        BooleanFormula wpSafe = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._i)), this._0)), this.ifm.lessOrEquals(this.ifm.add(this._i, this._1), this._al), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.add(this._i, this._1))), this._0)}));
        List<BooleanFormula> result = this.enp.extractNewPreds(wpSafe);
        Truth.assertThat(result).containsAllIn((Iterable)Lists.newArrayList((Object[])new BooleanFormula[]{this.rangePredicate(false, this._i, this.ifm.add(this._i, this._1)), this.rangePredicate(false, this._i, this._al)}));
    }

    @Test
    public void testOnErrorWp1() throws SolverException, InterruptedException {
        BooleanFormula wpError = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.ifm.greaterOrEquals(this.ifm.add(this._i, this._1), this._al), this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.add(this._i, this._1))), this._0)), this.ifm.lessThan(this._i, this._al), this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._i)), this._0))}));
        List<BooleanFormula> result = this.enp.extractNewPreds(wpError);
        Truth.assertThat(result).containsAllIn((Iterable)Lists.newArrayList((Object[])new BooleanFormula[]{this.rangePredicate(true, this._i, this.ifm.add(this._i, this._1)), this.rangePredicate(true, this._i, this._al)}));
    }

    @Test
    public void testOnErrorWp2() throws SolverException, InterruptedException {
        BooleanFormula wpError = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.ifm.greaterOrEquals(this._1, this._al), this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._1)), this._0)), this.ifm.lessThan(this._0, this._al), this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._0)), this._0))}));
        List<BooleanFormula> result = this.enp.extractNewPreds(wpError);
        Truth.assertThat(result).containsAllIn((Iterable)Lists.newArrayList((Object[])new BooleanFormula[]{this.ifm.equal(this._al, this._1), this.rangePredicate(true, this._0, this._1), this.rangePredicate(true, this._0, this._al)}));
    }

    @Test
    public void testOnSafeWp4() throws SolverException, InterruptedException {
        BooleanFormula wpSafe = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._0)), this._0)), this.ifm.lessOrEquals(this._1, this._al), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._1)), this._0)}));
        List<BooleanFormula> result = this.enp.extractNewPreds(wpSafe);
        Truth.assertThat(result).containsAllIn((Iterable)Lists.newArrayList((Object[])new BooleanFormula[]{this.rangePredicate(false, this._0, this._1), this.rangePredicate(false, this._0, this._al)}));
    }

    @Test
    public void testOnArrayPreds1() throws SolverException, InterruptedException {
        BooleanFormula wpSafe = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._0)), this._al)), this.bfm.not(this.ifm.lessOrEquals(this._i, this._0))}));
        List<BooleanFormula> result = this.enp.extractNewPreds(wpSafe);
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testOnArrayPreds2() throws SolverException, InterruptedException {
        BooleanFormula wpSafe = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._i)), this._al)), this.bfm.not(this.ifm.lessOrEquals(this._n, this._i))}));
        List<BooleanFormula> result = this.enp.extractNewPreds(wpSafe);
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testOnArrayPreds3() throws SolverException, InterruptedException {
        ArrayList preds = Lists.newArrayList((Object[])new BooleanFormula[]{this.ifm.equal(this._i, this._0), this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._i)), this._0)), this.ifm.lessThan(this._i, this._n), this.ifm.equal(this._k, this.ifm.add(this._i, this._1)), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._k)), this._0)});
        List<BooleanFormula> result = this.enp.extractNewPreds(preds);
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testOnArrayPreds4() throws SolverException, InterruptedException {
        ArrayList preds = Lists.newArrayList((Object[])new BooleanFormula[]{this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.add(this.ifm.makeNumber(1L), this._i))), this._0), this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._i)), this._0)), this.bfm.not(this.ifm.greaterOrEquals(this._i, this._al))});
        List<BooleanFormula> result = this.enp.extractNewPreds(preds);
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testOnArrayPreds5() throws SolverException, InterruptedException {
        ArrayList preds = Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._0)), this._0)), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._0)), this._0), this.ifm.lessOrEquals(this.ifm.add(this.ifm.makeNumber(0L), this.ifm.makeNumber(1L)), this._al)});
        List<BooleanFormula> result = this.enp.extractNewPreds(preds);
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testLinCombPreds() throws SolverException, InterruptedException {
        BooleanFormula wpSafe = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.ifm.lessThan(this._0, this._bl), this.ifm.greaterOrEquals(this._0, this._al)}));
        List<BooleanFormula> result = this.enp.extractNewPreds(wpSafe);
        Truth.assertThat(result).contains((Object)this.ifm.lessThan(this._al, this._bl));
    }
}

