/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.precondition.segkro.interfaces.InterpolationWithCandidates;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class MinCorePrio
implements InterpolationWithCandidates {
    private final CFA cfa;
    private final Solver solver;
    private final LogManager logger;
    private final FormulaManagerView mgrv;
    private final BooleanFormulaManagerView bmgr;

    public MinCorePrio(LogManager pLogger, CFA pCfa, Solver pSolver) {
        this.solver = (Solver)Preconditions.checkNotNull((Object)pSolver);
        this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
        this.cfa = (CFA)Preconditions.checkNotNull((Object)pCfa);
        this.mgrv = pSolver.getFormulaManager();
        this.bmgr = this.mgrv.getBooleanFormulaManager();
    }

    private boolean isInconsistent(BooleanFormula pF1, BooleanFormula pF2) throws SolverException, InterruptedException {
        return this.solver.isUnsat(this.bmgr.and(pF1, pF2));
    }

    @Override
    public BooleanFormula getInterpolant(BooleanFormula pPhiMinus, BooleanFormula pPhiPlus, List<BooleanFormula> pItpCandidatePredicates, CFANode pItpLocation) throws SolverException, InterruptedException {
        Collection<BooleanFormula> resultPredicates = this.getInterpolantAsPredicateCollection(pPhiMinus, pPhiPlus, pItpCandidatePredicates, pItpLocation);
        if (resultPredicates.isEmpty()) {
            return pPhiMinus;
        }
        BooleanFormula result = this.bmgr.makeBoolean(true);
        for (BooleanFormula p : resultPredicates) {
            result = this.bmgr.and(result, p);
        }
        return result;
    }

    protected Set<BooleanFormula> predicatesOnlyOnLiveVariables(Set<BooleanFormula> pFrom, final CFANode pLocation) {
        return Sets.filter(pFrom, (Predicate)new Predicate<BooleanFormula>(){

            public boolean apply(BooleanFormula pArg0) {
                Set<String> predOnVars = MinCorePrio.this.mgrv.extractVariableNames(pArg0);
                for (String instantiatedVarName : predOnVars) {
                    String varName = (String)FormulaManagerView.parseName(instantiatedVarName).getFirst();
                    if (((LiveVariables)MinCorePrio.this.cfa.getLiveVariables().get()).isVariableLive(varName, pLocation)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    public Collection<BooleanFormula> getInterpolantAsPredicateCollection(BooleanFormula pPhiMinus, BooleanFormula pPhiPlus, List<BooleanFormula> pItpCandidatePredicates, CFANode pItpLocation) throws SolverException, InterruptedException {
        Preconditions.checkNotNull((Object)pPhiMinus);
        Preconditions.checkNotNull((Object)pPhiPlus);
        HashSet resultPredicates = Sets.newHashSet(this.mgrv.extractLiterals(pPhiMinus, false, false, false));
        if (!this.isInconsistent(pPhiMinus, pPhiPlus)) {
            this.logger.log(Level.WARNING, new Object[]{"MinCorePrio: Formulas not inconsistent! The over-approximation of the system might be insufficient!"});
            return resultPredicates;
        }
        ImmutableList candidatesPrime = ImmutableList.builder().addAll((Iterable)resultPredicates).addAll(pItpCandidatePredicates).build();
        resultPredicates.addAll(pItpCandidatePredicates);
        for (BooleanFormula f : candidatesPrime) {
            HashSet resultPredicatesMinusF = Sets.newHashSet((Iterable)resultPredicates);
            resultPredicatesMinusF.remove(f);
            if (resultPredicatesMinusF.isEmpty()) {
                return resultPredicates;
            }
            boolean stillInconsistent = this.isInconsistent(this.bmgr.and(Lists.newArrayList((Iterable)resultPredicatesMinusF)), pPhiPlus);
            if (!stillInconsistent) continue;
            resultPredicates.remove(f);
        }
        return resultPredicates;
    }
}

