/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro;

import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.ExtractNewPreds;
import org.sosy_lab.cpachecker.util.precondition.segkro.MinCorePrio;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.RuleEngine;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.ArrayFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;
import org.sosy_lab.cpachecker.util.test.SolverBasedTest0;

public class MinCorePrioTest0
extends SolverBasedTest0 {
    private MinCorePrio mcp;
    private ExtractNewPreds enp;
    private FormulaManagerView mgrv;
    private ArrayFormulaManagerView afm;
    private BooleanFormulaManagerView bfm;
    private NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> ifm;
    private Solver solver;
    private NumeralFormula.IntegerFormula _0;
    private NumeralFormula.IntegerFormula _1;
    private NumeralFormula.IntegerFormula _i;
    private NumeralFormula.IntegerFormula _al;
    private NumeralFormula.IntegerFormula _bl;
    private ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> _b;

    @Override
    protected FormulaManagerFactory.Solvers solverToUse() {
        return FormulaManagerFactory.Solvers.Z3;
    }

    @Before
    public void setUp() throws Exception {
        this.mgrv = new FormulaManagerView(this.factory, this.config, TestLogManager.getInstance());
        this.solver = new Solver(this.mgrv, this.factory, this.config, TestLogManager.getInstance());
        this.afm = this.mgrv.getArrayFormulaManager();
        this.bfm = this.mgrv.getBooleanFormulaManager();
        this.ifm = this.mgrv.getIntegerFormulaManager();
        RuleEngine rulesEngine = new RuleEngine(this.logger, this.solver);
        this.mcp = new MinCorePrio(this.logger, (CFA)Mockito.mock(CFA.class), this.solver);
        this.enp = new ExtractNewPreds(this.solver, rulesEngine);
        this._0 = this.ifm.makeNumber(0L);
        this._1 = this.ifm.makeNumber(1L);
        this._i = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "i");
        this._al = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "al");
        this._bl = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "bl");
        this._b = this.afm.makeArray("b", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
    }

    @Test
    public void testWpPair1() throws SolverException, InterruptedException {
        BooleanFormula wpUnsafe = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.ifm.greaterOrEquals(this.ifm.add(this._i, this._1), this._al), this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.add(this._i, this._1))), this._0)), this.ifm.lessThan(this._i, this._al), this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._i)), this._0))}));
        BooleanFormula wpSafe = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._i)), this._0)), this.ifm.lessOrEquals(this.ifm.add(this._i, this._1), this._al), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.add(this._i, this._1))), this._0)}));
        Truth.assertThat((Boolean)this.solver.isUnsat(this.bfm.and(wpUnsafe, wpSafe))).isTrue();
        List<BooleanFormula> interpolantCandidates = this.enp.extractNewPreds(wpUnsafe);
        BooleanFormula interpolant = this.mcp.getInterpolant(wpSafe, wpUnsafe, interpolantCandidates, null);
        Truth.assertThat((Boolean)this.solver.isUnsat(this.bfm.and(interpolant, wpSafe))).isTrue();
    }

    @Test
    public void testWpPair2() throws SolverException, InterruptedException {
        BooleanFormula wpUnsafe = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.ifm.greaterOrEquals(this._1, this._al), this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._1)), this._0)), this.ifm.lessThan(this._0, this._al), this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._0)), this._0))}));
        BooleanFormula wpSafe = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._0)), this._0)), this.ifm.lessOrEquals(this._1, this._al), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._1)), this._0)}));
        Truth.assertThat((Boolean)this.solver.isUnsat(this.bfm.and(wpUnsafe, wpSafe))).isTrue();
        List<BooleanFormula> interpolantCandidates = this.enp.extractNewPreds(wpUnsafe);
        BooleanFormula interpolant = this.mcp.getInterpolant(wpSafe, wpUnsafe, interpolantCandidates, null);
        Truth.assertThat((Boolean)this.solver.isUnsat(this.bfm.and(interpolant, wpSafe))).isTrue();
    }

    @Test
    public void testLinCombinRemoval() throws SolverException, InterruptedException {
        BooleanFormula linCombi = this.ifm.lessThan(this._al, this._bl);
        ArrayList candidates = Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.lessOrEquals(this._bl, this._0)), this.ifm.greaterOrEquals(this._0, this._al), linCombi});
        BooleanFormula phiMinus = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.ifm.greaterOrEquals(this._0, this._al), this.bfm.not(this.ifm.lessOrEquals(this._bl, this._0)), this.bfm.not(this.ifm.lessOrEquals(this._bl, this._0)), this.ifm.greaterOrEquals(this._0, this._al), this.ifm.lessThan(this._al, this._bl)}));
        BooleanFormula phiPlus = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.greaterOrEquals(this._0, this._al)), this.bfm.not(this.ifm.lessOrEquals(this._bl, this._0))}));
        Collection<BooleanFormula> resultingInterpolantPreds = this.mcp.getInterpolantAsPredicateCollection(phiMinus, phiPlus, candidates, null);
        BooleanFormula resultingInterpolant = this.bfm.and(Lists.newArrayList(resultingInterpolantPreds));
        BooleanFormula betterInterpolant = this.bfm.and(linCombi, this.ifm.greaterOrEquals(this._0, this._al));
        Truth.assertThat((Boolean)this.solver.isUnsat(this.bfm.and(resultingInterpolant, phiPlus))).isTrue();
        Truth.assertThat((Boolean)this.solver.isUnsat(this.bfm.and(betterInterpolant, phiPlus))).isTrue();
        Truth.assertThat((Boolean)this.solver.isUnsat(this.bfm.and(linCombi, phiPlus))).isTrue();
        Truth.assertThat(resultingInterpolantPreds).contains((Object)linCombi);
    }

    @Test
    public void testWpExample2() throws SolverException, InterruptedException {
        BooleanFormula phiMinus = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.equal(this.ifm.makeVariable("p"), this.ifm.makeNumber(1L))), this.ifm.lessOrEquals(this.ifm.makeVariable("a"), this.ifm.makeNumber(1000L))}));
        BooleanFormula phiPlus = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.ifm.equal(this.ifm.makeVariable("p"), this.ifm.makeNumber(1L)), this.ifm.greaterThan(this.ifm.makeVariable("a"), this.ifm.makeNumber(50L))}));
        ArrayList candidates = Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.equal(this.ifm.makeVariable("p"), this.ifm.makeNumber(1L))), this.ifm.lessOrEquals(this.ifm.makeVariable("a"), this.ifm.makeNumber(1000L)), this.ifm.equal(this.ifm.makeVariable("p"), this.ifm.makeNumber(1L)), this.ifm.greaterThan(this.ifm.makeVariable("a"), this.ifm.makeNumber(50L))});
        Truth.assertThat((Boolean)this.solver.isUnsat(this.bfm.and(phiMinus, phiPlus))).isTrue();
        Collection<BooleanFormula> result = this.mcp.getInterpolantAsPredicateCollection(phiMinus, phiPlus, candidates, null);
        Truth.assertThat(result).contains((Object)this.bfm.not(this.ifm.equal(this.ifm.makeVariable("p"), this.ifm.makeNumber(1L))));
    }
}

