/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.algorithm.precondition.PreconditionHelper;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.ExtractNewPreds;
import org.sosy_lab.cpachecker.util.precondition.segkro.interfaces.InterpolationWithCandidates;
import org.sosy_lab.cpachecker.util.precondition.segkro.interfaces.PreconditionRefiner;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManagerImpl;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;
import org.sosy_lab.cpachecker.util.predicates.pathformula.pointeraliasing.PointerTargetSet;

public class RefineSolverBasedItp
implements PreconditionRefiner {
    private final InterpolationWithCandidates ipc;
    private final BooleanFormulaManagerView bmgr;
    private final PathFormulaManager pmgrFwd;
    private final PreconditionHelper helper;
    private final FormulaManagerView mgrv;
    private final AbstractionManager amgr;
    private final ExtractNewPreds enp;

    public RefineSolverBasedItp(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa, Solver pSolver, AbstractionManager pAmgr, ExtractNewPreds pExtractNewPreds, InterpolationWithCandidates pMinCorePrio) throws InvalidConfigurationException {
        this.amgr = pAmgr;
        this.enp = pExtractNewPreds;
        this.ipc = pMinCorePrio;
        this.mgrv = pSolver.getFormulaManager();
        this.bmgr = this.mgrv.getBooleanFormulaManager();
        this.pmgrFwd = new PathFormulaManagerImpl(this.mgrv, pConfig, pLogger, pShutdownNotifier, pCfa, AnalysisDirection.FORWARD);
        this.helper = new PreconditionHelper(this.mgrv, pConfig, pLogger, pShutdownNotifier, pCfa);
    }

    private Collection<BooleanFormula> literals(BooleanFormula pF, FormulaMode pMode) {
        return this.mgrv.extractLiterals(pF, false, false, pMode == FormulaMode.UNINSTANTIATED);
    }

    @VisibleForTesting
    BooleanFormula interpolate(BooleanFormula pPreconditionA, BooleanFormula pPreconditionB, ARGPath.PathPosition pItpPosition) throws SolverException, InterruptedException {
        List<BooleanFormula> p = this.enp.extractNewPreds(pPreconditionA);
        BooleanFormula f = p.size() == 0 ? pPreconditionA : this.bmgr.and(pPreconditionA, this.bmgr.and(p));
        return this.ipc.getInterpolant(f, pPreconditionB, p, null);
    }

    private PathFormula pre(ARGPath.PathPosition pPreForPosition, FormulaMode pMode) throws CPATransferException, SolverException, InterruptedException {
        ARGPath pathToPosition = pPreForPosition.getPath();
        PathFormula pf = this.helper.computePathformulaForArbitraryTrace(pathToPosition, pPreForPosition);
        BooleanFormula f = this.mgrv.eliminateDeadVariables(pf.getFormula(), pf.getSsa());
        if (pMode == FormulaMode.UNINSTANTIATED) {
            return this.alterPf(this.pmgrFwd.makeEmptyPathFormula(), this.mgrv.uninstantiate(f));
        }
        return this.alterPf(pf, f);
    }

    @VisibleForTesting
    List<ReversedEdge> getReversedTrace(ARGPath pTrace) {
        ArrayList result = Lists.newArrayListWithCapacity((int)pTrace.asEdgesList().size());
        for (CFAEdge g : Lists.reverse(pTrace.asEdgesList())) {
            if (g == null) continue;
            result.add(new ReversedEdge(g));
        }
        return result;
    }

    private Multimap<CFANode, BooleanFormula> predsFromTrace(ARGPath.PathPosition pFinalWpPosition, PathFormula pInstanciatedTracePrecond) throws SolverException, InterruptedException, CPATransferException {
        Preconditions.checkNotNull((Object)pInstanciatedTracePrecond);
        Preconditions.checkNotNull((Object)pFinalWpPosition);
        ImmutableMultimap.Builder result = ImmutableMultimap.builder();
        PathFormula preAtK = pInstanciatedTracePrecond;
        ARGPath.PathIterator reverseIt = pFinalWpPosition.reverseIterator();
        while (reverseIt.hasNext()) {
            PathFormula preAtKp1;
            CFAEdge t = reverseIt.getIncomingEdge();
            ARGPath.PathPosition currentPos = reverseIt.getPosition();
            reverseIt.advance();
            ARGPath.PathPosition nextPos = reverseIt.getPosition();
            if (t == null || t.getEdgeType() == CFAEdgeType.BlankEdge || this.bmgr.isTrue((preAtKp1 = this.pre(nextPos, FormulaMode.INSTANTIATED)).getFormula())) continue;
            List<BooleanFormula> predsNew = this.enp.extractNewPreds(preAtKp1.getFormula());
            if (predsNew.size() > 0) {
                preAtKp1 = this.alterPf(preAtKp1, this.bmgr.and(preAtKp1.getFormula(), this.bmgr.and(predsNew)));
            }
            PathFormula transFromPreAtK = this.computeCounterCondition(t, this.alterPf(preAtK, this.bmgr.not(preAtK.getFormula())));
            SSAMap instantiateWith = transFromPreAtK.getSsa();
            preAtK = this.alterPf(transFromPreAtK, this.ipc.getInterpolant(this.mgrv.instantiate(preAtKp1.getFormula(), instantiateWith), transFromPreAtK.getFormula(), this.mgrv.instantiate(predsNew, instantiateWith), t.getSuccessor()));
            result.putAll((Object)t.getSuccessor(), this.literals(preAtK.getFormula(), FormulaMode.UNINSTANTIATED));
        }
        return result.build();
    }

    private PathFormula computeCounterCondition(CFAEdge pTransition, PathFormula pCounterStatePrecond) throws CPATransferException, InterruptedException, SolverException {
        return this.pmgrFwd.makeAnd(pCounterStatePrecond, pTransition);
    }

    private PathFormula alterPf(PathFormula pPf, BooleanFormula pF) {
        return new PathFormula(pF, pPf.getSsa(), PointerTargetSet.emptyPointerTargetSet(), 1);
    }

    @Override
    public PredicatePrecision refine(ARGPath.PathPosition pTraceFromViolation, ARGPath.PathPosition pTraceFromValidTermination) throws SolverException, InterruptedException, CPATransferException {
        PathFormula pcViolation = this.pre(pTraceFromViolation, FormulaMode.INSTANTIATED);
        PathFormula pcValid = this.pre(pTraceFromValidTermination, FormulaMode.INSTANTIATED);
        pcViolation = this.alterPf(pcViolation, this.interpolate(pcViolation.getFormula(), pcValid.getFormula(), pTraceFromViolation));
        pcValid = this.alterPf(pcValid, this.interpolate(pcValid.getFormula(), pcViolation.getFormula(), pTraceFromValidTermination));
        ImmutableList.Builder globalPreds = ImmutableList.builder();
        ImmutableMultimap.Builder localPreds = ImmutableMultimap.builder();
        globalPreds.addAll(this.literals(pcViolation.getFormula(), FormulaMode.UNINSTANTIATED));
        globalPreds.addAll(this.literals(pcValid.getFormula(), FormulaMode.UNINSTANTIATED));
        Multimap<CFANode, BooleanFormula> predsViolation = this.predsFromTrace(pTraceFromViolation, pcViolation);
        localPreds.putAll(predsViolation);
        Multimap<CFANode, BooleanFormula> predsFromValid = this.predsFromTrace(pTraceFromValidTermination, pcValid);
        localPreds.putAll(predsFromValid);
        return this.predicatesAsGlobalPrecision((ImmutableList<BooleanFormula>)globalPreds.build(), (ImmutableMultimap<CFANode, BooleanFormula>)localPreds.build());
    }

    private PredicatePrecision predicatesAsGlobalPrecision(ImmutableList<BooleanFormula> pGlobalPreds, ImmutableMultimap<CFANode, BooleanFormula> pLocalPreds) {
        AbstractionPredicate ap;
        HashMultimap locationInstancePredicates = HashMultimap.create();
        HashMultimap localPredicates = HashMultimap.create();
        HashMultimap functionPredicates = HashMultimap.create();
        ArrayList globalPredicates = Lists.newArrayList();
        for (BooleanFormula f : pLocalPreds.values()) {
            ap = this.amgr.makePredicate(f);
            globalPredicates.add(ap);
        }
        for (BooleanFormula f : pGlobalPreds) {
            ap = this.amgr.makePredicate(f);
            globalPredicates.add(ap);
        }
        return new PredicatePrecision((Multimap<Pair<CFANode, Integer>, AbstractionPredicate>)locationInstancePredicates, (Multimap<CFANode, AbstractionPredicate>)localPredicates, (Multimap<String, AbstractionPredicate>)functionPredicates, globalPredicates);
    }

    @VisibleForTesting
    static class ReversedEdge {
        private CFAEdge original;

        public ReversedEdge(CFAEdge pOriginal) {
            Preconditions.checkNotNull((Object)pOriginal);
            this.original = pOriginal;
        }

        public CFAEdge getOriginal() {
            return this.original;
        }

        public CFAEdgeType getEdgeType() {
            return this.original.getEdgeType();
        }

        public CFANode getPredecessor() {
            return this.original.getSuccessor();
        }

        public CFANode getSuccessor() {
            return this.original.getPredecessor();
        }

        public String toString() {
            return this.getPredecessor() + " -{" + this.original.getDescription().replaceAll("\n", " ") + "}-> " + this.getSuccessor();
        }
    }

    private static enum PreMode {
        ELIMINATE_DEAD;

    }

    private static enum FormulaMode {
        INSTANTIATED,
        UNINSTANTIATED;

    }
}

