/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import org.junit.Before;
import org.mockito.Mockito;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.precondition.segkro.ExtractNewPreds;
import org.sosy_lab.cpachecker.util.precondition.segkro.MinCorePrio;
import org.sosy_lab.cpachecker.util.precondition.segkro.Refine;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.RuleEngine;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.bdd.BDDManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.test.SolverBasedTest0;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

public class RefineTest0
extends SolverBasedTest0 {
    private Refine refine;
    private FormulaManagerView mgrv;
    private CFAEdge _label_error;
    private CFAEdge _assume_i_geq_al;
    private CFAEdge _assume_b_at_i_neq_0;
    private CFAEdge _while;
    private CFAEdge _stmt_i_assign_0;
    private CFAEdge _stmt_declare_i;
    private CFAEdge _dummy;
    private CFAEdge _function_declaration;
    private CFAEdge _stmt_al_assign_0;
    private CAssumeEdge _assume_not_b_at_i_neq_0;
    private CDeclarationEdge _stmt_declare_al;
    private CFAEdge _stmt_a_at_i_assign_b_at_i;
    private CFAEdge _stmt_i_assign_i_plus_1;
    private CAssumeEdge _assume_p_neq_1;
    private CAssumeEdge _assume_p_eq_1;
    private CAssumeEdge _assume_x_leq_1000;
    private CAssumeEdge _assume_x_gt_1000;
    private CAssumeEdge _assume_x_gt_50;
    private CAssumeEdge _assume_x_leq_50;
    private CExpression _50;
    private CAssumeEdge _assume_x_geq_al;
    private CFANode _loc_1;
    private CFANode _loc_2;
    private CFANode _loc_3;
    private CFANode _loc_err;
    private CFANode _loc_end;

    @Override
    protected FormulaManagerFactory.Solvers solverToUse() {
        return FormulaManagerFactory.Solvers.Z3;
    }

    @Override
    protected ConfigurationBuilder createTestConfigBuilder() throws InvalidConfigurationException {
        ConfigurationBuilder result = super.createTestConfigBuilder();
        result.setOption("cpa.predicate.handlePointerAliasing", "false");
        result.setOption("cpa.predicate.handleArrays", "true");
        return result;
    }

    @Before
    public void setUp() throws Exception {
        CFA cfa = (CFA)Mockito.mock(CFA.class);
        Mockito.when((Object)((Object)cfa.getMachineModel())).thenReturn((Object)MachineModel.LINUX64);
        Mockito.when(cfa.getVarClassification()).thenReturn((Object)Optional.absent());
        this.mgrv = new FormulaManagerView(this.factory, this.config, TestLogManager.getInstance());
        Solver solver = new Solver(this.mgrv, this.factory, this.config, TestLogManager.getInstance());
        RuleEngine ruleEngine = new RuleEngine(this.logger, solver);
        ExtractNewPreds enp = new ExtractNewPreds(solver, ruleEngine);
        MinCorePrio ipc = new MinCorePrio(this.logger, (CFA)Mockito.mock(CFA.class), solver);
        RegionManager regionManager = new BDDManagerFactory(this.config, this.logger).createRegionManager();
        AbstractionManager amgr = new AbstractionManager(regionManager, this.mgrv, this.config, this.logger);
        this.refine = new Refine(this.config, this.logger, ShutdownNotifier.create(), cfa, solver, amgr, enp, ipc);
        CBinaryExpressionBuilder expressionBuilder = new CBinaryExpressionBuilder(MachineModel.LINUX64, TestLogManager.getInstance());
        CArrayType unlimitedIntArrayType = new CArrayType(false, false, CNumericTypes.INT, null);
        Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _i_decl = TestDataTools.makeDeclaration("i", CNumericTypes.INT, null);
        Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _x_decl = TestDataTools.makeDeclaration("x", CNumericTypes.INT, null);
        Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _p_decl = TestDataTools.makeDeclaration("p", CNumericTypes.INT, null);
        Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _al_decl = TestDataTools.makeDeclaration("al", CNumericTypes.INT, TestDataTools.INT_ZERO_INITIALIZER);
        Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _a = TestDataTools.makeDeclaration("a", unlimitedIntArrayType, null);
        Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> _b = TestDataTools.makeDeclaration("b", unlimitedIntArrayType, null);
        Triple<CDeclarationEdge, CFunctionDeclaration, CFunctionType> _funct_decl = TestDataTools.makeFunctionDeclaration("copy", CVoidType.VOID, Lists.newArrayList((Object[])new CParameterDeclaration[]{new CParameterDeclaration(FileLocation.DUMMY, unlimitedIntArrayType, "a"), new CParameterDeclaration(FileLocation.DUMMY, unlimitedIntArrayType, "b")}));
        CIdExpression _i = (CIdExpression)_i_decl.getThird();
        CIdExpression _p = (CIdExpression)_p_decl.getThird();
        CIdExpression _x = (CIdExpression)_x_decl.getThird();
        CIdExpression _al = TestDataTools.makeVariable("al", CNumericTypes.INT);
        CIntegerLiteralExpression _0 = CIntegerLiteralExpression.createDummyLiteral(0L, CNumericTypes.INT);
        CIntegerLiteralExpression _1 = CIntegerLiteralExpression.createDummyLiteral(1L, CNumericTypes.INT);
        CIntegerLiteralExpression _50 = CIntegerLiteralExpression.createDummyLiteral(50L, CNumericTypes.INT);
        CIntegerLiteralExpression _1000 = CIntegerLiteralExpression.createDummyLiteral(1000L, CNumericTypes.INT);
        CBinaryExpression _i_plus_1 = expressionBuilder.buildBinaryExpression(_i, _1, CBinaryExpression.BinaryOperator.PLUS);
        CArraySubscriptExpression _b_at_i = new CArraySubscriptExpression(FileLocation.DUMMY, unlimitedIntArrayType, (CExpression)_b.getThird(), _i);
        CArraySubscriptExpression _a_at_i = new CArraySubscriptExpression(FileLocation.DUMMY, unlimitedIntArrayType, (CExpression)_a.getThird(), _i);
        this._while = TestDataTools.makeBlankEdge("while");
        this._dummy = TestDataTools.makeBlankEdge("dummy");
        this._label_error = TestDataTools.makeBlankEdge("ERROR");
        this._assume_i_geq_al = (CFAEdge)TestDataTools.makeAssume(expressionBuilder.buildBinaryExpression(_i, _al, CBinaryExpression.BinaryOperator.GREATER_EQUAL)).getFirst();
        this._assume_b_at_i_neq_0 = (CFAEdge)TestDataTools.makeAssume(expressionBuilder.buildBinaryExpression(_b_at_i, _0, CBinaryExpression.BinaryOperator.NOT_EQUALS)).getFirst();
        this._assume_not_b_at_i_neq_0 = (CAssumeEdge)TestDataTools.makeNegatedAssume(expressionBuilder.buildBinaryExpression(_b_at_i, _0, CBinaryExpression.BinaryOperator.NOT_EQUALS)).getFirst();
        this._loc_1 = new CFANode("1");
        this._loc_2 = new CFANode("2");
        this._loc_3 = new CFANode("3");
        this._loc_err = new CFANode("err");
        this._loc_end = new CFANode("end");
        this._assume_x_gt_1000 = (CAssumeEdge)TestDataTools.makeAssume(expressionBuilder.buildBinaryExpression(_x, _1000, CBinaryExpression.BinaryOperator.GREATER_THAN), this._loc_2, this._loc_err).getFirst();
        this._assume_x_leq_1000 = (CAssumeEdge)TestDataTools.makeAssume(expressionBuilder.buildBinaryExpression(_x, _1000, CBinaryExpression.BinaryOperator.LESS_EQUAL), this._loc_2, this._loc_end).getFirst();
        this._assume_x_gt_50 = (CAssumeEdge)TestDataTools.makeAssume(expressionBuilder.buildBinaryExpression(_x, _50, CBinaryExpression.BinaryOperator.GREATER_THAN), this._loc_3, this._loc_err).getFirst();
        this._assume_x_leq_50 = (CAssumeEdge)TestDataTools.makeAssume(expressionBuilder.buildBinaryExpression(_x, _50, CBinaryExpression.BinaryOperator.LESS_EQUAL), this._loc_3, this._loc_end).getFirst();
        this._assume_p_neq_1 = (CAssumeEdge)TestDataTools.makeAssume(expressionBuilder.buildBinaryExpression(_p, _1, CBinaryExpression.BinaryOperator.NOT_EQUALS), this._loc_1, this._loc_2).getFirst();
        this._assume_p_eq_1 = (CAssumeEdge)TestDataTools.makeAssume(expressionBuilder.buildBinaryExpression(_p, _1, CBinaryExpression.BinaryOperator.EQUALS), this._loc_1, this._loc_3).getFirst();
        this._assume_p_neq_1 = (CAssumeEdge)TestDataTools.makeAssume(expressionBuilder.buildBinaryExpression(_p, _1, CBinaryExpression.BinaryOperator.NOT_EQUALS), this._loc_1, this._loc_2).getFirst();
        this._assume_p_eq_1 = (CAssumeEdge)TestDataTools.makeAssume(expressionBuilder.buildBinaryExpression(_p, _1, CBinaryExpression.BinaryOperator.EQUALS), this._loc_1, this._loc_3).getFirst();
        this._stmt_a_at_i_assign_b_at_i = (CFAEdge)TestDataTools.makeAssignment(_a_at_i, _b_at_i).getFirst();
        this._stmt_i_assign_0 = (CFAEdge)TestDataTools.makeAssignment(_i, _0).getFirst();
        this._stmt_i_assign_i_plus_1 = (CFAEdge)TestDataTools.makeAssignment(_i, _i_plus_1).getFirst();
        this._stmt_al_assign_0 = (CFAEdge)TestDataTools.makeAssignment(_al, _0).getFirst();
        this._stmt_declare_i = (CFAEdge)_i_decl.getFirst();
        this._stmt_declare_al = (CDeclarationEdge)_al_decl.getFirst();
        this._function_declaration = (CFAEdge)_funct_decl.getFirst();
    }
}

