/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.interfaces.Premise;
import org.sosy_lab.cpachecker.util.precondition.segkro.interfaces.Rule;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatcher;

public abstract class AbstractRule
implements Rule {
    protected final Solver solver;
    protected final SmtAstMatcher matcher;
    protected final List<Premise> premises;

    public AbstractRule(Solver pSolver, SmtAstMatcher pMatcher) {
        this.solver = pSolver;
        this.matcher = pMatcher;
        this.premises = Lists.newArrayList();
    }

    @Override
    public String getRuleName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Set<BooleanFormula> apply(BooleanFormula pInput) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("Implement me in the child class if needed!");
    }

    @Override
    public Set<BooleanFormula> apply(Collection<BooleanFormula> pConjunctiveInputPredicates) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("Implement me in the child class if needed!");
    }

    @Override
    public Set<BooleanFormula> applyWithInputRelatingPremises(List<BooleanFormula> pConjunctiveInputPredicates) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("Implement me in the child class if needed!");
    }

    @Override
    public ImmutableList<Premise> getPremises() {
        return ImmutableList.copyOf(this.premises);
    }

    public String toString() {
        return this.getRuleName();
    }
}

