/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.interfaces.Canonicalizer;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedPremise;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedRule;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatcher;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPattern;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternBuilder;

public class DefaultCanonicalizer
implements Canonicalizer {
    private final List<PatternBasedRule> axioms = Lists.newArrayList();

    public DefaultCanonicalizer(Solver pSolver, SmtAstMatcher pSmtAstMatcher) {
        this.axioms.add(new TransformDoubleNegations(pSolver, pSmtAstMatcher));
        this.axioms.add(new TranswformNotGreaterThan(pSolver, pSmtAstMatcher));
        this.axioms.add(new TransformNotLessOrEq(pSolver, pSmtAstMatcher));
    }

    @Override
    public BooleanFormula canonicalize(BooleanFormula pPredicate) throws SolverException, InterruptedException {
        BooleanFormula result = pPredicate;
        for (PatternBasedRule a : this.axioms) {
            Set<BooleanFormula> returned = a.apply(result);
            if (returned.size() != 1) continue;
            result = returned.iterator().next();
        }
        return result;
    }

    @Override
    public Collection<BooleanFormula> canonicalize(Collection<BooleanFormula> pPredicates) throws SolverException, InterruptedException {
        ArrayList result = Lists.newArrayListWithCapacity((int)pPredicates.size());
        for (BooleanFormula p : pPredicates) {
            result.add(this.canonicalize(p));
        }
        return result;
    }

    private class TranswformNotGreaterThan
    extends PatternBasedRule {
        public TranswformNotGreaterThan(Solver pSolver, SmtAstMatcher pMatcher) {
            super(pSolver, pMatcher);
        }

        @Override
        protected void setupPatterns() {
            this.premises.add(new PatternBasedPremise(SmtAstPatternBuilder.or(SmtAstPatternBuilder.match("not", new SmtAstPattern[]{SmtAstPatternBuilder.match(">", new SmtAstPattern[]{SmtAstPatternBuilder.matchNumeralExpressionBind("a"), SmtAstPatternBuilder.matchNumeralExpressionBind("b")})}))));
        }

        @Override
        protected Collection<BooleanFormula> deriveConclusion(Map<String, Formula> pAssignment) {
            NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)Preconditions.checkNotNull((Object)pAssignment.get("a"));
            NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)Preconditions.checkNotNull((Object)pAssignment.get("b"));
            return Lists.newArrayList((Object[])new BooleanFormula[]{this.ifm.lessOrEquals(a, b)});
        }
    }

    private class TransformNotLessOrEq
    extends PatternBasedRule {
        public TransformNotLessOrEq(Solver pSolver, SmtAstMatcher pMatcher) {
            super(pSolver, pMatcher);
        }

        @Override
        protected void setupPatterns() {
            this.premises.add(new PatternBasedPremise(SmtAstPatternBuilder.or(SmtAstPatternBuilder.match("not", new SmtAstPattern[]{SmtAstPatternBuilder.match("<=", new SmtAstPattern[]{SmtAstPatternBuilder.matchNumeralExpressionBind("a"), SmtAstPatternBuilder.matchNumeralExpressionBind("b")})}))));
        }

        @Override
        protected Collection<BooleanFormula> deriveConclusion(Map<String, Formula> pAssignment) {
            NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)Preconditions.checkNotNull((Object)pAssignment.get("a"));
            NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)Preconditions.checkNotNull((Object)pAssignment.get("b"));
            return Lists.newArrayList((Object[])new BooleanFormula[]{this.ifm.greaterThan(a, b)});
        }
    }

    private class TransformDoubleNegations
    extends PatternBasedRule {
        public TransformDoubleNegations(Solver pSolver, SmtAstMatcher pMatcher) {
            super(pSolver, pMatcher);
        }

        @Override
        protected void setupPatterns() {
            this.premises.add(new PatternBasedPremise(SmtAstPatternBuilder.or(SmtAstPatternBuilder.match("not", new SmtAstPattern[]{SmtAstPatternBuilder.match("not", new SmtAstPattern[]{SmtAstPatternBuilder.matchAnyWithAnyArgsBind("f")})}))));
        }

        @Override
        protected Collection<BooleanFormula> deriveConclusion(Map<String, Formula> pAssignment) {
            BooleanFormula f = (BooleanFormula)Preconditions.checkNotNull((Object)pAssignment.get("f"));
            return Collections.singleton(f);
        }
    }
}

