/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.GenericPatterns;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedPremise;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedRule;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatcher;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPattern;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternBuilder;

public class EliminationRule
extends PatternBasedRule {
    public EliminationRule(Solver pSolver, SmtAstMatcher pMatcher) {
        super(pSolver, pMatcher);
    }

    @Override
    protected void setupPatterns() {
        this.premises.add(new PatternBasedPremise(SmtAstPatternBuilder.or(SmtAstPatternBuilder.match(">=", new SmtAstPattern[]{SmtAstPatternBuilder.match("+", new SmtAstPattern[]{SmtAstPatternBuilder.match("*", new SmtAstPattern[]{SmtAstPatternBuilder.matchNullaryBind("c1"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("eX")}), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("e1")}), SmtAstPatternBuilder.matchNullary("0")}))));
        this.premises.add(new PatternBasedPremise(SmtAstPatternBuilder.or(SmtAstPatternBuilder.match(">=", SmtAstPatternBuilder.and(GenericPatterns.substraction(SmtAstPatternBuilder.matchAnyWithAnyArgsBind("e2"), SmtAstPatternBuilder.match("*", new SmtAstPattern[]{SmtAstPatternBuilder.matchNullaryBind("c2"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("eX")})), SmtAstPatternBuilder.matchNullary("0"))), SmtAstPatternBuilder.match(">=", new SmtAstPattern[]{SmtAstPatternBuilder.match("+", new SmtAstPattern[]{SmtAstPatternBuilder.match("*", new SmtAstPattern[]{SmtAstPatternBuilder.match("-", new SmtAstPattern[]{SmtAstPatternBuilder.matchNullary("0"), SmtAstPatternBuilder.matchNullaryBind("c2")}), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("eX")}), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("e2")}), SmtAstPatternBuilder.matchNullary("0")}))));
    }

    @Override
    protected boolean satisfiesConstraints(Map<String, Formula> pAssignment) throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula zero = this.fmv.getIntegerFormulaManager().makeNumber(0L);
        NumeralFormula.IntegerFormula c1 = (NumeralFormula.IntegerFormula)Preconditions.checkNotNull((Object)pAssignment.get("c1"));
        NumeralFormula.IntegerFormula c2 = (NumeralFormula.IntegerFormula)Preconditions.checkNotNull((Object)pAssignment.get("c2"));
        return !this.solver.isUnsat(this.bfm.and(this.ifm.greaterThan(c1, zero), this.ifm.greaterThan(c2, zero)));
    }

    @Override
    protected Collection<BooleanFormula> deriveConclusion(Map<String, Formula> pAssignment) {
        NumeralFormula.IntegerFormula zero = this.fmv.getIntegerFormulaManager().makeNumber(0L);
        NumeralFormula.IntegerFormula c1 = (NumeralFormula.IntegerFormula)Preconditions.checkNotNull((Object)pAssignment.get("c1"));
        NumeralFormula.IntegerFormula c2 = (NumeralFormula.IntegerFormula)Preconditions.checkNotNull((Object)pAssignment.get("c2"));
        NumeralFormula.IntegerFormula e1 = (NumeralFormula.IntegerFormula)Preconditions.checkNotNull((Object)pAssignment.get("e1"));
        NumeralFormula.IntegerFormula e2 = (NumeralFormula.IntegerFormula)Preconditions.checkNotNull((Object)pAssignment.get("e2"));
        return Lists.newArrayList((Object[])new BooleanFormula[]{this.ifm.greaterOrEquals(this.ifm.add(this.ifm.multiply(c2, e1), this.ifm.multiply(c1, e2)), zero)});
    }

    @Override
    protected boolean isValidConclusion(Collection<BooleanFormula> pConjunctiveInputPredicates, Set<BooleanFormula> pResult) throws SolverException, InterruptedException {
        return true;
    }
}

