/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.GenericPatterns;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedPremise;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedRule;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatcher;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternBuilder;

public class ExistentialRule
extends PatternBasedRule {
    public ExistentialRule(Solver pSolver, SmtAstMatcher pMatcher) {
        super(pSolver, pMatcher);
    }

    @Override
    protected void setupPatterns() {
        this.premises.add(new PatternBasedPremise(SmtAstPatternBuilder.or(SmtAstPatternBuilder.matchBind("not", "nf", GenericPatterns.array_at_index_matcher("fx", "i", GenericPatterns.PropositionType.POSITIVE)))));
        this.premises.add(new PatternBasedPremise(SmtAstPatternBuilder.or(GenericPatterns.array_at_index_matcher("f", "j", GenericPatterns.PropositionType.POSITIVE))));
    }

    @Override
    protected boolean satisfiesConstraints(Map<String, Formula> pAssignment) throws SolverException, InterruptedException {
        Formula i = pAssignment.get("i");
        Formula j = pAssignment.get("j");
        assert (i instanceof NumeralFormula.IntegerFormula);
        assert (j instanceof NumeralFormula.IntegerFormula);
        BooleanFormula lt = this.ifm.lessThan((NumeralFormula.IntegerFormula)i, (NumeralFormula.IntegerFormula)j);
        return !this.solver.isUnsat(lt);
    }

    @Override
    protected Collection<BooleanFormula> deriveConclusion(Map<String, Formula> pAssignment) {
        BooleanFormula f = (BooleanFormula)pAssignment.get("f");
        BooleanFormula nf = (BooleanFormula)pAssignment.get("nf");
        NumeralFormula.IntegerFormula i = (NumeralFormula.IntegerFormula)pAssignment.get("i");
        Formula parentOfI = pAssignment.get(SmtAstPatternBuilder.parentOf("i"));
        NumeralFormula.IntegerFormula j = (NumeralFormula.IntegerFormula)pAssignment.get("j");
        Formula parentOfJ = pAssignment.get(SmtAstPatternBuilder.parentOf("j"));
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.ifm.makeVariable("x");
        BooleanFormula nfPrime = (BooleanFormula)this.substituteInParent(parentOfI, i, x, nf);
        BooleanFormula fPrime = (BooleanFormula)this.substituteInParent(parentOfJ, j, x, f);
        return Lists.newArrayList((Object[])new BooleanFormula[]{this.qfm.exists(x, i, j, fPrime), this.qfm.exists(x, i, j, nfPrime)});
    }
}

