/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.GenericPatterns;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedPremise;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedRule;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatcher;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPattern;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternBuilder;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtQuantificationPattern;

public class ExtendRightRule
extends PatternBasedRule {
    public ExtendRightRule(Solver pSolver, SmtAstMatcher pMatcher) {
        super(pSolver, pMatcher);
    }

    @Override
    protected void setupPatterns() {
        this.premises.add(new PatternBasedPremise(SmtAstPatternBuilder.or(GenericPatterns.range_predicate_matcher("exists", SmtQuantificationPattern.QuantifierType.EXISTS, "f", "i", "j", GenericPatterns.array_at_index_matcher("f", SmtAstPatternBuilder.quantified("var"), GenericPatterns.PropositionType.ALL)), GenericPatterns.range_predicate_matcher("forall", SmtQuantificationPattern.QuantifierType.FORALL, "f", "i", "j", GenericPatterns.array_at_index_matcher("f", SmtAstPatternBuilder.quantified("var"), GenericPatterns.PropositionType.ALL)))));
        this.premises.add(new PatternBasedPremise(SmtAstPatternBuilder.or(SmtAstPatternBuilder.matchBind("<", "ext", new SmtAstPattern[]{SmtAstPatternBuilder.matchAnyWithAnyArgsBind("=j"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("k")}), SmtAstPatternBuilder.matchBind("<=", "ext", new SmtAstPattern[]{SmtAstPatternBuilder.matchAnyWithAnyArgsBind("=j"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("k")}), SmtAstPatternBuilder.matchBind("=", "ext", new SmtAstPattern[]{SmtAstPatternBuilder.matchAnyWithAnyArgsBind("=j"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("k")}))));
    }

    @Override
    protected boolean satisfiesConstraints(Map<String, Formula> pAssignment) throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula j = (NumeralFormula.IntegerFormula)Preconditions.checkNotNull((Object)pAssignment.get("j"));
        NumeralFormula.IntegerFormula k = (NumeralFormula.IntegerFormula)Preconditions.checkNotNull((Object)pAssignment.get("k"));
        BooleanFormula ext = (BooleanFormula)Preconditions.checkNotNull((Object)pAssignment.get("ext"));
        return !this.solver.isUnsat(this.bfm.and(this.ifm.greaterOrEquals(k, j), ext));
    }

    @Override
    protected Collection<BooleanFormula> deriveConclusion(Map<String, Formula> pAssignment) {
        BooleanFormula f = (BooleanFormula)pAssignment.get("f");
        NumeralFormula.IntegerFormula i = (NumeralFormula.IntegerFormula)pAssignment.get("i");
        NumeralFormula.IntegerFormula k = (NumeralFormula.IntegerFormula)pAssignment.get("k");
        NumeralFormula.IntegerFormula xBound = (NumeralFormula.IntegerFormula)pAssignment.get(SmtAstPatternBuilder.quantified("var"));
        Formula xBoundParent = pAssignment.get(SmtAstPatternBuilder.parentOf(SmtAstPatternBuilder.quantified("var")));
        NumeralFormula.IntegerFormula xNew = (NumeralFormula.IntegerFormula)this.ifm.makeVariable("x");
        BooleanFormula fNew = (BooleanFormula)this.substituteInParent(xBoundParent, xBound, xNew, f);
        if (pAssignment.containsKey("forall")) {
            return ImmutableSet.of((Object)this.qfm.forall(xNew, i, k, fNew));
        }
        return ImmutableSet.of((Object)this.qfm.exists(xNew, i, k, fNew));
    }

    @Override
    protected boolean isValidConclusion(Collection<BooleanFormula> pConjunctiveInputPredicates, Set<BooleanFormula> pResult) throws SolverException, InterruptedException {
        return true;
    }
}

