/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.GenericPatterns;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedPremise;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedRule;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatcher;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPattern;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternBuilder;

public class LinCombineRule
extends PatternBasedRule {
    private final NumeralFormula.IntegerFormula zero;
    private final NumeralFormula.IntegerFormula one;

    public LinCombineRule(Solver pSolver, SmtAstMatcher pMatcher) {
        super(pSolver, pMatcher);
        this.zero = (NumeralFormula.IntegerFormula)this.ifm.makeNumber(0L);
        this.one = (NumeralFormula.IntegerFormula)this.ifm.makeNumber(1L);
    }

    @Override
    protected void setupPatterns() {
        this.premises.add(new PatternBasedPremise(SmtAstPatternBuilder.or(SmtAstPatternBuilder.matchBind(">=", "geq1", new SmtAstPattern[]{SmtAstPatternBuilder.matchAnyWithAnyArgsBind("e"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("a")}), SmtAstPatternBuilder.matchBind(">=", "geq1", SmtAstPatternBuilder.and(GenericPatterns.substraction("e", "a"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("zero"))), SmtAstPatternBuilder.match(">", new SmtAstPattern[]{SmtAstPatternBuilder.matchAnyWithAnyArgsBind("e"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("a")}), SmtAstPatternBuilder.match(">", SmtAstPatternBuilder.and(GenericPatterns.substraction("e", "a"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("zero"))))));
        this.premises.add(new PatternBasedPremise(SmtAstPatternBuilder.or(SmtAstPatternBuilder.match(">", new SmtAstPattern[]{SmtAstPatternBuilder.matchAnyWithAnyArgsBind("b"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("e")}), SmtAstPatternBuilder.match(">", SmtAstPatternBuilder.and(GenericPatterns.substraction("b", "e"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("zero"))), SmtAstPatternBuilder.matchBind(">=", "geq2", new SmtAstPattern[]{SmtAstPatternBuilder.matchAnyWithAnyArgsBind("b"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("eMinusOne")}))));
    }

    protected boolean checkIfAvailable(Map<String, Formula> pAssignment, String pVar, NumeralFormula.IntegerFormula pIsEqualTo) throws SolverException, InterruptedException {
        Formula f = pAssignment.get(pVar);
        if (f == null) {
            return true;
        }
        if (!(f instanceof NumeralFormula.IntegerFormula)) {
            return false;
        }
        NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)f;
        return this.solver.isUnsat(this.bfm.not(this.ifm.equal(z, pIsEqualTo)));
    }

    @Override
    protected boolean satisfiesConstraints(Map<String, Formula> pAssignment) throws SolverException, InterruptedException {
        Formula a = (Formula)Preconditions.checkNotNull((Object)pAssignment.get("a"));
        Formula b = (Formula)Preconditions.checkNotNull((Object)pAssignment.get("b"));
        if (!(pAssignment.get("e") instanceof NumeralFormula.IntegerFormula)) {
            return false;
        }
        NumeralFormula.IntegerFormula e = (NumeralFormula.IntegerFormula)Preconditions.checkNotNull((Object)pAssignment.get("e"));
        if (a.equals(b)) {
            return false;
        }
        if (!this.checkIfAvailable(pAssignment, "zero", this.zero)) {
            return false;
        }
        if (!this.checkIfAvailable(pAssignment, "one", this.one)) {
            return false;
        }
        return this.checkIfAvailable(pAssignment, "eMinusOne", (NumeralFormula.IntegerFormula)this.ifm.subtract(e, this.one));
    }

    @Override
    protected Collection<BooleanFormula> deriveConclusion(Map<String, Formula> pAssignment) {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)pAssignment.get("a");
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)pAssignment.get("b");
        if (pAssignment.containsKey("geq1") && pAssignment.containsKey("geq2")) {
            return Lists.newArrayList((Object[])new BooleanFormula[]{this.ifm.lessOrEquals(a, b)});
        }
        return Lists.newArrayList((Object[])new BooleanFormula[]{this.ifm.lessThan(a, b)});
    }
}

