/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.GenericPatterns;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedPremise;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedRule;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatcher;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternBuilder;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtQuantificationPattern;

public class LinkRule
extends PatternBasedRule {
    public LinkRule(Solver pSolver, SmtAstMatcher pMatcher) {
        super(pSolver, pMatcher);
    }

    @Override
    protected void setupPatterns() {
        this.premises.add(new PatternBasedPremise(SmtAstPatternBuilder.or(GenericPatterns.range_predicate_matcher("forall", SmtQuantificationPattern.QuantifierType.FORALL, "f", "i", "j", GenericPatterns.array_at_index_matcher("f", SmtAstPatternBuilder.quantified("var1"), GenericPatterns.PropositionType.ALL)))));
        this.premises.add(new PatternBasedPremise(SmtAstPatternBuilder.or(GenericPatterns.range_predicate_matcher("forallRight", SmtQuantificationPattern.QuantifierType.FORALL, "f", "iPlusOneEq", "k", GenericPatterns.array_at_index_matcher("f", SmtAstPatternBuilder.quantified("var2"), GenericPatterns.PropositionType.ALL)))));
    }

    @Override
    protected boolean satisfiesConstraints(Map<String, Formula> pAssignment) throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula i = (NumeralFormula.IntegerFormula)pAssignment.get("i");
        NumeralFormula.IntegerFormula iPlusOneEq = (NumeralFormula.IntegerFormula)pAssignment.get("iPlusOneEq");
        return this.solver.isUnsat(this.bfm.not(this.ifm.equal(this.ifm.add(i, this.ifm.makeNumber(1L)), iPlusOneEq)));
    }

    @Override
    protected Collection<BooleanFormula> deriveConclusion(Map<String, Formula> pAssignment) {
        BooleanFormula f1 = (BooleanFormula)pAssignment.get("f");
        NumeralFormula.IntegerFormula j = (NumeralFormula.IntegerFormula)pAssignment.get("j");
        NumeralFormula.IntegerFormula k = (NumeralFormula.IntegerFormula)pAssignment.get("k");
        NumeralFormula.IntegerFormula xBound = (NumeralFormula.IntegerFormula)pAssignment.get(SmtAstPatternBuilder.quantified("var1"));
        Formula xBoundParent = pAssignment.get(SmtAstPatternBuilder.parentOf(SmtAstPatternBuilder.quantified("var1")));
        NumeralFormula.IntegerFormula xNew = (NumeralFormula.IntegerFormula)this.ifm.makeVariable("x");
        BooleanFormula fNew = (BooleanFormula)this.substituteInParent(xBoundParent, xBound, xNew, f1);
        return ImmutableSet.of((Object)this.qfm.forall(xNew, j, k, fNew));
    }
}

