/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.Cartesian;
import org.sosy_lab.cpachecker.util.precondition.segkro.interfaces.Premise;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.AbstractRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedPremise;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.ArrayFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.QuantifiedFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatchResult;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatcher;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;

public abstract class PatternBasedRule
extends AbstractRule {
    protected final NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> ifm;
    protected final QuantifiedFormulaManagerView qfm;
    protected final ArrayFormulaManagerView afm;
    protected final BooleanFormulaManagerView bfm;
    protected final FormulaManagerView fmv;
    final StatTimer constraintCheckTimer = new StatTimer(StatKind.SUM, "Constraint checking");
    final StatTimer conclusionTimer = new StatTimer(StatKind.SUM, "Concluding");
    final StatTimer matchingTimer = new StatTimer(StatKind.SUM, "Matching");
    final StatTimer overallTimer = new StatTimer(StatKind.SUM, "Overall");
    final StatTimer conclusionValidationTimer = new StatTimer(StatKind.SUM, "Validation");

    public PatternBasedRule(Solver pSolver, SmtAstMatcher pMatcher) {
        super(pSolver, pMatcher);
        this.fmv = pSolver.getFormulaManager();
        this.bfm = this.fmv.getBooleanFormulaManager();
        this.ifm = this.fmv.getIntegerFormulaManager();
        this.qfm = this.fmv.getQuantifiedFormulaManager();
        this.afm = this.fmv.getArrayFormulaManager();
        this.setupPatterns();
    }

    protected abstract void setupPatterns();

    protected boolean satisfiesConstraints(Map<String, Formula> pAssignment) throws SolverException, InterruptedException {
        return true;
    }

    protected Collection<BooleanFormula> deriveConclusion(Map<String, Formula> pAssignment) {
        return Collections.emptyList();
    }

    @Override
    public Set<BooleanFormula> apply(BooleanFormula pInput) throws SolverException, InterruptedException {
        return this.apply(this.fmv.extractLiterals(pInput, false, false, false), (Multimap<String, Formula>)HashMultimap.create());
    }

    protected Formula substituteInParent(Formula pParent, Formula pToSubstitute, Formula pSubstituteBy, Formula pReplaceParentIn) {
        HashMap transformation = Maps.newHashMap();
        transformation.put(pToSubstitute, pSubstituteBy);
        Formula parentPrime = this.matcher.substitute(pParent, transformation);
        HashMap transformation2 = Maps.newHashMap();
        transformation2.put(pParent, parentPrime);
        return this.matcher.substitute(pReplaceParentIn, transformation2);
    }

    @Override
    public Set<BooleanFormula> apply(Collection<BooleanFormula> pConjunctiveInputPredicates, Multimap<String, Formula> pMatchingBindings) throws SolverException, InterruptedException {
        HashSet result = Sets.newHashSet();
        int premiseCount = this.getPremises().size();
        Verify.verify((premiseCount != 0 ? 1 : 0) != 0);
        ArrayList<Collection<BooleanFormula>> dimensions = new ArrayList<Collection<BooleanFormula>>(premiseCount);
        for (int i = 0; i < premiseCount; ++i) {
            dimensions.add(pConjunctiveInputPredicates);
        }
        for (List<BooleanFormula> list : Cartesian.product(dimensions)) {
            Set<BooleanFormula> inferred = this.applyWithInputRelatingPremises(list, pMatchingBindings);
            result.addAll(inferred);
        }
        return result;
    }

    private Collection<Map<String, Formula>> getAllAssignments(Multimap<String, Formula> pFromBindings) {
        Set boundVariables = pFromBindings.keySet();
        ArrayList<Collection> dimensions = new ArrayList<Collection>(boundVariables.size());
        for (String var : boundVariables) {
            dimensions.add(pFromBindings.get((Object)var));
        }
        ArrayList result = Lists.newArrayList();
        for (List x : Cartesian.product(dimensions)) {
            HashMap tuple = Maps.newHashMap();
            Iterator xIt = x.iterator();
            for (String var : boundVariables) {
                Formula f = (Formula)xIt.next();
                tuple.put(var, f);
            }
            result.add(tuple);
        }
        return result;
    }

    @Override
    public Set<BooleanFormula> applyWithInputRelatingPremises(List<BooleanFormula> pConjunctiveInputPredicates) throws SolverException, InterruptedException {
        return this.applyWithInputRelatingPremises(pConjunctiveInputPredicates, (Multimap<String, Formula>)HashMultimap.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BooleanFormula> applyWithInputRelatingPremises(Collection<BooleanFormula> pConjunctiveInputPredicates, Multimap<String, Formula> pMatchingBindings) throws SolverException, InterruptedException {
        this.overallTimer.start();
        try {
            HashSet hashSet;
            Preconditions.checkArgument((pConjunctiveInputPredicates.size() == this.getPremises().size() ? 1 : 0) != 0);
            HashSet result = Sets.newHashSet();
            boolean allPremisesMatch = true;
            HashMultimap matchingBindings = HashMultimap.create(pMatchingBindings);
            Iterator<BooleanFormula> it = pConjunctiveInputPredicates.iterator();
            for (Premise p : this.getPremises()) {
                assert (p instanceof PatternBasedPremise);
                PatternBasedPremise pp = (PatternBasedPremise)p;
                BooleanFormula predicate = it.next();
                this.matchingTimer.start();
                SmtAstMatchResult matchingResult = this.matcher.perform(pp.getPatternSelection(), null, predicate, (Optional<Multimap<String, Formula>>)Optional.of((Object)matchingBindings));
                this.matchingTimer.stop();
                if (!matchingResult.matches()) {
                    allPremisesMatch = false;
                    break;
                }
                matchingResult.appendBindingsTo((Multimap<String, Formula>)matchingBindings);
            }
            if (!allPremisesMatch) {
                Iterator<Map<String, Formula>> i$ = Collections.emptySet();
                return i$;
            }
            for (Map<String, Formula> tuple : this.getAllAssignments((Multimap<String, Formula>)matchingBindings)) {
                this.constraintCheckTimer.start();
                boolean constraintsSatisfied = this.satisfiesConstraints(tuple);
                this.constraintCheckTimer.stop();
                if (!constraintsSatisfied) continue;
                this.conclusionTimer.start();
                result.addAll(this.deriveConclusion(tuple));
                this.conclusionTimer.stop();
            }
            this.conclusionValidationTimer.start();
            boolean isValidOverapproximation = this.isValidConclusion(pConjunctiveInputPredicates, result);
            this.conclusionValidationTimer.stop();
            if (!isValidOverapproximation) {
                hashSet = Collections.emptySet();
                return hashSet;
            }
            hashSet = result;
            return hashSet;
        }
        finally {
            this.overallTimer.stop();
        }
    }

    protected boolean isValidConclusion(Collection<BooleanFormula> pConjunctiveInputPredicates, Set<BooleanFormula> pResult) throws SolverException, InterruptedException {
        return this.solver.isUnsat(this.bfm.not(this.bfm.implication(this.bfm.and((List<BooleanFormula>)ImmutableList.copyOf(pConjunctiveInputPredicates)), this.bfm.and((List<BooleanFormula>)ImmutableList.copyOf(pResult)))));
    }
}

