/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.interfaces.Canonicalizer;
import org.sosy_lab.cpachecker.util.precondition.segkro.interfaces.Concluding;
import org.sosy_lab.cpachecker.util.precondition.segkro.interfaces.Rule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.DefaultCanonicalizer;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.EliminationRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.EquivalenceRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.ExistentialRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.ExtendLeftRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.ExtendRightRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.InEqualityRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.LinCombineRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.LinkRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.SubstitutionRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.UniversalizeRule;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatcher;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatistics;

public class RuleEngine
implements Concluding,
StatisticsProvider,
Canonicalizer {
    private final List<Rule> rules;
    private final RuleEngineStatistics stats = new RuleEngineStatistics();
    private final Canonicalizer canon;

    public RuleEngine(LogManager pLogger, Solver pSolver) {
        SmtAstMatcher matcher = pSolver.getSmtAstMatcher();
        this.rules = Lists.newArrayList();
        this.rules.add(new InEqualityRule(pSolver, matcher));
        this.rules.add(new LinCombineRule(pSolver, matcher));
        this.rules.add(new EliminationRule(pSolver, matcher));
        this.rules.add(new EquivalenceRule(pSolver, matcher));
        this.rules.add(new UniversalizeRule(pSolver, matcher));
        this.rules.add(new SubstitutionRule(pSolver, matcher));
        this.rules.add(new LinkRule(pSolver, matcher));
        this.rules.add(new ExistentialRule(pSolver, matcher));
        this.rules.add(new ExtendLeftRule(pSolver, matcher));
        this.rules.add(new ExtendRightRule(pSolver, matcher));
        this.canon = new DefaultCanonicalizer(pSolver, matcher);
    }

    public ImmutableList<Rule> getRules() {
        return ImmutableList.copyOf(this.rules);
    }

    @Override
    public BooleanFormula concludeFromAtoms(List<BooleanFormula> pAtomPredicates) {
        return null;
    }

    public List<BooleanFormula> concludeWithSingleRule(List<BooleanFormula> pAtomPredicates, Rule pRule) {
        return null;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    @Override
    public BooleanFormula canonicalize(BooleanFormula pPredicate) throws SolverException, InterruptedException {
        return this.canon.canonicalize(pPredicate);
    }

    @Override
    public Collection<BooleanFormula> canonicalize(Collection<BooleanFormula> pPredicates) throws SolverException, InterruptedException {
        return this.canon.canonicalize(pPredicates);
    }

    private class RuleEngineStatistics
    extends AbstractStatistics {
        private RuleEngineStatistics() {
        }

        @Override
        public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, ReachedSet pReached) {
            for (Rule r : RuleEngine.this.rules) {
                if (!(r instanceof PatternBasedRule)) continue;
                PatternBasedRule pr = (PatternBasedRule)r;
                this.put(pOut, 1, "Rule", pr.getRuleName());
                this.put(pOut, 2, pr.overallTimer.getTitle(), pr.overallTimer.toString());
                this.put(pOut, 3, "Number of derived conclusions", pr.conclusionTimer.getUpdateCount());
                this.put(pOut, 3, pr.conclusionTimer.getTitle(), pr.conclusionTimer.toString());
                this.put(pOut, 3, pr.constraintCheckTimer.getTitle(), pr.constraintCheckTimer.toString());
                this.put(pOut, 3, pr.matchingTimer.getTitle(), pr.matchingTimer.toString());
                this.put(pOut, 3, pr.conclusionValidationTimer.getTitle(), pr.conclusionValidationTimer.toString());
            }
        }
    }
}

