/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.GenericPatterns;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedPremise;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedRule;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatcher;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPattern;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternBuilder;

public class SubstitutionRule
extends PatternBasedRule {
    public SubstitutionRule(Solver pSolver, SmtAstMatcher pMatcher) {
        super(pSolver, pMatcher);
    }

    @Override
    protected void setupPatterns() {
        this.premises.add(new PatternBasedPremise(GenericPatterns.f_of_x_matcher("f", SmtAstPatternBuilder.and(SmtAstPatternBuilder.matchNumeralExpressionBind("x")), SmtAstPatternBuilder.and(SmtAstPatternBuilder.matchAnyWithAnyArgsBind("y")))));
        this.premises.add(new PatternBasedPremise(SmtAstPatternBuilder.or(SmtAstPatternBuilder.matchBind(">=", "eq", new SmtAstPattern[]{SmtAstPatternBuilder.matchNumeralExpressionBind("x"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("e")}), SmtAstPatternBuilder.matchBind("<=", "eq", new SmtAstPattern[]{SmtAstPatternBuilder.matchNumeralExpressionBind("x"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("e")}), SmtAstPatternBuilder.matchBind("=", "eq", new SmtAstPattern[]{SmtAstPatternBuilder.matchNumeralExpressionBind("x"), SmtAstPatternBuilder.matchAnyWithAnyArgsBind("e")}), SmtAstPatternBuilder.match("not", new SmtAstPattern[]{SmtAstPatternBuilder.matchBind(">=", "lt", new SmtAstPattern[]{SmtAstPatternBuilder.matchNumeralExpressionBind("x"), SmtAstPatternBuilder.matchNumeralExpressionBind("e")})}))));
    }

    @Override
    protected boolean satisfiesConstraints(Map<String, Formula> pAssignment) throws SolverException, InterruptedException {
        BooleanFormula f = (BooleanFormula)Preconditions.checkNotNull((Object)pAssignment.get("f"));
        Formula eq = pAssignment.get("eq");
        Formula lt = pAssignment.get("lt");
        Formula e = (Formula)Preconditions.checkNotNull((Object)pAssignment.get("e"));
        Formula x = (Formula)Preconditions.checkNotNull((Object)pAssignment.get("x"));
        Formula y = (Formula)Preconditions.checkNotNull((Object)pAssignment.get("y"));
        Formula parentOfX = pAssignment.get("x.parent");
        if (parentOfX == null) {
            return false;
        }
        if (lt == null && eq == null) {
            return false;
        }
        if (lt != null && f.equals(lt)) {
            return false;
        }
        if (eq != null && f.equals(eq)) {
            return false;
        }
        return eq == null || !this.solver.isUnsat(this.bfm.and(f, (BooleanFormula)eq));
    }

    @Override
    protected Collection<BooleanFormula> deriveConclusion(Map<String, Formula> pAssignment) {
        BooleanFormula f = (BooleanFormula)Preconditions.checkNotNull((Object)pAssignment.get("f"));
        Formula x = (Formula)Preconditions.checkNotNull((Object)pAssignment.get("x"));
        Formula parentOfX = (Formula)Preconditions.checkNotNull((Object)pAssignment.get("x.parent"));
        HashMap transformation = Maps.newHashMap();
        Formula e = (Formula)Preconditions.checkNotNull((Object)pAssignment.get("e"));
        transformation.put(x, e);
        Formula parentOfXPrime = this.matcher.substitute(parentOfX, transformation);
        HashMap transformation2 = Maps.newHashMap();
        transformation2.put(parentOfX, parentOfXPrime);
        BooleanFormula fPrime = this.matcher.substitute(f, transformation2);
        return Lists.newArrayList((Object[])new BooleanFormula[]{fPrime});
    }
}

