/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules.tests;

import org.junit.Before;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.ArrayFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.QuantifiedFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatcher;
import org.sosy_lab.cpachecker.util.test.SolverBasedTest0;

public abstract class AbstractRuleTest0
extends SolverBasedTest0 {
    protected ArrayFormulaManagerView afm;
    protected BooleanFormulaManagerView bfm;
    protected QuantifiedFormulaManagerView qfm;
    protected NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> ifm;
    protected FormulaManagerView mgrv;
    protected SmtAstMatcher matcher;
    protected Solver solver;

    protected BooleanFormula rangePredicate(boolean pForall, NumeralFormula.IntegerFormula pLowerLimit, NumeralFormula.IntegerFormula pUpperLimit) {
        NumeralFormula.IntegerFormula _x = this.ifm.makeVariable("x");
        ArrayFormula _b = this.afm.makeArray("b", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        BooleanFormula _body = this.bfm.not(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(_b, _x)), this.ifm.makeNumber(0L)));
        if (pForall) {
            return this.qfm.forall(_x, pLowerLimit, pUpperLimit, _body);
        }
        return this.qfm.exists(_x, pLowerLimit, pUpperLimit, _body);
    }

    @Override
    protected FormulaManagerFactory.Solvers solverToUse() {
        return FormulaManagerFactory.Solvers.Z3;
    }

    @Before
    public void setUp() throws Exception {
        this.mgrv = new FormulaManagerView(this.factory, this.config, TestLogManager.getInstance());
        this.solver = new Solver(this.mgrv, this.factory, this.config, TestLogManager.getInstance());
        this.matcher = this.solver.getSmtAstMatcher();
        this.afm = this.mgrv.getArrayFormulaManager();
        this.bfm = this.mgrv.getBooleanFormulaManager();
        this.ifm = this.mgrv.getIntegerFormulaManager();
        this.qfm = this.mgrv.getQuantifiedFormulaManager();
    }

    protected boolean isFormulaEqual(BooleanFormula pFormula, BooleanFormula pIsEqualTo) throws SolverException, InterruptedException {
        return this.solver.isUnsat(this.bfm.notEquivalence(pFormula, pIsEqualTo));
    }
}

