/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules.tests;

import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.util.Set;
import org.junit.Test;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.EliminationRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.tests.AbstractRuleTest0;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;

public class EliminationRuleTest0
extends AbstractRuleTest0 {
    private EliminationRule er;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.er = new EliminationRule(this.solver, this.matcher);
    }

    @Test
    public void testElim1() throws SolverException, InterruptedException {
        NumeralFormula.IntegerFormula _c1 = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "c1");
        NumeralFormula.IntegerFormula _c2 = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "c2");
        NumeralFormula.IntegerFormula _e1 = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "e1");
        NumeralFormula.IntegerFormula _e2 = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "e2");
        NumeralFormula.IntegerFormula _eX = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "eX");
        NumeralFormula.IntegerFormula _0 = (NumeralFormula.IntegerFormula)this.ifm.makeNumber(0L);
        BooleanFormula _c1_times_ex_plus_e1_GEQ_0 = this.ifm.greaterOrEquals(this.ifm.add(this.ifm.multiply(_c1, _eX), _e1), _0);
        BooleanFormula _minus_c2_times_ex_plus_e2_GEQ_0 = this.ifm.greaterOrEquals(this.ifm.add(this.ifm.multiply(this.ifm.subtract(_0, _c2), _eX), _e2), _0);
        BooleanFormula expectedConclusion = this.ifm.greaterOrEquals(this.ifm.add(this.ifm.multiply(_c2, _e1), this.ifm.multiply(_c1, _e2)), _0);
        Set<BooleanFormula> concluded = this.er.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{_c1_times_ex_plus_e1_GEQ_0, _minus_c2_times_ex_plus_e2_GEQ_0}));
        Truth.assertThat(concluded).isNotEmpty();
        Truth.assertThat(concluded).contains((Object)expectedConclusion);
    }
}

