/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules.tests;

import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.util.Set;
import org.junit.Test;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.EquivalenceRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.tests.AbstractRuleTest0;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;

public class EquivalenceRuleTest0
extends AbstractRuleTest0 {
    private EquivalenceRule er;
    private NumeralFormula.IntegerFormula _x;
    private NumeralFormula.IntegerFormula _e;
    private NumeralFormula.IntegerFormula _0;
    private NumeralFormula.IntegerFormula _i;
    private NumeralFormula.IntegerFormula _al;
    private NumeralFormula.IntegerFormula _1;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.er = new EquivalenceRule(this.solver, this.matcher);
        this._i = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "i");
        this._al = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "al");
        this._x = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "x");
        this._e = (NumeralFormula.IntegerFormula)this.mgrv.makeVariable(FormulaType.NumeralType.IntegerType, "e");
        this._0 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        this._1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
    }

    @Test
    public void testEquivalence1() throws SolverException, InterruptedException {
        BooleanFormula _x_minus_e_GEQ_0 = this.imgr.greaterOrEquals(this.imgr.subtract(this._x, this._e), this._0);
        BooleanFormula _minus_x_plus_e_GEQ_0 = this.imgr.greaterOrEquals(this.imgr.add(this.imgr.subtract(this._0, this._x), this._e), this._0);
        BooleanFormula expectedConclusion = this.imgr.equal(this._x, this._e);
        Set<BooleanFormula> conclusion = this.er.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{_x_minus_e_GEQ_0, _minus_x_plus_e_GEQ_0}));
        Truth.assertThat(conclusion).isNotEmpty();
        Truth.assertThat((String)conclusion.iterator().next().toString()).isEqualTo((Object)expectedConclusion.toString());
    }

    @Test
    public void testEquivalence2() throws SolverException, InterruptedException {
        Set<BooleanFormula> result = this.er.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{this.imgr.lessThan(this._i, this._al), this.imgr.greaterOrEquals(this.imgr.add(this._i, this._1), this._al)}));
        BooleanFormula expectedConclusion = this.imgr.equal(this._al, this.imgr.add(this._i, this._1));
        Truth.assertThat(result).isNotEmpty();
        Truth.assertThat((String)result.iterator().next().toString()).isEqualTo((Object)expectedConclusion.toString());
    }
}

