/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules.tests;

import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.Set;
import org.junit.Test;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.interfaces.Premise;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.ExistentialRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.PatternBasedPremise;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.tests.AbstractRuleTest0;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatchResult;

public class ExistentialRuleTest0
extends AbstractRuleTest0 {
    private ExistentialRule er;
    private NumeralFormula.IntegerFormula _0;
    private NumeralFormula.IntegerFormula _1;
    private NumeralFormula.IntegerFormula _i;
    private BooleanFormula _b_at_i_plus_1_EQ_0;
    private BooleanFormula _b_at_i_plus_1_NOTEQ_0;
    private BooleanFormula _0_EQ_b_at_i_plus_1;
    private ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> _b;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.er = new ExistentialRule(this.solver, this.matcher);
        this.setupTestData();
    }

    private void setupTestData() {
        this._0 = (NumeralFormula.IntegerFormula)this.ifm.makeNumber(0L);
        this._1 = (NumeralFormula.IntegerFormula)this.ifm.makeNumber(1L);
        this._b = this.afm.makeArray("b", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        this._i = (NumeralFormula.IntegerFormula)this.ifm.makeVariable("i");
        this._0_EQ_b_at_i_plus_1 = this.ifm.equal(this._0, (NumeralFormula)this.afm.select(this._b, (Formula)this.ifm.add(this._i, this._1)));
        this._b_at_i_plus_1_EQ_0 = this.ifm.equal((NumeralFormula)this.afm.select(this._b, (Formula)this.ifm.add(this._i, this._1)), this._0);
        this._b_at_i_plus_1_NOTEQ_0 = this.bfm.not(this.ifm.equal((NumeralFormula)this.afm.select(this._b, (Formula)this.ifm.add(this._i, this._1)), this._0));
    }

    @Test
    public void testPremise2() throws SolverException, InterruptedException {
        Premise p1 = (Premise)this.er.getPremises().get(1);
        Truth.assertThat((Object)p1).isInstanceOf(PatternBasedPremise.class);
        PatternBasedPremise pp1 = (PatternBasedPremise)p1;
        SmtAstMatchResult r1 = this.matcher.perform(pp1.getPatternSelection(), this._0_EQ_b_at_i_plus_1);
        Truth.assertThat((Boolean)r1.matches()).isTrue();
        Truth.assertThat((Integer)r1.getBoundVariables().size()).isGreaterThan((Comparable)Integer.valueOf(1));
    }

    @Test
    public void testPremise2a() throws SolverException, InterruptedException, IOException {
        Premise p1 = (Premise)this.er.getPremises().get(1);
        Truth.assertThat((Object)p1).isInstanceOf(PatternBasedPremise.class);
        PatternBasedPremise pp1 = (PatternBasedPremise)p1;
        SmtAstMatchResult r2 = this.matcher.perform(pp1.getPatternSelection(), this._b_at_i_plus_1_EQ_0);
        Truth.assertThat((Boolean)r2.matches()).isTrue();
        Truth.assertThat((Integer)r2.getBoundVariables().size()).isGreaterThan((Comparable)Integer.valueOf(1));
    }

    @Test
    public void testPremise1() throws SolverException, InterruptedException {
        Premise p2 = (Premise)this.er.getPremises().get(0);
        Truth.assertThat((Object)p2).isInstanceOf(PatternBasedPremise.class);
        PatternBasedPremise pp2 = (PatternBasedPremise)p2;
        SmtAstMatchResult result = this.matcher.perform(pp2.getPatternSelection(), this._b_at_i_plus_1_EQ_0);
        Truth.assertThat((Boolean)result.matches()).isFalse();
        result = this.matcher.perform(pp2.getPatternSelection(), this._b_at_i_plus_1_NOTEQ_0);
        Truth.assertThat((Boolean)result.matches()).isTrue();
    }

    @Test
    public void testConclusion1() throws SolverException, InterruptedException {
        Set<BooleanFormula> result = this.er.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.equal((NumeralFormula)this.afm.select(this._b, this._i), this._0)), this.ifm.equal((NumeralFormula)this.afm.select(this._b, (Formula)this.ifm.add(this._i, this._1)), this._0)}));
        Truth.assertThat(result).contains((Object)this.rangePredicate(false, this._i, (NumeralFormula.IntegerFormula)this.ifm.add(this._i, this._1)));
    }

    @Test
    public void testConclusion3() throws SolverException, InterruptedException {
        Set<BooleanFormula> result = this.er.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.equal((NumeralFormula)this.afm.select(this._b, this._0), this._0)), this.ifm.equal((NumeralFormula)this.afm.select(this._b, this._0), this._0)}));
        Truth.assertThat(result).isEmpty();
    }

    @Test
    public void testConclusion4() throws SolverException, InterruptedException {
        Set<BooleanFormula> result = this.er.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.equal((NumeralFormula)this.afm.select(this._b, this._i), this._0)), this.ifm.equal((NumeralFormula)this.afm.select(this._b, (Formula)this.ifm.add(this._1, this._i)), this._0)}));
        Truth.assertThat(result).contains((Object)this.rangePredicate(false, this._i, (NumeralFormula.IntegerFormula)this.ifm.add(this._1, this._i)));
    }

    @Test
    public void testConclusion2() throws SolverException, InterruptedException {
        Set<BooleanFormula> result = this.er.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.equal((NumeralFormula)this.afm.select(this._b, this._i), this._0)), this.ifm.equal((NumeralFormula)this.afm.select(this._b, (Formula)this.ifm.add(this._1, this._i)), this._0)}));
        Truth.assertThat(result).contains((Object)this.rangePredicate(false, this._i, (NumeralFormula.IntegerFormula)this.ifm.add(this._1, this._i)));
    }

    @Test
    public void testConclusion5() throws SolverException, InterruptedException {
        Set<BooleanFormula> result = this.er.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.ifm.equal((NumeralFormula)this.afm.select(this._b, this._0), this._0)), this.ifm.equal(this._0, (NumeralFormula)this.afm.select(this._b, this._1))}));
        Truth.assertThat(result).contains((Object)this.rangePredicate(false, this._0, this._1));
    }
}

