/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules.tests;

import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.util.Set;
import org.junit.Test;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.ExtendLeftRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.tests.AbstractRuleTest0;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;

public class ExtendLeftRuleTest0
extends AbstractRuleTest0 {
    private ExtendLeftRule elr;
    private NumeralFormula.IntegerFormula _0;
    private NumeralFormula.IntegerFormula _i;
    private NumeralFormula.IntegerFormula _j;
    private NumeralFormula.IntegerFormula _x;
    private ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> _b;
    private BooleanFormula _b_at_x_NOTEQ_0;
    private NumeralFormula.IntegerFormula _k;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.elr = new ExtendLeftRule(this.solver, this.matcher);
        this.setupTestData();
    }

    private void setupTestData() {
        this._0 = (NumeralFormula.IntegerFormula)this.ifm.makeNumber(0L);
        this._i = (NumeralFormula.IntegerFormula)this.ifm.makeVariable("i");
        this._j = (NumeralFormula.IntegerFormula)this.ifm.makeVariable("j");
        this._x = (NumeralFormula.IntegerFormula)this.ifm.makeVariable("x");
        this._k = (NumeralFormula.IntegerFormula)this.ifm.makeVariable("k");
        this._b = this.afm.makeArray("b", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        this._b_at_x_NOTEQ_0 = this.bfm.not(this.ifm.equal((NumeralFormula)this.afm.select(this._b, this._x), this._0));
    }

    @Test
    public void testConclusion1() throws SolverException, InterruptedException {
        BooleanFormula _EXISTS_x = this.qfm.exists(this._x, this._i, this._j, this._b_at_x_NOTEQ_0);
        BooleanFormula _right_ext = this.ifm.lessOrEquals(this._j, this._k);
        Set<BooleanFormula> result = this.elr.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{_EXISTS_x, _right_ext}));
        Truth.assertThat(result).isEmpty();
    }

    @Test
    public void testConclusion2() throws SolverException, InterruptedException {
        BooleanFormula _EXISTS_x = this.qfm.exists(this._x, this._i, this._j, this._b_at_x_NOTEQ_0);
        BooleanFormula _right_ext = this.ifm.lessOrEquals(this._k, this._j);
        Set<BooleanFormula> result = this.elr.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{_EXISTS_x, _right_ext}));
        Truth.assertThat(result).isEmpty();
    }

    @Test
    public void testConclusion3() throws SolverException, InterruptedException {
        BooleanFormula _EXISTS_x = this.qfm.exists(this._x, this._i, this._j, this._b_at_x_NOTEQ_0);
        BooleanFormula _ext = this.ifm.lessThan(this._k, this._i);
        Set<BooleanFormula> result = this.elr.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{_EXISTS_x, _ext}));
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testConclusion4() throws SolverException, InterruptedException {
        BooleanFormula _EXISTS_x = this.qfm.exists(this._x, this._i, this._i, this.bfm.not(this.ifm.equal((NumeralFormula)this.afm.select(this._b, this._x), this.ifm.makeNumber(0L))));
        BooleanFormula _ext = this.ifm.lessThan(this._k, this._i);
        Set<BooleanFormula> result = this.elr.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{_EXISTS_x, _ext}));
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testConclusion8() throws SolverException, InterruptedException {
        BooleanFormula _EXISTS_x = this.qfm.exists(this._x, this._i, (NumeralFormula.IntegerFormula)this.ifm.add(this._i, this.ifm.makeNumber(1L)), this.bfm.not(this.ifm.equal((NumeralFormula)this.afm.select(this._b, this._x), this.ifm.makeNumber(0L))));
        BooleanFormula _ext = this.ifm.equal(this._i, this._0);
        Set<BooleanFormula> result = this.elr.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{_EXISTS_x, _ext}));
        Truth.assertThat(result).isNotEmpty();
    }
}

