/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules.tests;

import com.google.common.truth.Truth;
import org.junit.Test;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.GenericPatterns;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.tests.AbstractRuleTest0;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatchResult;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternBuilder;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstPatternSelection;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtQuantificationPattern;

public class GenericPatternTest0
extends AbstractRuleTest0 {
    @Test
    public void testMatchSubtraction1() {
        NumeralFormula.IntegerFormula subst1 = (NumeralFormula.IntegerFormula)this.ifm.add(this.ifm.makeVariable("b"), this.ifm.multiply(this.ifm.makeNumber(-1L), this.ifm.makeVariable("c")));
        SmtAstPatternSelection pattern = GenericPatterns.substraction("x", "y");
        SmtAstMatchResult result = this.matcher.perform(pattern, subst1);
        Truth.assertThat((Boolean)result.matches()).isTrue();
    }

    @Test
    public void testMatchSubtraction2() {
        NumeralFormula.IntegerFormula subst1 = (NumeralFormula.IntegerFormula)this.ifm.subtract(this.ifm.makeVariable("b"), this.ifm.makeVariable("c"));
        SmtAstPatternSelection pattern = GenericPatterns.substraction("x", "y");
        SmtAstMatchResult result = this.matcher.perform(pattern, subst1);
        Truth.assertThat((Boolean)result.matches()).isTrue();
    }

    @Test
    public void testMatchSubtraction3() {
        NumeralFormula.IntegerFormula subst1 = (NumeralFormula.IntegerFormula)this.ifm.add(this.ifm.makeVariable("b"), this.ifm.subtract(this.ifm.makeNumber(0L), this.ifm.makeVariable("c")));
        SmtAstPatternSelection pattern = GenericPatterns.substraction("x", "y");
        SmtAstMatchResult result = this.matcher.perform(pattern, subst1);
        Truth.assertThat((Boolean)result.matches()).isTrue();
    }

    @Test
    public void testExistsRangePredicate() {
        NumeralFormula.IntegerFormula _x = (NumeralFormula.IntegerFormula)this.ifm.makeVariable("x");
        BooleanFormula _exists = this.qfm.exists(_x, (NumeralFormula.IntegerFormula)this.ifm.makeNumber(10L), (NumeralFormula.IntegerFormula)this.ifm.makeNumber(20L), this.ifm.equal(_x, this.ifm.makeNumber(10L)));
        SmtAstPatternSelection pattern = SmtAstPatternBuilder.and(GenericPatterns.range_predicate_matcher("exists", SmtQuantificationPattern.QuantifierType.EXISTS, "f", "i", "j", SmtAstPatternBuilder.and(SmtAstPatternBuilder.matchAnyWithAnyArgs())));
        SmtAstMatchResult result = this.matcher.perform(pattern, _exists);
        Truth.assertThat((Boolean)result.matches()).isTrue();
    }

    @Test
    public void testForallRangePredicate() {
        NumeralFormula.IntegerFormula _x = (NumeralFormula.IntegerFormula)this.ifm.makeVariable("x");
        BooleanFormula _forall = this.qfm.forall(_x, (NumeralFormula.IntegerFormula)this.ifm.makeNumber(10L), (NumeralFormula.IntegerFormula)this.ifm.makeNumber(20L), this.ifm.equal(_x, this.ifm.makeNumber(10L)));
        SmtAstPatternSelection pattern = SmtAstPatternBuilder.and(GenericPatterns.range_predicate_matcher("forall", SmtQuantificationPattern.QuantifierType.FORALL, "f", "i", "j", SmtAstPatternBuilder.and(SmtAstPatternBuilder.matchAnyWithAnyArgs())));
        SmtAstMatchResult result = this.matcher.perform(pattern, _forall);
        Truth.assertThat((Boolean)result.matches()).isTrue();
    }
}

