/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.precondition.segkro.rules.tests;

import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.util.Set;
import org.junit.Test;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.UniversalizeRule;
import org.sosy_lab.cpachecker.util.precondition.segkro.rules.tests.AbstractRuleTest0;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;

public class UniversalizeRuleTest0
extends AbstractRuleTest0 {
    private UniversalizeRule ur;
    private NumeralFormula.IntegerFormula _0;
    private NumeralFormula.IntegerFormula _1;
    private NumeralFormula.IntegerFormula _i;
    private NumeralFormula.IntegerFormula _al;
    private ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> _b;
    private BooleanFormula _NOT_b_at_i_NOTEQ_0;
    private BooleanFormula _NOT_b_at_i_plus_1_NOTEQ_0;
    private BooleanFormula _b_at_i_NOTEQ_0;
    private BooleanFormula _b_at_i_plus_1_NOTEQ_0;
    private BooleanFormula _b_at_i_EQ_0;
    private BooleanFormula _b_at_i_plus_1_EQ_0;
    private BooleanFormula _b_at_0_EQ_0;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ur = new UniversalizeRule(this.solver, this.matcher);
        this._0 = (NumeralFormula.IntegerFormula)this.ifm.makeNumber(0L);
        this._1 = (NumeralFormula.IntegerFormula)this.ifm.makeNumber(1L);
        this._i = (NumeralFormula.IntegerFormula)this.ifm.makeVariable("i");
        this._al = (NumeralFormula.IntegerFormula)this.ifm.makeVariable("al");
        this._b = this.afm.makeArray("b", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        this._b_at_0_EQ_0 = this.ifm.equal((NumeralFormula)this.afm.select(this._b, this._0), this._0);
        this._b_at_i_EQ_0 = this.ifm.equal((NumeralFormula)this.afm.select(this._b, this._i), this._0);
        this._b_at_i_plus_1_EQ_0 = this.ifm.equal((NumeralFormula)this.afm.select(this._b, (Formula)this.ifm.add(this._i, this._1)), this._0);
        this._b_at_i_NOTEQ_0 = this.bfm.not(this._b_at_i_EQ_0);
        this._b_at_i_plus_1_NOTEQ_0 = this.bfm.not(this._b_at_i_plus_1_EQ_0);
        this._NOT_b_at_i_NOTEQ_0 = this.bfm.not(this.bfm.not(this._b_at_i_EQ_0));
        this._NOT_b_at_i_plus_1_NOTEQ_0 = this.bfm.not(this.bfm.not(this._b_at_i_plus_1_EQ_0));
    }

    @Test
    public void testConclusion1() throws SolverException, InterruptedException {
        Set<BooleanFormula> result = this.ur.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{this._b_at_i_plus_1_NOTEQ_0}));
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testConclusion2() throws SolverException, InterruptedException {
        Set<BooleanFormula> result = this.ur.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{this._b_at_i_NOTEQ_0}));
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testConclusion3() throws SolverException, InterruptedException {
        Set<BooleanFormula> result = this.ur.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{this._b_at_i_plus_1_EQ_0}));
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testConclusion4() throws SolverException, InterruptedException {
        Set<BooleanFormula> result = this.ur.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{this._b_at_i_EQ_0}));
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testConclusion4rotated() throws SolverException, InterruptedException {
        BooleanFormula input = this.ifm.equal(this._0, (NumeralFormula)this.afm.select(this._b, this._i));
        Set<BooleanFormula> result = this.ur.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{input}));
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testConclusion5() throws SolverException, InterruptedException {
        Set<BooleanFormula> result = this.ur.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{this._NOT_b_at_i_plus_1_NOTEQ_0}));
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testConclusion6() throws SolverException, InterruptedException {
        Set<BooleanFormula> result = this.ur.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{this._NOT_b_at_i_NOTEQ_0}));
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testConclusion8() throws SolverException, InterruptedException {
        Set<BooleanFormula> result = this.ur.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{this._b_at_0_EQ_0}));
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testConclusion9() throws SolverException, InterruptedException {
        Set<BooleanFormula> result = this.ur.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this._b_at_0_EQ_0)}));
        Truth.assertThat(result).isNotEmpty();
    }

    @Test
    public void testConclusion10() throws SolverException, InterruptedException {
        Set<BooleanFormula> result = this.ur.applyWithInputRelatingPremises(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.bfm.not(this._b_at_0_EQ_0))}));
        Truth.assertThat(result).isNotEmpty();
    }
}

