/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.cpachecker.util.UniqueIdGenerator;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;

public class AbstractionFormula
implements Serializable {
    private static final long serialVersionUID = -7756517128231447936L;
    @Nullable
    private final transient Region region;
    private final transient BooleanFormula formula;
    private final BooleanFormula instantiatedFormula;
    private final PathFormula blockFormula;
    private static final UniqueIdGenerator idGenerator = new UniqueIdGenerator();
    private final transient int id = idGenerator.getFreshId();
    private final transient BooleanFormulaManager mgr;
    private final transient ImmutableSet<Integer> idsOfStoredAbstractionReused;

    public AbstractionFormula(FormulaManagerView mgr, Region pRegion, BooleanFormula pFormula, BooleanFormula pInstantiatedFormula, PathFormula pBlockFormula, Set<Integer> pIdOfStoredAbstractionReused) {
        this.mgr = (BooleanFormulaManager)Preconditions.checkNotNull((Object)mgr.getBooleanFormulaManager());
        this.region = (Region)Preconditions.checkNotNull((Object)pRegion);
        this.formula = (BooleanFormula)Preconditions.checkNotNull((Object)pFormula);
        this.instantiatedFormula = (BooleanFormula)Preconditions.checkNotNull((Object)pInstantiatedFormula);
        this.blockFormula = (PathFormula)Preconditions.checkNotNull((Object)pBlockFormula);
        this.idsOfStoredAbstractionReused = ImmutableSet.copyOf(pIdOfStoredAbstractionReused);
    }

    public boolean isReusedFromStoredAbstraction() {
        return !this.idsOfStoredAbstractionReused.isEmpty();
    }

    public boolean isTrue() {
        return this.mgr.isTrue(this.formula);
    }

    public boolean isFalse() {
        return this.mgr.isFalse(this.formula);
    }

    @Nullable
    public Region asRegion() {
        return this.region;
    }

    public BooleanFormula asFormula() {
        return this.formula;
    }

    public BooleanFormula asInstantiatedFormula() {
        return this.instantiatedFormula;
    }

    public PathFormula getBlockFormula() {
        return this.blockFormula;
    }

    public int getId() {
        return this.id;
    }

    public ImmutableSet<Integer> getIdsOfStoredAbstractionReused() {
        return this.idsOfStoredAbstractionReused;
    }

    public String toString() {
        String abs = "";
        if (this.isTrue()) {
            abs = ": true";
        } else if (this.isFalse()) {
            abs = ": false";
        }
        return "ABS" + this.id + abs;
    }

    private Object readResolve() throws ObjectStreamException {
        FormulaManagerView mgr = GlobalInfo.getInstance().getFormulaManager();
        BooleanFormula notInstantiated = mgr.uninstantiate(this.instantiatedFormula);
        return new AbstractionFormula(mgr, GlobalInfo.getInstance().getAbstractionManager().buildRegionFromFormulaWithUnknownAtoms(notInstantiated), notInstantiated, this.instantiatedFormula, this.blockFormula, (Set<Integer>)ImmutableSet.of());
    }
}

