/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.AbstractMBean;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.AbstractionPredicate;
import org.sosy_lab.cpachecker.util.predicates.SymbolicRegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

@Options(prefix="cpa.predicate")
public final class AbstractionManager {
    private volatile int numberOfPredicates = 0;
    private final LogManager logger;
    private final RegionManager rmgr;
    private final FormulaManagerView fmgr;
    private final Map<Region, AbstractionPredicate> absVarToPredicate = Maps.newHashMap();
    private final Map<BooleanFormula, AbstractionPredicate> symbVarToPredicate = Maps.newHashMap();
    private final Map<BooleanFormula, AbstractionPredicate> atomToPredicate = Maps.newHashMap();
    @Option(secure=true, name="abs.useCache", description="use caching of region to formula conversions")
    private boolean useCache = true;
    private final Map<Region, BooleanFormula> toConcreteCache;
    private BooleanFormulaManagerView bfmgr;

    public AbstractionManager(RegionManager pRmgr, FormulaManagerView pFmgr, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this, AbstractionManager.class);
        this.logger = pLogger;
        this.rmgr = pRmgr;
        this.fmgr = pFmgr;
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.toConcreteCache = this.useCache ? new HashMap<Region, BooleanFormula>() : null;
        new AbstractionPredicatesMBean();
    }

    public int getNumberOfPredicates() {
        return this.numberOfPredicates;
    }

    public AbstractionPredicate makePredicate(BooleanFormula atom) {
        AbstractionPredicate result = this.atomToPredicate.get(atom);
        if (result == null) {
            BooleanFormula symbVar = this.fmgr.createPredicateVariable("PRED" + this.numberOfPredicates++);
            Region absVar = this.rmgr.createPredicate();
            this.logger.log(Level.FINEST, new Object[]{"Created predicate", absVar, "from variable", symbVar, "and atom", atom});
            result = new AbstractionPredicate(absVar, symbVar, atom);
            this.symbVarToPredicate.put(symbVar, result);
            this.absVarToPredicate.put(absVar, result);
            this.atomToPredicate.put(atom, result);
        }
        return result;
    }

    public AbstractionPredicate makeFalsePredicate() {
        return this.makePredicate(this.bfmgr.makeBoolean(false));
    }

    private AbstractionPredicate getPredicate(BooleanFormula var) {
        AbstractionPredicate result = this.symbVarToPredicate.get(var);
        if (result == null) {
            throw new IllegalArgumentException(var + " seems not to be a formula corresponding to a single predicate variable.");
        }
        return result;
    }

    public BooleanFormula toConcrete(Region af) {
        if (this.rmgr instanceof SymbolicRegionManager) {
            return ((SymbolicRegionManager)this.rmgr).toFormula(af);
        }
        Map<Region, BooleanFormula> cache = this.useCache ? this.toConcreteCache : new HashMap<Region, BooleanFormula>();
        ArrayDeque<Region> toProcess = new ArrayDeque<Region>();
        cache.put(this.rmgr.makeTrue(), this.bfmgr.makeBoolean(true));
        cache.put(this.rmgr.makeFalse(), this.bfmgr.makeBoolean(false));
        toProcess.push(af);
        while (!toProcess.isEmpty()) {
            Region n = (Region)toProcess.peek();
            if (cache.containsKey(n)) {
                toProcess.pop();
                continue;
            }
            boolean childrenDone = true;
            BooleanFormula m1 = null;
            BooleanFormula m2 = null;
            Triple<Region, Region, Region> parts = this.rmgr.getIfThenElse(n);
            Region c1 = (Region)parts.getSecond();
            Region c2 = (Region)parts.getThird();
            if (!cache.containsKey(c1)) {
                toProcess.push(c1);
                childrenDone = false;
            } else {
                m1 = cache.get(c1);
            }
            if (!cache.containsKey(c2)) {
                toProcess.push(c2);
                childrenDone = false;
            } else {
                m2 = cache.get(c2);
            }
            if (!childrenDone) continue;
            assert (m1 != null);
            assert (m2 != null);
            toProcess.pop();
            Region var = (Region)parts.getFirst();
            AbstractionPredicate pred = this.absVarToPredicate.get(var);
            assert (pred != null) : var;
            BooleanFormula atom = pred.getSymbolicAtom();
            if (this.bfmgr.isTrue(m1)) {
                if (this.bfmgr.isFalse(m2)) {
                    cache.put(n, atom);
                    continue;
                }
                cache.put(n, this.bfmgr.or(atom, m2));
                continue;
            }
            if (this.bfmgr.isFalse(m1)) {
                if (this.bfmgr.isTrue(m2)) {
                    cache.put(n, this.bfmgr.not(atom));
                    continue;
                }
                cache.put(n, this.bfmgr.and(this.bfmgr.not(atom), m2));
                continue;
            }
            if (this.bfmgr.isTrue(m2)) {
                cache.put(n, this.bfmgr.or(this.bfmgr.not(atom), m1));
                continue;
            }
            if (this.bfmgr.isFalse(m2)) {
                cache.put(n, this.bfmgr.and(atom, m1));
                continue;
            }
            cache.put(n, this.bfmgr.ifThenElse(atom, m1, m2));
        }
        BooleanFormula result = cache.get(af);
        assert (result != null);
        return result;
    }

    public boolean entails(Region f1, Region f2) throws SolverException, InterruptedException {
        return this.rmgr.entails(f1, f2);
    }

    public Set<AbstractionPredicate> extractPredicates(Region af) {
        HashSet<AbstractionPredicate> vars = new HashSet<AbstractionPredicate>();
        ArrayDeque<Object> toProcess = new ArrayDeque<Object>();
        toProcess.push(af);
        while (!toProcess.isEmpty()) {
            Region n = (Region)toProcess.pop();
            if (n.isTrue() || n.isFalse()) {
                vars.add(this.makeFalsePredicate());
                continue;
            }
            AbstractionPredicate pred = this.absVarToPredicate.get(n);
            if (pred == null) {
                Triple<Region, Region, Region> parts = this.rmgr.getIfThenElse(n);
                Region var = (Region)parts.getFirst();
                pred = this.absVarToPredicate.get(var);
                assert (pred != null);
                toProcess.push(parts.getSecond());
                toProcess.push(parts.getThird());
            }
            vars.add(pred);
        }
        return vars;
    }

    public Region buildRegionFromFormula(BooleanFormula pF) {
        return this.rmgr.fromFormula(pF, this.fmgr, (Function<BooleanFormula, Region>)Functions.compose((Function)new Function<AbstractionPredicate, Region>(){

            public Region apply(AbstractionPredicate pInput) {
                return pInput.getAbstractVariable();
            }
        }, (Function)Functions.forMap(this.atomToPredicate)));
    }

    public Region buildRegionFromFormulaWithUnknownAtoms(BooleanFormula pF) {
        return this.rmgr.fromFormula(pF, this.fmgr, new Function<BooleanFormula, Region>(){

            public Region apply(BooleanFormula pInput) {
                if (AbstractionManager.this.atomToPredicate.containsKey(pInput)) {
                    return ((AbstractionPredicate)AbstractionManager.this.atomToPredicate.get(pInput)).getAbstractVariable();
                }
                return AbstractionManager.this.makePredicate(pInput).getAbstractVariable();
            }
        });
    }

    public RegionCreator getRegionCreator() {
        return new RegionCreator();
    }

    public class RegionCreator {
        public RegionManager.RegionBuilder newRegionBuilder(ShutdownNotifier pShutdownNotifier) {
            return AbstractionManager.this.rmgr.builder(pShutdownNotifier);
        }

        public Region makeTrue() {
            return AbstractionManager.this.rmgr.makeTrue();
        }

        public Region makeFalse() {
            return AbstractionManager.this.rmgr.makeFalse();
        }

        public Region makeNot(Region f) {
            return AbstractionManager.this.rmgr.makeNot(f);
        }

        public Region makeAnd(Region f1, Region f2) {
            return AbstractionManager.this.rmgr.makeAnd(f1, f2);
        }

        public Region makeOr(Region f1, Region f2) {
            return AbstractionManager.this.rmgr.makeOr(f1, f2);
        }

        public Region makeEqual(Region f1, Region f2) {
            return AbstractionManager.this.rmgr.makeEqual(f1, f2);
        }

        public Region makeIte(Region f1, Region f2, Region f3) {
            return AbstractionManager.this.rmgr.makeIte(f1, f2, f3);
        }

        public Region makeExists(Region f1, Region f2) {
            return AbstractionManager.this.rmgr.makeExists(f1, f2);
        }

        public Region getPredicate(BooleanFormula var) {
            return AbstractionManager.this.getPredicate(var).getAbstractVariable();
        }
    }

    private class AbstractionPredicatesMBean
    extends AbstractMBean
    implements AbstractionPredicatesMXBean {
        public AbstractionPredicatesMBean() {
            super("org.sosy_lab.cpachecker:type=predicate,name=AbstractionPredicates", AbstractionManager.this.logger);
            this.register();
        }

        @Override
        public int getNumberOfPredicates() {
            return AbstractionManager.this.numberOfPredicates;
        }

        @Override
        public String getPredicates() {
            return Joiner.on((char)'\n').join(AbstractionManager.this.absVarToPredicate.values());
        }
    }

    public static interface AbstractionPredicatesMXBean {
        public int getNumberOfPredicates();

        public String getPredicates();
    }
}

