/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.counterexample.Address;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteState;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteStatePath;
import org.sosy_lab.cpachecker.core.counterexample.FieldReference;
import org.sosy_lab.cpachecker.core.counterexample.IDExpression;
import org.sosy_lab.cpachecker.core.counterexample.LeftHandSide;
import org.sosy_lab.cpachecker.core.counterexample.Memory;
import org.sosy_lab.cpachecker.core.counterexample.MemoryName;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;

public class AssignmentToPathAllocator {
    private static final String ADDRESS_PREFIX = "__ADDRESS_OF_";
    private static final int FIRST = 0;
    private static final int IS_NOT_GLOBAL = 2;
    private static final int NAME_AND_FUNCTION = 0;
    private static final int IS_FIELD_REFERENCE = 1;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private MemoryName memoryName = new MemoryName(){

        @Override
        public String getMemoryName(CRightHandSide pExp, Address pAddress) {
            CType type = pExp.getExpressionType().getCanonicalType();
            type = CTypes.withoutConst(type);
            type = CTypes.withoutVolatile(type);
            return "*" + type.toString().replace(" ", "_");
        }
    };

    public AssignmentToPathAllocator(LogManager pLogger, ShutdownNotifier pShutdownNotifier) {
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
    }

    public Pair<CFAPathWithAssumptions, Multimap<CFAEdge, Model.AssignableTerm>> allocateAssignmentsToPath(List<CFAEdge> pPath, Model pModel, List<SSAMap> pSSAMaps, MachineModel pMachineModel) throws InterruptedException {
        Pair<ConcreteStatePath, Multimap<CFAEdge, Model.AssignableTerm>> concreteStatePath = this.createConcreteStatePath(pPath, pModel, pSSAMaps, pMachineModel);
        CFAPathWithAssumptions pathWithAssignments = CFAPathWithAssumptions.of((ConcreteStatePath)concreteStatePath.getFirst(), this.logger, pMachineModel);
        return Pair.of((Object)pathWithAssignments, (Object)concreteStatePath.getSecond());
    }

    private Pair<ConcreteStatePath, Multimap<CFAEdge, Model.AssignableTerm>> createConcreteStatePath(List<CFAEdge> pPath, Model pModel, List<SSAMap> pSSAMaps, MachineModel pMachineModel) throws InterruptedException {
        AssignableTermsInPath assignableTerms = this.assignTermsToPathPosition(pSSAMaps, pModel);
        ArrayList<ConcreteStatePath.ConcerteStatePathNode> pathWithAssignments = new ArrayList<ConcreteStatePath.ConcerteStatePathNode>(pPath.size());
        HashMultimap usedAssignableTerms = HashMultimap.create();
        Map<LeftHandSide, Address> addressOfVariables = this.getVariableAddresses(assignableTerms, pModel);
        HashMap<String, Assignment> variableEnvoirment = new HashMap<String, Assignment>();
        HashMap<LeftHandSide, Object> variables = new HashMap<LeftHandSide, Object>();
        HashMultimap functionEnvoirment = HashMultimap.create();
        HashMap<String, Map<Address, Object>> memory = new HashMap<String, Map<Address, Object>>();
        int ssaMapIndex = 0;
        for (int pathIndex = 0; pathIndex < pPath.size(); ++pathIndex) {
            this.shutdownNotifier.shutdownIfNecessary();
            CFAEdge cfaEdge = pPath.get(pathIndex);
            if (cfaEdge.getEdgeType() == CFAEdgeType.MultiEdge) {
                MultiEdge multiEdge = (MultiEdge)cfaEdge;
                ArrayList<ConcreteState> singleConcreteStates = new ArrayList<ConcreteState>(multiEdge.getEdges().size());
                int multiEdgeIndex = 0;
                for (CFAEdge singleCfaEdge : multiEdge) {
                    variableEnvoirment = new HashMap(variableEnvoirment);
                    variables = new HashMap(variables);
                    functionEnvoirment = HashMultimap.create((Multimap)functionEnvoirment);
                    memory = new HashMap<String, Map<Address, Object>>(memory);
                    Collection terms = assignableTerms.getAssignableTermsAtPosition().get((Object)ssaMapIndex);
                    SSAMap ssaMap = pSSAMaps.get(ssaMapIndex);
                    ConcreteState concreteState = this.createSingleConcreteState(singleCfaEdge, ssaMap, variableEnvoirment, variables, (Multimap<String, Assignment>)functionEnvoirment, memory, addressOfVariables, terms, pModel, pMachineModel, (Multimap<CFAEdge, Model.AssignableTerm>)usedAssignableTerms);
                    singleConcreteStates.add(multiEdgeIndex, concreteState);
                    ++ssaMapIndex;
                    ++multiEdgeIndex;
                }
                ConcreteStatePath.ConcerteStatePathNode edge = ConcreteStatePath.valueOfPathNode(singleConcreteStates, multiEdge);
                pathWithAssignments.add(edge);
                continue;
            }
            variableEnvoirment = new HashMap(variableEnvoirment);
            functionEnvoirment = HashMultimap.create((Multimap)functionEnvoirment);
            Collection terms = assignableTerms.getAssignableTermsAtPosition().get((Object)ssaMapIndex);
            SSAMap ssaMap = pSSAMaps.get(ssaMapIndex);
            ConcreteStatePath.ConcerteStatePathNode concreteStatePathNode = this.createSingleConcreteStateNode(cfaEdge, ssaMap, variableEnvoirment, variables, (Multimap<String, Assignment>)functionEnvoirment, memory, addressOfVariables, terms, pModel, pMachineModel, (Multimap<CFAEdge, Model.AssignableTerm>)usedAssignableTerms);
            pathWithAssignments.add(concreteStatePathNode);
            ++ssaMapIndex;
        }
        ConcreteStatePath concreteStatePath = new ConcreteStatePath(pathWithAssignments);
        return Pair.of((Object)concreteStatePath, (Object)usedAssignableTerms);
    }

    private ConcreteStatePath.ConcerteStatePathNode createSingleConcreteStateNode(CFAEdge cfaEdge, SSAMap ssaMap, Map<String, Assignment> variableEnvoirment, Map<LeftHandSide, Object> variables, Multimap<String, Assignment> functionEnvoirment, Map<String, Map<Address, Object>> memory, Map<LeftHandSide, Address> addressOfVariables, Collection<Model.AssignableTerm> terms, Model pModel, MachineModel pMachineModel, Multimap<CFAEdge, Model.AssignableTerm> usedAssignableTerms) {
        ConcreteState concreteState = this.createSingleConcreteState(cfaEdge, ssaMap, variableEnvoirment, variables, functionEnvoirment, memory, addressOfVariables, terms, pModel, pMachineModel, usedAssignableTerms);
        return ConcreteStatePath.valueOfPathNode(concreteState, cfaEdge);
    }

    private ConcreteState createSingleConcreteState(CFAEdge cfaEdge, SSAMap ssaMap, Map<String, Assignment> variableEnvoirment, Map<LeftHandSide, Object> variables, Multimap<String, Assignment> functionEnvoirment, Map<String, Map<Address, Object>> memory, Map<LeftHandSide, Address> addressOfVariables, Collection<Model.AssignableTerm> terms, Model pModel, MachineModel pMachineModel, Multimap<CFAEdge, Model.AssignableTerm> usedAssignableTerms) {
        HashSet<Assignment> termSet = new HashSet<Assignment>();
        this.createAssignments(pModel, terms, termSet, variableEnvoirment, variables, functionEnvoirment, memory);
        this.removeDeallocatedVariables(ssaMap, variableEnvoirment);
        Map<String, Memory> allocatedMemory = this.createAllocatedMemory(memory);
        ConcreteState concreteState = new ConcreteState(variables, allocatedMemory, addressOfVariables, this.memoryName);
        usedAssignableTerms.putAll((Object)cfaEdge, terms);
        return concreteState;
    }

    private Map<String, Memory> createAllocatedMemory(Map<String, Map<Address, Object>> pMemory) {
        HashMap memory = Maps.newHashMapWithExpectedSize((int)pMemory.size());
        for (Map.Entry<String, Map<Address, Object>> heapObject : pMemory.entrySet()) {
            Memory heap = new Memory(heapObject.getKey(), heapObject.getValue());
            memory.put(heap.getName(), heap);
        }
        return memory;
    }

    private LeftHandSide createLeftHandSide(Model.Variable pTerm) {
        String termName = pTerm.getName();
        return this.createLeftHandSide(termName);
    }

    private LeftHandSide createLeftHandSide(String pTermName) {
        boolean isReference;
        String[] references = pTermName.split("$");
        String nameAndFunctionAsString = references[0];
        String[] nameAndFunction = nameAndFunctionAsString.split("::");
        String name = null;
        String function = null;
        boolean isNotGlobal = nameAndFunction.length == 2;
        boolean bl = isReference = references.length > 1;
        if (isNotGlobal) {
            function = nameAndFunction[0];
            name = nameAndFunction[1];
        } else {
            name = nameAndFunction[0];
        }
        if (isReference) {
            List<String> fieldNames = Arrays.asList(references);
            fieldNames.remove(0);
            if (isNotGlobal) {
                return new FieldReference(name, function, fieldNames);
            }
            return new FieldReference(name, fieldNames);
        }
        if (isNotGlobal) {
            return new IDExpression(name, function);
        }
        return new IDExpression(name);
    }

    private void removeDeallocatedVariables(SSAMap pMap, Map<String, Assignment> variableEnvoirment) {
        HashSet<String> variableNames = new HashSet<String>(variableEnvoirment.keySet());
        for (String name : variableNames) {
            if (pMap.getIndex(name) >= 0) continue;
            variableEnvoirment.remove(name);
        }
    }

    private void createAssignments(Model pModel, Collection<Model.AssignableTerm> terms, Set<Assignment> termSet, Map<String, Assignment> variableEnvoirment, Map<LeftHandSide, Object> pVariables, Multimap<String, Assignment> functionEnvoirment, Map<String, Map<Address, Object>> memory) {
        for (Model.AssignableTerm term : terms) {
            String name;
            Assignment assignment = new Assignment(term, pModel.get(term));
            if (term instanceof Model.Variable) {
                Model.Variable variable = (Model.Variable)term;
                name = variable.getName();
                if (variableEnvoirment.containsKey(name)) {
                    int newIndex;
                    Model.Variable oldVariable = (Model.Variable)variableEnvoirment.get(name).getTerm();
                    int oldIndex = oldVariable.getSSAIndex();
                    if (oldIndex < (newIndex = variable.getSSAIndex())) {
                        variableEnvoirment.remove(name);
                        variableEnvoirment.put(name, assignment);
                        LeftHandSide oldlhs = this.createLeftHandSide(oldVariable);
                        LeftHandSide lhs = this.createLeftHandSide(variable);
                        pVariables.remove(oldlhs);
                        pVariables.put(lhs, assignment.getValue());
                    }
                } else {
                    variableEnvoirment.put(name, assignment);
                    LeftHandSide lhs = this.createLeftHandSide(variable);
                    pVariables.put(lhs, assignment.getValue());
                }
            } else if (term instanceof Model.Function) {
                Model.Function function = (Model.Function)term;
                name = this.getName(function);
                if (functionEnvoirment.containsKey((Object)name)) {
                    boolean replaced = false;
                    HashSet assignments = new HashSet(functionEnvoirment.get((Object)name));
                    for (Assignment oldAssignment : assignments) {
                        Model.Function oldFunction = (Model.Function)oldAssignment.getTerm();
                        if (!this.isLessSSA(oldFunction, function)) continue;
                        functionEnvoirment.remove((Object)name, (Object)oldAssignment);
                        functionEnvoirment.put((Object)name, (Object)assignment);
                        replaced = true;
                        this.removeHeapValue(memory, assignment);
                        this.addHeapValue(memory, assignment);
                    }
                    if (!replaced) {
                        functionEnvoirment.put((Object)name, (Object)assignment);
                        this.addHeapValue(memory, assignment);
                    }
                } else {
                    functionEnvoirment.put((Object)name, (Object)assignment);
                    this.addHeapValue(memory, assignment);
                }
            }
            termSet.add(assignment);
        }
    }

    private void removeHeapValue(Map<String, Map<Address, Object>> memory, Assignment pFunctionAssignment) {
        Model.Function function = (Model.Function)pFunctionAssignment.getTerm();
        String heapName = this.getName(function);
        Map<Address, Object> heap = memory.get(heapName);
        if (function.getArity() != 1) {
            throw new AssertionError();
        }
        Address address = Address.valueOf(function.getArgument(0));
        heap.remove(address);
    }

    private void addHeapValue(Map<String, Map<Address, Object>> memory, Assignment pFunctionAssignment) {
        Model.Function function = (Model.Function)pFunctionAssignment.getTerm();
        String heapName = this.getName(function);
        if (!memory.containsKey(heapName)) {
            memory.put(heapName, new HashMap());
        }
        Map<Address, Object> heap = memory.get(heapName);
        if (function.getArity() != 1) {
            throw new AssertionError();
        }
        Address address = Address.valueOf(function.getArgument(0));
        Object value = pFunctionAssignment.getValue();
        heap.put(address, value);
    }

    private Map<LeftHandSide, Address> getVariableAddresses(AssignableTermsInPath assignableTerms, Model pModel) {
        HashMap<LeftHandSide, Address> addressOfVariables = new HashMap<LeftHandSide, Address>();
        for (Model.Constant constant : assignableTerms.getConstants()) {
            String name = constant.getName();
            if (!name.startsWith(ADDRESS_PREFIX) || !pModel.containsKey(constant)) continue;
            Object addressValue = pModel.get(constant);
            Address address = Address.valueOf(addressValue);
            String constantName = name.substring(ADDRESS_PREFIX.length());
            LeftHandSide leftHandSide = this.createLeftHandSide(constantName);
            addressOfVariables.put(leftHandSide, address);
        }
        return ImmutableMap.copyOf(addressOfVariables);
    }

    private boolean isLessSSA(Model.Function pOldFunction, Model.Function pFunction) {
        int oldArity;
        String oldName;
        String name = this.getName(pFunction);
        if (!name.equals(oldName = this.getName(pFunction))) {
            return false;
        }
        int ssa = this.getSSAIndex(pFunction);
        int oldSSA = this.getSSAIndex(pOldFunction);
        if (oldSSA > ssa) {
            return false;
        }
        int arity = pFunction.getArity();
        if (arity != (oldArity = pOldFunction.getArity())) {
            return false;
        }
        for (int c = 0; c < arity; ++c) {
            if (pOldFunction.getArgument(c).equals(pFunction.getArgument(c))) continue;
            return false;
        }
        return true;
    }

    private AssignableTermsInPath assignTermsToPathPosition(List<SSAMap> pSsaMaps, Model pModel) {
        HashMultimap assignedTermsPosition = HashMultimap.create();
        HashSet<Model.Constant> constants = new HashSet<Model.Constant>();
        HashSet<Model.Function> functionsWithoutSSAIndex = new HashSet<Model.Function>();
        for (Model.AssignableTerm term : pModel.keySet()) {
            if (term instanceof Model.Variable) {
                int index = this.findFirstOccurrenceOfVariable((Model.Variable)term, pSsaMaps);
                if (index < 0) continue;
                assignedTermsPosition.put((Object)index, (Object)term);
                continue;
            }
            if (term instanceof Model.Function) {
                Model.Function function = (Model.Function)term;
                if (this.getSSAIndex(function) == -2) {
                    functionsWithoutSSAIndex.add(function);
                    continue;
                }
                int index = this.findFirstOccurrenceOfVariable(function, pSsaMaps);
                if (index < 0) continue;
                assignedTermsPosition.put((Object)index, (Object)term);
                continue;
            }
            if (!(term instanceof Model.Constant)) continue;
            constants.add((Model.Constant)term);
        }
        return new AssignableTermsInPath((Multimap<Integer, Model.AssignableTerm>)assignedTermsPosition, constants, functionsWithoutSSAIndex);
    }

    private int getSSAIndex(Model.Function pTerm) {
        String index;
        String[] nameAndIndex = pTerm.getName().split("@");
        if (nameAndIndex.length == 2 && (index = nameAndIndex[1]).matches("\\d*")) {
            return Integer.parseInt(index);
        }
        return -2;
    }

    private String getName(Model.Function pTerm) {
        String[] nameAndIndex = pTerm.getName().split("@");
        if (nameAndIndex.length == 2) {
            return nameAndIndex[0];
        }
        return pTerm.getName();
    }

    int findFirstOccurrenceOfVariable(Model.Variable pVar, List<SSAMap> pSsaMaps) {
        int upper;
        int lower = 0;
        int result = -1;
        if (pSsaMaps.size() <= 0) {
            return result;
        }
        for (upper = pSsaMaps.size() - 1; upper >= 0 && !pSsaMaps.get(upper).containsVariable(pVar.getName()); --upper) {
        }
        if (upper < 0) {
            return result;
        }
        while (true) {
            if (upper - lower <= 0) {
                int ssaIndex;
                if (upper - lower == 0 && (ssaIndex = pSsaMaps.get(upper).getIndex(pVar.getName())) == pVar.getSSAIndex()) {
                    result = upper;
                }
                return result;
            }
            int index = IntMath.mean((int)lower, (int)upper);
            int ssaIndex = pSsaMaps.get(index).getIndex(pVar.getName());
            if (ssaIndex < pVar.getSSAIndex()) {
                lower = index + 1;
                continue;
            }
            if (ssaIndex > pVar.getSSAIndex()) {
                upper = index - 1;
                continue;
            }
            assert (result == -1 || result > index);
            result = index;
            upper = index - 1;
        }
    }

    int findFirstOccurrenceOfVariable(Model.Function pTerm, List<SSAMap> pSsaMaps) {
        int lower = 0;
        int upper = pSsaMaps.size() - 1;
        int result = -1;
        while (true) {
            if (upper - lower <= 0) {
                int ssaIndex;
                if (upper - lower == 0 && (ssaIndex = pSsaMaps.get(upper).getIndex(this.getName(pTerm))) == this.getSSAIndex(pTerm)) {
                    result = upper;
                }
                return result;
            }
            int index = IntMath.mean((int)lower, (int)upper);
            int ssaIndex = pSsaMaps.get(index).getIndex(this.getName(pTerm));
            if (ssaIndex < this.getSSAIndex(pTerm)) {
                lower = index + 1;
                continue;
            }
            if (ssaIndex > this.getSSAIndex(pTerm)) {
                upper = index - 1;
                continue;
            }
            assert (result == -1 || result > index);
            result = index;
            upper = index - 1;
        }
    }

    private static final class AssignableTermsInPath {
        private final Multimap<Integer, Model.AssignableTerm> assignableTermsAtPosition;
        private final Set<Model.Constant> constants;
        private final Set<Model.Function> ufFunctionsWithoutSSAIndex;

        public AssignableTermsInPath(Multimap<Integer, Model.AssignableTerm> pAssignableTermsAtPosition, Set<Model.Constant> pConstants, Set<Model.Function> pUfFunctionsWithoutSSAIndex) {
            this.assignableTermsAtPosition = ImmutableMultimap.copyOf(pAssignableTermsAtPosition);
            this.constants = ImmutableSet.copyOf(pConstants);
            this.ufFunctionsWithoutSSAIndex = ImmutableSet.copyOf(pUfFunctionsWithoutSSAIndex);
        }

        public Multimap<Integer, Model.AssignableTerm> getAssignableTermsAtPosition() {
            return this.assignableTermsAtPosition;
        }

        public Set<Model.Constant> getConstants() {
            return this.constants;
        }

        public Set<Model.Function> getUfFunctionsWithoutSSAIndex() {
            return this.ufFunctionsWithoutSSAIndex;
        }

        public String toString() {
            return "AssignableTermsInPath\nassignableTermsAtPosition=" + this.assignableTermsAtPosition + "\n " + "constants=" + this.constants + "\n" + "ufFunctionsWithoutSSAIndex=" + this.ufFunctionsWithoutSSAIndex;
        }
    }

    private static final class Assignment {
        private final Model.AssignableTerm term;
        private final Object value;

        public Assignment(Model.AssignableTerm pTerm, Object pValue) {
            this.term = pTerm;
            this.value = pValue;
        }

        public Model.AssignableTerm getTerm() {
            return this.term;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return "term: " + this.term.toString() + "value: " + this.value.toString();
        }
    }
}

