/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.util.predicates.AssignmentToPathAllocator;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;

public class AssignmentToPathAllocatorTest {
    private AssignmentToPathAllocator allocator;

    @Before
    public void setUp() throws Exception {
        this.allocator = new AssignmentToPathAllocator(TestLogManager.getInstance(), ShutdownNotifier.create());
    }

    @Test
    public void testFindFirstOccurrenceOfVariable() {
        Model.Variable varX = new Model.Variable("x", 4, Model.TermType.Integer);
        Model.Variable varY = new Model.Variable("y", 5, Model.TermType.Integer);
        Model.Variable varZ = new Model.Variable("z", 6, Model.TermType.Integer);
        SSAMap.SSAMapBuilder ssaMapBuilder = SSAMap.emptySSAMap().builder();
        ArrayList ssaMaps = Lists.newArrayList();
        ssaMaps.add(SSAMap.emptySSAMap());
        ssaMapBuilder.setIndex("x", CNumericTypes.INT, 4);
        ssaMaps.add(ssaMapBuilder.build());
        ssaMapBuilder.setIndex("y", CNumericTypes.INT, 5);
        ssaMapBuilder.setIndex("z", CNumericTypes.INT, 6);
        ssaMaps.add(ssaMapBuilder.build());
        ssaMapBuilder.deleteVariable("z");
        ssaMaps.add(ssaMapBuilder.build());
        Assert.assertEquals((long)1L, (long)this.allocator.findFirstOccurrenceOfVariable(varX, (List<SSAMap>)ssaMaps));
        Assert.assertEquals((long)2L, (long)this.allocator.findFirstOccurrenceOfVariable(varY, (List<SSAMap>)ssaMaps));
        Assert.assertEquals((long)2L, (long)this.allocator.findFirstOccurrenceOfVariable(varZ, (List<SSAMap>)ssaMaps));
    }
}

