/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;

@Options(prefix="cpa.predicate.blk")
public class BlockOperator {
    @Option(secure=true, description="maximum blocksize before abstraction is forced\n(non-negative number, special values: 0 = don't check threshold, 1 = SBE)")
    private int threshold = 0;
    @Option(secure=true, name="functions", description="abstractions at function calls/returns if threshold has been reached (no effect if threshold = 0)")
    private boolean absOnFunction = false;
    @Option(secure=true, name="loops", description="abstractions at loop heads if threshold has been reached (no effect if threshold = 0)")
    private boolean absOnLoop = false;
    @Option(secure=true, name="join", description="abstractions at CFA nodes with more than one incoming edge if threshold has been reached (no effect if threshold = 0)")
    private boolean absOnJoin = false;
    @Option(secure=true, description="force abstractions immediately after threshold is reached (no effect if threshold = 0)")
    private boolean alwaysAfterThreshold = true;
    @Option(secure=true, description="force abstractions at loop heads, regardless of threshold")
    private boolean alwaysAtLoops = true;
    @Option(secure=true, description="force abstractions at each function calls/returns, regardless of threshold")
    private boolean alwaysAtFunctions = true;
    @Option(secure=true, description="force abstractions at each function head (first node in the body), regardless of threshold")
    private boolean alwaysAtFunctionHeads = false;
    @Option(secure=true, description="force abstractions at the head of the analysis-entry function (first node in the body), regardless of threshold")
    private boolean alwaysAtEntryFunctionHead = false;
    @Option(secure=true, description="force abstractions at each function call (node before entering the body), regardless of threshold")
    private boolean alwaysAtFunctionCallNodes = false;
    @Option(secure=true, description="force abstractions at each join node, regardless of threshold")
    private boolean alwaysAtJoin = false;
    @Option(secure=true, description="force abstractions at each branch node, regardless of threshold")
    private boolean alwaysAtBranch = false;
    @Option(secure=true, description="abstraction always and only on explicitly computed abstraction nodes.")
    private boolean alwaysAndOnlyAtExplicitNodes = false;
    private ImmutableSet<CFANode> explicitAbstractionNodes = null;
    private ImmutableSet<CFANode> loopHeads = null;
    public int numBlkEntryFunctionHeads = 0;
    public int numBlkFunctionHeads = 0;
    public int numBlkFunctions = 0;
    public int numBlkLoops = 0;
    public int numBlkJoins = 0;
    public int numBlkBranch = 0;
    public int numBlkThreshold = 0;
    private CFA cfa = null;

    public boolean isBlockEnd(CFANode succLoc, CFANode predLoc, CFAEdge edge, PathFormula pf) {
        if (this.alwaysAndOnlyAtExplicitNodes) {
            assert (this.explicitAbstractionNodes != null);
            return this.explicitAbstractionNodes.contains((Object)predLoc);
        }
        if (this.alwaysAtFunctions && this.isFunctionCall(succLoc)) {
            ++this.numBlkFunctions;
            return true;
        }
        if (this.alwaysAtEntryFunctionHead && BlockOperator.isFirstLocationInFunctionBody(succLoc)) {
            Preconditions.checkNotNull((Object)this.cfa);
            if (this.cfa.getMainFunction().getFunctionName().equals(edge.getPredecessor().getFunctionName())) {
                ++this.numBlkEntryFunctionHeads;
                return true;
            }
        }
        if (this.alwaysAtFunctionHeads && this.isFunctionHead(edge)) {
            ++this.numBlkFunctionHeads;
            return true;
        }
        if (this.alwaysAtFunctionCallNodes && this.isBeforeFunctionCall(succLoc)) {
            ++this.numBlkFunctionHeads;
            return true;
        }
        if (this.alwaysAtLoops && this.isLoopHead(succLoc)) {
            ++this.numBlkLoops;
            return true;
        }
        if (this.alwaysAtJoin && this.isJoinNode(succLoc)) {
            ++this.numBlkJoins;
            return true;
        }
        if (this.alwaysAtBranch && this.isBranchNode(succLoc)) {
            ++this.numBlkBranch;
            return true;
        }
        if (this.threshold > 0) {
            if (this.threshold == 1) {
                return true;
            }
            if (this.isThresholdFulfilled(pf)) {
                if (this.alwaysAfterThreshold) {
                    ++this.numBlkThreshold;
                    return true;
                }
                if (this.absOnFunction && this.isFunctionCall(succLoc)) {
                    ++this.numBlkThreshold;
                    ++this.numBlkFunctions;
                    return true;
                }
                if (this.absOnLoop && this.isLoopHead(succLoc)) {
                    ++this.numBlkThreshold;
                    ++this.numBlkLoops;
                    return true;
                }
                if (this.absOnJoin && this.isJoinNode(succLoc)) {
                    ++this.numBlkThreshold;
                    ++this.numBlkJoins;
                    return true;
                }
            }
        } else {
            assert (this.threshold == 0);
            if (this.absOnFunction && this.isFunctionCall(succLoc)) {
                ++this.numBlkFunctions;
                return true;
            }
            if (this.absOnLoop && this.isLoopHead(succLoc)) {
                ++this.numBlkLoops;
                return true;
            }
        }
        return false;
    }

    protected boolean isJoinNode(CFANode pSuccLoc) {
        return pSuccLoc.getNumEnteringEdges() > 1;
    }

    protected boolean isThresholdFulfilled(PathFormula pf) {
        return pf.getLength() >= this.threshold;
    }

    protected boolean isLoopHead(CFANode succLoc) {
        Preconditions.checkState((this.loopHeads != null ? 1 : 0) != 0, (Object)"Missing loop information");
        return this.loopHeads.contains((Object)succLoc);
    }

    protected boolean isFunctionCall(CFANode succLoc) {
        return succLoc instanceof FunctionEntryNode || succLoc.getEnteringSummaryEdge() != null;
    }

    public void setExplicitAbstractionNodes(ImmutableSet<CFANode> pNodes) {
        this.explicitAbstractionNodes = pNodes;
    }

    public void setCFA(CFA pCfa) {
        this.cfa = pCfa;
        if ((this.absOnLoop || this.alwaysAtLoops) && this.cfa.getAllLoopHeads().isPresent()) {
            this.loopHeads = (ImmutableSet)this.cfa.getAllLoopHeads().get();
        }
    }

    protected boolean isBranchNode(CFANode pLoc) {
        return pLoc.getNumLeavingEdges() > 1;
    }

    protected boolean isFunctionHead(CFAEdge edge) {
        CDeclarationEdge e;
        return edge instanceof CDeclarationEdge && (e = (CDeclarationEdge)edge).getDeclaration() instanceof CFunctionDeclaration;
    }

    private boolean isBeforeFunctionCall(CFANode succLoc) {
        return succLoc.getLeavingSummaryEdge() != null;
    }

    public static boolean isFirstLocationInFunctionBody(CFANode pLoc) {
        ArrayList edges = Lists.newArrayList(CFAUtils.enteringEdges(pLoc));
        for (CFAEdge edge : edges) {
            CDeclarationEdge e;
            if (!(edge instanceof CDeclarationEdge) || !((e = (CDeclarationEdge)edge).getDeclaration() instanceof CFunctionDeclaration)) continue;
            return true;
        }
        return false;
    }
}

