/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sosy_lab.common.ChildFirstPatternClassLoader;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;

@Options(prefix="cpa.predicate")
public class FormulaManagerFactory {
    @Option(secure=true, name="solver.logAllQueries", description="Export solver queries in Smtlib format into a file.")
    private boolean logAllQueries = false;
    @Option(secure=true, name="solver.logfile", description="Export solver queries in Smtlib format into a file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathCounterTemplate logfile = PathCounterTemplate.ofFormatString((String)"smtquery.%03d.smt2");
    @Option(secure=true, description="Which SMT solver to use.")
    private Solvers solver = Solvers.SMTINTERPOL;
    @Option(secure=true, description="Which solver to use specifically for interpolation (default is to use the main one).")
    private Solvers interpolationSolver = null;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final FormulaManager fmgr;
    private final FormulaManager itpFmgr;
    private volatile SolverFactory smtInterpolFactory = null;
    private static final Pattern SMTINTERPOL_CLASSES = Pattern.compile("^(org\\.sosy_lab\\.cpachecker\\.util\\.predicates\\.smtInterpol|de\\.uni_freiburg\\.informatik\\.ultimate|java_cup\\.runtime|org\\.apache\\.log4j)\\..*");
    private static final String SMTINTERPOL_FACTORY_CLASS = "org.sosy_lab.cpachecker.util.predicates.smtInterpol.SmtInterpolSolverFactory";
    private static WeakReference<ClassLoader> smtInterpolClassLoader = new WeakReference<Object>(null);
    private static final AtomicInteger smtInterpolLoadingCount = new AtomicInteger(0);

    @VisibleForTesting
    public FormulaManagerFactory(Configuration config, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        if (!this.logAllQueries) {
            this.logfile = null;
        }
        if (this.solver.equals((Object)this.interpolationSolver)) {
            this.interpolationSolver = null;
        }
        this.fmgr = this.instantiateSolver(this.solver, config);
        this.itpFmgr = this.interpolationSolver != null ? this.instantiateSolver(this.interpolationSolver, config) : this.fmgr;
    }

    /*
     * Exception decompiling
     */
    private FormulaManager instantiateSolver(Solvers solver, Configuration config) throws InvalidConfigurationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FormulaManager getFormulaManager() {
        return this.fmgr;
    }

    public FormulaManager getFormulaManagerForInterpolation() {
        return this.itpFmgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SolverFactory loadSmtInterpol() {
        SolverFactory result = this.smtInterpolFactory;
        if (result == null) {
            FormulaManagerFactory formulaManagerFactory = this;
            synchronized (formulaManagerFactory) {
                result = this.smtInterpolFactory;
                if (result == null) {
                    try {
                        ClassLoader classLoader = FormulaManagerFactory.getClassLoader(this.logger);
                        Class<?> factoryClass = classLoader.loadClass(SMTINTERPOL_FACTORY_CLASS);
                        Constructor<?> factoryConstructor = factoryClass.getConstructor(new Class[0]);
                        this.smtInterpolFactory = result = (SolverFactory)factoryConstructor.newInstance(new Object[0]);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new Classes.UnexpectedCheckedException("Failed to load SmtInterpol", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    private static ClassLoader getClassLoader(LogManager logger) {
        ClassLoader classLoader = (ClassLoader)smtInterpolClassLoader.get();
        if (classLoader != null) {
            return classLoader;
        }
        if (smtInterpolLoadingCount.incrementAndGet() > 1) {
            logger.log(Level.INFO, new Object[]{"Repeated loading of SmtInterpol"});
        }
        if ((classLoader = FormulaManagerFactory.class.getClassLoader()) instanceof URLClassLoader) {
            URL[] urls = (URL[])FluentIterable.from(Arrays.asList(((URLClassLoader)classLoader).getURLs())).filter((Predicate)new Predicate<URL>(){

                public boolean apply(@Nonnull URL pInput) {
                    return !pInput.getPath().contains("java-cup");
                }
            }).toArray(URL.class);
            classLoader = new ChildFirstPatternClassLoader(SMTINTERPOL_CLASSES, urls, classLoader);
        }
        smtInterpolClassLoader = new WeakReference<ClassLoader>(classLoader);
        return classLoader;
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$org$sosy_lab$cpachecker$util$predicates$FormulaManagerFactory$Solvers;

        static {
            $SwitchMap$org$sosy_lab$cpachecker$util$predicates$FormulaManagerFactory$Solvers = new int[Solvers.values().length];
            try {
                2.$SwitchMap$org$sosy_lab$cpachecker$util$predicates$FormulaManagerFactory$Solvers[Solvers.SMTINTERPOL.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$sosy_lab$cpachecker$util$predicates$FormulaManagerFactory$Solvers[Solvers.MATHSAT5.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$sosy_lab$cpachecker$util$predicates$FormulaManagerFactory$Solvers[Solvers.Z3.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$sosy_lab$cpachecker$util$predicates$FormulaManagerFactory$Solvers[Solvers.PRINCESS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static interface SolverFactory {
        public FormulaManager create(Configuration var1, LogManager var2, ShutdownNotifier var3, @Nullable PathCounterTemplate var4) throws InvalidConfigurationException;
    }

    @VisibleForTesting
    public static enum Solvers {
        MATHSAT5,
        SMTINTERPOL,
        Z3,
        PRINCESS;

    }
}

