/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.collect.ImmutableSortedSet;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;

public class FormulaMeasuring {
    private final FormulaManagerView managerView;

    public FormulaMeasuring(FormulaManagerView pManagerView) {
        this.managerView = pManagerView;
    }

    public FormulaMeasures measure(BooleanFormula formula) {
        FormulaMeasures result = new FormulaMeasures();
        new FormulaMeasuringVisitor(this.managerView, result).visit(formula);
        return result;
    }

    private static class FormulaMeasuringVisitor
    extends BooleanFormulaManagerView.RecursiveBooleanFormulaVisitor {
        private final FormulaMeasures measures;
        private final FormulaManagerView fmgr;
        private final NumeralFormulaManagerView<NumeralFormula, NumeralFormula.RationalFormula> rfmgr;

        FormulaMeasuringVisitor(FormulaManagerView pFmgr, FormulaMeasures pMeasures) {
            super(pFmgr);
            this.measures = pMeasures;
            this.fmgr = pFmgr;
            this.rfmgr = pFmgr.getRationalFormulaManager();
        }

        @Override
        protected Void visitFalse() {
            this.measures.falses++;
            return null;
        }

        @Override
        protected Void visitTrue() {
            this.measures.trues++;
            return null;
        }

        @Override
        protected Void visitAtom(BooleanFormula pAtom) {
            this.measures.atoms++;
            BooleanFormula atom = this.fmgr.uninstantiate(pAtom);
            if (this.fmgr.isPurelyArithmetic(atom) && this.rfmgr.isEqual(atom)) {
                this.measures.arithmeticEquals++;
            }
            this.measures.variables.addAll(this.fmgr.extractVariableNames(atom));
            return null;
        }

        @Override
        protected Void visitNot(BooleanFormula pOperand) {
            this.measures.negations++;
            return super.visitNot(pOperand);
        }

        @Override
        protected Void visitAnd(BooleanFormula ... pOperands) {
            this.measures.conjunctions++;
            return super.visitAnd(pOperands);
        }

        @Override
        protected Void visitOr(BooleanFormula ... pOperand) {
            this.measures.disjunctions++;
            return super.visitOr(pOperand);
        }

        @Override
        protected Void visitEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            return super.visitEquivalence(pOperand1, pOperand2);
        }

        @Override
        protected Void visitIfThenElse(BooleanFormula pCondition, BooleanFormula pThenFormula, BooleanFormula pElseFormula) {
            return super.visitIfThenElse(pCondition, pThenFormula, pElseFormula);
        }

        @Override
        protected Void visitImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            return super.visitImplication(pOperand1, pOperand2);
        }
    }

    public static class FormulaMeasures {
        private int trues = 0;
        private int falses = 0;
        private int conjunctions = 0;
        private int disjunctions = 0;
        private int negations = 0;
        private int atoms = 0;
        private int arithmeticEquals = 0;
        private final Set<String> variables = new HashSet<String>();

        public int getArithmeticEquals() {
            return this.arithmeticEquals;
        }

        public int getAtoms() {
            return this.atoms;
        }

        public int getConjunctions() {
            return this.conjunctions;
        }

        public int getDisjunctions() {
            return this.disjunctions;
        }

        public int getFalses() {
            return this.falses;
        }

        public int getNegations() {
            return this.negations;
        }

        public int getTrues() {
            return this.trues;
        }

        public ImmutableSortedSet<String> getVariables() {
            return ImmutableSortedSet.copyOf(this.variables);
        }
    }
}

