/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public class NamedRegionManager
implements RegionManager {
    private final RegionManager delegate;
    private final BiMap<String, Region> regionMap = HashBiMap.create();
    private static final String ANONYMOUS_PREDICATE = "__anon_pred";
    private int anonymousPredicateCounter = 0;
    int nodeCounter;

    public NamedRegionManager(RegionManager pDelegate) {
        this.delegate = (RegionManager)Preconditions.checkNotNull((Object)pDelegate);
    }

    public Region createPredicate(String pName) {
        Region result = (Region)this.regionMap.get((Object)pName);
        if (result == null) {
            result = this.delegate.createPredicate();
            this.regionMap.put((Object)pName, (Object)result);
        }
        return result;
    }

    @Override
    public Region createPredicate() {
        return this.createPredicate(ANONYMOUS_PREDICATE + this.anonymousPredicateCounter++);
    }

    public Appender dumpRegion(final Region r) {
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable pAppendable) throws IOException {
                NamedRegionManager.this.dumpRegion(r, pAppendable);
            }
        };
    }

    private void dumpRegion(Region r, Appendable out) throws IOException {
        if (this.regionMap.containsValue((Object)r)) {
            out.append((CharSequence)this.regionMap.inverse().get((Object)r));
        } else if (r.isFalse()) {
            out.append("FALSE");
        } else if (r.isTrue()) {
            out.append("TRUE");
        } else {
            Triple<Region, Region, Region> triple = this.delegate.getIfThenElse(r);
            String predName = (String)this.regionMap.inverse().get(triple.getFirst());
            Region trueBranch = (Region)triple.getSecond();
            Region falseBranch = (Region)triple.getThird();
            if (trueBranch.isFalse()) {
                assert (!falseBranch.isFalse());
                out.append("!").append(predName).append(" & ");
                this.dumpRegion(falseBranch, out);
            } else if (falseBranch.isFalse()) {
                out.append(predName).append(" & ");
                this.dumpRegion(trueBranch, out);
            } else {
                out.append("((").append(predName).append(" & ");
                this.dumpRegion(trueBranch, out);
                out.append(") | (").append("!").append(predName).append(" & ");
                this.dumpRegion(falseBranch, out);
                out.append("))");
            }
        }
    }

    public String regionToDot(Region r) {
        this.nodeCounter = 2;
        HashMap<Region, Integer> cache = new HashMap<Region, Integer>();
        StringBuilder str = new StringBuilder("digraph G {\n");
        if (!r.isTrue()) {
            str.append("0 [shape=box, label=\"0\", style=filled, shape=box, height=0.3, width=0.3];\n");
            cache.put(this.makeFalse(), 0);
        }
        if (!r.isFalse()) {
            str.append("1 [shape=box, label=\"1\", style=filled, shape=box, height=0.3, width=0.3];\n");
            cache.put(this.makeTrue(), 1);
        }
        this.regionToDot(r, str, cache);
        str.append("}\n");
        return str.toString();
    }

    private int regionToDot(Region r, StringBuilder str, Map<Region, Integer> cache) {
        if (cache.containsKey(r)) {
            return cache.get(r);
        }
        Triple<Region, Region, Region> triple = this.delegate.getIfThenElse(r);
        String predName = (String)this.regionMap.inverse().get(triple.getFirst());
        ++this.nodeCounter;
        int predNum = this.nodeCounter;
        str.append(predNum).append(" [label=\"").append(predName).append("\"];\n");
        Region trueBranch = (Region)triple.getSecond();
        int trueTarget = this.regionToDot(trueBranch, str, cache);
        str.append(predNum).append(" -> ").append(trueTarget).append(" [style=filled];\n");
        Region falseBranch = (Region)triple.getThird();
        int falseTarget = this.regionToDot(falseBranch, str, cache);
        str.append(predNum).append(" -> ").append(falseTarget).append(" [style=dotted];\n");
        cache.put(r, predNum);
        return predNum;
    }

    @Override
    public boolean entails(Region pF1, Region pF2) throws SolverException, InterruptedException {
        return this.delegate.entails(pF1, pF2);
    }

    @Override
    public Region makeTrue() {
        return this.delegate.makeTrue();
    }

    @Override
    public Region makeFalse() {
        return this.delegate.makeFalse();
    }

    @Override
    public Region makeNot(Region pF) {
        return this.delegate.makeNot(pF);
    }

    @Override
    public Region makeAnd(Region pF1, Region pF2) {
        return this.delegate.makeAnd(pF1, pF2);
    }

    @Override
    public Region makeOr(Region pF1, Region pF2) {
        return this.delegate.makeOr(pF1, pF2);
    }

    @Override
    public Region makeEqual(Region pF1, Region pF2) {
        return this.delegate.makeEqual(pF1, pF2);
    }

    @Override
    public Region makeUnequal(Region pF1, Region pF2) {
        return this.delegate.makeUnequal(pF1, pF2);
    }

    @Override
    public Region makeExists(Region pF1, Region ... pF2) {
        return this.delegate.makeExists(pF1, pF2);
    }

    @Override
    public RegionManager.RegionBuilder builder(ShutdownNotifier pShutdownNotifier) {
        return this.delegate.builder(pShutdownNotifier);
    }

    @Override
    public Region fromFormula(BooleanFormula pF, FormulaManagerView pFmgr, Function<BooleanFormula, Region> pAtomToRegion) {
        return this.delegate.fromFormula(pF, pFmgr, pAtomToRegion);
    }

    @Override
    public Triple<Region, Region, Region> getIfThenElse(Region pF) {
        return this.delegate.getIfThenElse(pF);
    }

    @Override
    public Set<Region> extractPredicates(Region pF) {
        return this.delegate.extractPredicates(pF);
    }

    @Override
    public void printStatistics(PrintStream out) {
        out.println("Number of named predicates:          " + (this.regionMap.size() - this.anonymousPredicateCounter));
        this.delegate.printStatistics(out);
    }

    @Override
    public String getVersion() {
        return this.delegate.getVersion();
    }

    public Set<String> getPredicates() {
        return this.regionMap.keySet();
    }

    @Override
    public Region makeIte(Region pF1, Region pF2, Region pF3) {
        return this.delegate.makeIte(pF1, pF2, pF3);
    }
}

