/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.AssignmentToPathAllocator;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interpolation.CounterexampleTraceInfo;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.SSAMap;

public class PathChecker {
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final PathFormulaManager pmgr;
    private final Solver solver;
    private final MachineModel machineModel;

    public PathChecker(LogManager pLogger, ShutdownNotifier pShutdownNotifier, PathFormulaManager pPmgr, Solver pSolver, MachineModel pMachineModel) {
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.pmgr = pPmgr;
        this.solver = pSolver;
        this.machineModel = pMachineModel;
    }

    public CounterexampleTraceInfo checkPath(List<CFAEdge> pPath) throws SolverException, CPATransferException, InterruptedException {
        Pair<PathFormula, List<SSAMap>> result = this.createPrecisePathFormula(pPath);
        List ssaMaps = (List)result.getSecond();
        PathFormula pathFormula = (PathFormula)result.getFirst();
        BooleanFormula f = pathFormula.getFormula();
        try (ProverEnvironment thmProver = this.solver.newProverEnvironmentWithModelGeneration();){
            thmProver.push(f);
            if (thmProver.isUnsat()) {
                CounterexampleTraceInfo counterexampleTraceInfo = CounterexampleTraceInfo.infeasibleNoItp();
                return counterexampleTraceInfo;
            }
            Model model = this.getModel(thmProver);
            Pair<CFAPathWithAssumptions, Multimap<CFAEdge, Model.AssignableTerm>> pathAndTerms = this.extractVariableAssignment(pPath, ssaMaps, model);
            CFAPathWithAssumptions pathWithAssignments = (CFAPathWithAssumptions)pathAndTerms.getFirst();
            Multimap termsPerEdge = (Multimap)pathAndTerms.getSecond();
            model = model.withAssignmentInformation(pathWithAssignments, (Multimap<CFAEdge, Model.AssignableTerm>)termsPerEdge);
            CounterexampleTraceInfo counterexampleTraceInfo = CounterexampleTraceInfo.feasible((List<BooleanFormula>)ImmutableList.of((Object)f), model, (Map<Integer, Boolean>)ImmutableMap.of());
            return counterexampleTraceInfo;
        }
    }

    private Pair<PathFormula, List<SSAMap>> createPrecisePathFormula(List<CFAEdge> pPath) throws CPATransferException, InterruptedException {
        ArrayList<SSAMap> ssaMaps = new ArrayList<SSAMap>(pPath.size());
        PathFormula pathFormula = this.pmgr.makeEmptyPathFormula();
        for (CFAEdge edge : FluentIterable.from(pPath).filter(Predicates.notNull())) {
            if (edge.getEdgeType() == CFAEdgeType.MultiEdge) {
                for (CFAEdge singleEdge : (MultiEdge)edge) {
                    pathFormula = this.pmgr.makeAnd(pathFormula, singleEdge);
                    ssaMaps.add(pathFormula.getSsa());
                }
                continue;
            }
            pathFormula = this.pmgr.makeAnd(pathFormula, edge);
            ssaMaps.add(pathFormula.getSsa());
        }
        return Pair.of((Object)pathFormula, ssaMaps);
    }

    public List<SSAMap> calculatePreciseSSAMaps(List<CFAEdge> pPath) throws CPATransferException, InterruptedException {
        return (List)this.createPrecisePathFormula(pPath).getSecond();
    }

    public Pair<CFAPathWithAssumptions, Multimap<CFAEdge, Model.AssignableTerm>> extractVariableAssignment(List<CFAEdge> pPath, List<SSAMap> pSsaMaps, Model pModel) throws InterruptedException {
        AssignmentToPathAllocator allocator = new AssignmentToPathAllocator(this.logger, this.shutdownNotifier);
        return allocator.allocateAssignmentsToPath(pPath, pModel, pSsaMaps, this.machineModel);
    }

    private Model getModel(ProverEnvironment thmProver) {
        try {
            return thmProver.getModel();
        }
        catch (SolverException e) {
            this.logger.log(Level.WARNING, new Object[]{"Solver could not produce model, variable assignment of error path can not be dumped."});
            this.logger.logDebugException((Throwable)e);
            return Model.empty();
        }
    }
}

