/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.Map;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.OptEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.OptEnvironmentView;
import org.sosy_lab.cpachecker.util.predicates.interpolation.SeparateInterpolatingProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.logging.LoggingInterpolatingProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.logging.LoggingOptEnvironment;
import org.sosy_lab.cpachecker.util.predicates.logging.LoggingProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatcher;

@Options(prefix="cpa.predicate")
public final class Solver
implements AutoCloseable {
    @Option(secure=true, name="solver.useLogger", description="log some solver actions, this may be slow!")
    private boolean useLogger = false;
    private final FormulaManagerView fmgr;
    private final BooleanFormulaManagerView bfmgr;
    private final FormulaManager solvingFormulaManager;
    private final FormulaManager interpolationFormulaManager;
    private final Map<BooleanFormula, Boolean> unsatCache = Maps.newHashMap();
    private final LogManager logger;
    public final Timer solverTime = new Timer();
    public int satChecks = 0;
    public int trivialSatChecks = 0;
    public int cachedSatChecks = 0;

    @VisibleForTesting
    public Solver(FormulaManagerView pFmgr, FormulaManagerFactory pFactory, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.fmgr = pFmgr;
        this.bfmgr = this.fmgr.getBooleanFormulaManager();
        this.logger = pLogger;
        this.solvingFormulaManager = pFactory.getFormulaManager();
        this.interpolationFormulaManager = pFactory.getFormulaManagerForInterpolation();
    }

    public static Solver create(Configuration config, LogManager logger, ShutdownNotifier shutdownNotifier) throws InvalidConfigurationException {
        FormulaManagerFactory factory = new FormulaManagerFactory(config, logger, shutdownNotifier);
        FormulaManagerView fmgr = new FormulaManagerView(factory, config, logger);
        return new Solver(fmgr, factory, config, logger);
    }

    public FormulaManagerView getFormulaManager() {
        return this.fmgr;
    }

    public ProverEnvironment newProverEnvironment() {
        return this.newProverEnvironment(false, false);
    }

    public ProverEnvironment newProverEnvironmentWithModelGeneration() {
        return this.newProverEnvironment(true, false);
    }

    public ProverEnvironment newProverEnvironmentWithUnsatCoreGeneration() {
        return this.newProverEnvironment(false, true);
    }

    private ProverEnvironment newProverEnvironment(boolean generateModels, boolean generateUnsatCore) {
        ProverEnvironment pe = this.solvingFormulaManager.newProverEnvironment(generateModels, generateUnsatCore);
        if (this.useLogger) {
            return new LoggingProverEnvironment(this.logger, pe);
        }
        return pe;
    }

    public InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation() {
        InterpolatingProverEnvironment<?> ipe = this.interpolationFormulaManager.newProverEnvironmentWithInterpolation(false);
        if (this.solvingFormulaManager != this.interpolationFormulaManager) {
            ipe = new SeparateInterpolatingProverEnvironment(this.solvingFormulaManager, this.interpolationFormulaManager, ipe);
        }
        if (this.useLogger) {
            return new LoggingInterpolatingProverEnvironment(this.logger, ipe);
        }
        return ipe;
    }

    public OptEnvironment newOptEnvironment() {
        OptEnvironment environment = this.solvingFormulaManager.newOptEnvironment();
        environment = new OptEnvironmentView(environment, this.fmgr);
        if (this.useLogger) {
            return new LoggingOptEnvironment(this.logger, environment);
        }
        return environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnsat(BooleanFormula f) throws SolverException, InterruptedException {
        ++this.satChecks;
        if (this.bfmgr.isTrue(f)) {
            ++this.trivialSatChecks;
            return false;
        }
        if (this.bfmgr.isFalse(f)) {
            ++this.trivialSatChecks;
            return true;
        }
        Boolean result = this.unsatCache.get(f);
        if (result != null) {
            ++this.cachedSatChecks;
            return result;
        }
        this.solverTime.start();
        try {
            result = this.isUnsatUncached(f);
            this.unsatCache.put(f, result);
            boolean bl = result;
            return bl;
        }
        finally {
            this.solverTime.stop();
        }
    }

    private boolean isUnsatUncached(BooleanFormula f) throws SolverException, InterruptedException {
        try (ProverEnvironment prover = this.newProverEnvironment();){
            prover.push(f);
            boolean bl = prover.isUnsat();
            return bl;
        }
    }

    public boolean implies(BooleanFormula a, BooleanFormula b) throws SolverException, InterruptedException {
        if (this.bfmgr.isFalse(a) || this.bfmgr.isTrue(b)) {
            ++this.satChecks;
            ++this.trivialSatChecks;
            return true;
        }
        if (a.equals(b)) {
            ++this.satChecks;
            ++this.trivialSatChecks;
            return true;
        }
        BooleanFormula f = this.bfmgr.not(this.bfmgr.implication(a, b));
        return this.isUnsat(f);
    }

    @Override
    public void close() throws Exception {
        Throwable t = null;
        try {
            if (this.solvingFormulaManager instanceof AutoCloseable) {
                ((AutoCloseable)((Object)this.solvingFormulaManager)).close();
            }
        }
        catch (Throwable t1) {
            t = t1;
            throw t1;
        }
        finally {
            if (this.solvingFormulaManager != this.interpolationFormulaManager && this.interpolationFormulaManager instanceof AutoCloseable) {
                if (t != null) {
                    try {
                        ((AutoCloseable)((Object)this.interpolationFormulaManager)).close();
                    }
                    catch (Throwable t2) {
                        t.addSuppressed(t2);
                    }
                } else {
                    ((AutoCloseable)((Object)this.interpolationFormulaManager)).close();
                }
            }
        }
    }

    public void addUnsatisfiableFormulaToCache(BooleanFormula unsat) {
        if (this.unsatCache.containsKey(unsat) || this.bfmgr.isFalse(unsat)) {
            return;
        }
        try {
            assert (this.isUnsatUncached(unsat)) : "formula is sat: " + unsat;
        }
        catch (SolverException e) {
            throw new AssertionError((Object)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.unsatCache.put(unsat, true);
    }

    public SmtAstMatcher getSmtAstMatcher() {
        return this.solvingFormulaManager.getSmtAstMatcher();
    }
}

