/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.UninterpretedFunctionDeclaration;
import org.sosy_lab.cpachecker.util.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverBasicTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public FormulaManagerFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static FormulaManagerFactory.Solvers[] getAllSolvers() {
        return FormulaManagerFactory.Solvers.values();
    }

    @Override
    protected FormulaManagerFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void formulaEqualsAndHashCode() {
        UninterpretedFunctionDeclaration<NumeralFormula.IntegerFormula> f_b = this.fmgr.declareUninterpretedFunction("f_b", FormulaType.IntegerType, FormulaType.IntegerType);
        new EqualsTester().addEqualityGroup(new Object[]{this.bmgr.makeBoolean(true)}).addEqualityGroup(new Object[]{this.bmgr.makeBoolean(false)}).addEqualityGroup(new Object[]{this.bmgr.makeVariable("bool_a")}).addEqualityGroup(new Object[]{this.imgr.makeVariable("int_a")}).addEqualityGroup(new Object[]{this.imgr.makeNumber(0.0), this.imgr.makeNumber(0L), this.imgr.makeNumber(BigInteger.ZERO), this.imgr.makeNumber(BigDecimal.ZERO), this.imgr.makeNumber("0")}).addEqualityGroup(new Object[]{this.imgr.makeNumber(1.0), this.imgr.makeNumber(1L), this.imgr.makeNumber(BigInteger.ONE), this.imgr.makeNumber(BigDecimal.ONE), this.imgr.makeNumber("1")}).addEqualityGroup(new Object[]{this.bmgr.makeVariable("bool_b"), this.bmgr.makeVariable("bool_b")}).addEqualityGroup(new Object[]{this.bmgr.and(this.bmgr.makeVariable("bool_a"), this.bmgr.makeVariable("bool_b")), this.bmgr.and(this.bmgr.makeVariable("bool_a"), this.bmgr.makeVariable("bool_b"))}).addEqualityGroup(new Object[]{this.imgr.equal(this.imgr.makeNumber(0L), this.imgr.makeVariable("int_a")), this.imgr.equal(this.imgr.makeNumber(0L), this.imgr.makeVariable("int_a"))}).addEqualityGroup(new Object[]{this.fmgr.declareUninterpretedFunction("f_a", FormulaType.IntegerType, FormulaType.IntegerType), this.fmgr.declareUninterpretedFunction("f_a", FormulaType.IntegerType, FormulaType.IntegerType)}).addEqualityGroup(new Object[]{f_b}).addEqualityGroup(new Object[]{this.fmgr.callUninterpretedFunction(f_b, (List<? extends Formula>)ImmutableList.of(this.imgr.makeNumber(0L)))}).addEqualityGroup(new Object[]{this.fmgr.callUninterpretedFunction(f_b, (List<? extends Formula>)ImmutableList.of(this.imgr.makeNumber(1L))), this.fmgr.callUninterpretedFunction(f_b, (List<? extends Formula>)ImmutableList.of(this.imgr.makeNumber(1L)))}).testEquals();
    }
}

