/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.UniqueIdGenerator;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BasicProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.InterpolatingProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.test.ProverEnvironmentSubject;
import org.sosy_lab.cpachecker.util.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverInterpolationTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public FormulaManagerFactory.Solvers solver;
    @Parameterized.Parameter(value=1)
    public boolean shared;
    private static final UniqueIdGenerator index = new UniqueIdGenerator();

    @Parameterized.Parameters(name="{0} (shared={1})")
    public static List<Object[]> getAllCombinations() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (FormulaManagerFactory.Solvers solver : FormulaManagerFactory.Solvers.values()) {
            result.add(new Object[]{solver, false});
            result.add(new Object[]{solver, true});
        }
        return result;
    }

    @Override
    protected FormulaManagerFactory.Solvers solverToUse() {
        return this.solver;
    }

    private <T> InterpolatingProverEnvironment<T> newEnvironmentForTest() {
        return this.mgr.newProverEnvironmentWithInterpolation(this.shared);
    }

    @Test
    public <T> void binaryInterpolation() throws SolverException, InterruptedException {
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b" + i);
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, b);
        BooleanFormula C = this.imgr.equal(b, c);
        BooleanFormula D = this.imgr.equal(c, zero);
        T TA = stack.push(A);
        T TB = stack.push(B);
        T TC = stack.push(C);
        stack.push(D);
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverInterpolationTest.ProverEnvironment()).that(stack)).isUnsatisfiable();
        BooleanFormula itpA = stack.getInterpolant(Lists.newArrayList((Object[])new Object[]{TA}));
        BooleanFormula itpB = stack.getInterpolant(Lists.newArrayList((Object[])new Object[]{TA, TB}));
        BooleanFormula itpC = stack.getInterpolant(Lists.newArrayList((Object[])new Object[]{TA, TB, TC}));
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkItpSequence(stack, Lists.newArrayList((Object[])new BooleanFormula[]{A, B, C, D}), Lists.newArrayList((Object[])new BooleanFormula[]{itpA, itpB, itpC}));
    }

    private void requireSequentialItp() {
        TruthJUnit.assume().withFailureMessage("Solver does not support sequential interpolation.").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)FormulaManagerFactory.Solvers.MATHSAT5);
    }

    @Test
    public <T> void sequentialInterpolation() throws SolverException, InterruptedException {
        this.requireSequentialItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b" + i);
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, b);
        BooleanFormula C = this.imgr.equal(b, c);
        BooleanFormula D = this.imgr.equal(c, zero);
        HashSet TA = Sets.newHashSet((Object[])new Object[]{stack.push(A)});
        HashSet TB = Sets.newHashSet((Object[])new Object[]{stack.push(B)});
        HashSet TC = Sets.newHashSet((Object[])new Object[]{stack.push(C)});
        HashSet TD = Sets.newHashSet((Object[])new Object[]{stack.push(D)});
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverInterpolationTest.ProverEnvironment()).that(stack)).isUnsatisfiable();
        List<BooleanFormula> itps = stack.getSeqInterpolants(Lists.newArrayList((Object[])new Set[]{TA, TB, TC, TD}));
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkItpSequence(stack, Lists.newArrayList((Object[])new BooleanFormula[]{A, B, C, D}), itps);
    }

    private void checkItpSequence(InterpolatingProverEnvironment<?> stack, List<BooleanFormula> formulas, List<BooleanFormula> itps) throws SolverException, InterruptedException {
        assert (formulas.size() - 1 == itps.size()) : "there should be N-1 interpolants for N formulas";
        this.checkImplies(stack, formulas.get(0), itps.get(0));
        for (int i = 1; i < formulas.size() - 1; ++i) {
            this.checkImplies(stack, this.bmgr.and(itps.get(i - 1), formulas.get(i)), itps.get(i));
        }
        this.checkImplies(stack, this.bmgr.and((BooleanFormula)Iterables.getLast(itps), (BooleanFormula)Iterables.getLast(formulas)), this.bmgr.makeBoolean(false));
    }

    private void checkImplies(BasicProverEnvironment<?> stack, BooleanFormula a, BooleanFormula b) throws SolverException, InterruptedException {
        stack.push(this.bmgr.or(this.bmgr.not(a), b));
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverInterpolationTest.ProverEnvironment()).that(stack)).isSatisfiable();
        stack.pop();
    }
}

