/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.ArrayFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.QuantifiedFormulaManagerView;
import org.sosy_lab.cpachecker.util.test.BooleanFormulaSubject;
import org.sosy_lab.cpachecker.util.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverQuantifierTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public FormulaManagerFactory.Solvers solverUnderTest;
    private Solver solver;
    private FormulaManagerView mgrv;
    private ArrayFormulaManagerView afm;
    private BooleanFormulaManagerView bfm;
    private QuantifiedFormulaManagerView qfm;
    private NumeralFormulaManagerView<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> ifm;
    private NumeralFormula.IntegerFormula _x;
    private ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> _b;
    private BooleanFormula _b_at_x_eq_1;
    private BooleanFormula _b_at_x_eq_0;
    private BooleanFormula _forall_x_bx_1;
    private BooleanFormula _forall_x_bx_0;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return FormulaManagerFactory.Solvers.values();
    }

    @Override
    protected FormulaManagerFactory.Solvers solverToUse() {
        return this.solverUnderTest;
    }

    @Before
    public void setUp() throws Exception {
        this.requireArrays();
        this.requireQuantifiers();
        this.mgrv = new FormulaManagerView(this.factory, this.config, TestLogManager.getInstance());
        this.solver = new Solver(this.mgrv, this.factory, this.config, TestLogManager.getInstance());
        this.afm = this.mgrv.getArrayFormulaManager();
        this.bfm = this.mgrv.getBooleanFormulaManager();
        this.ifm = this.mgrv.getIntegerFormulaManager();
        this.qfm = this.mgrv.getQuantifiedFormulaManager();
        this._x = this.ifm.makeVariable("x");
        this._b = this.afm.makeArray("b", FormulaType.IntegerType, FormulaType.IntegerType);
        this._b_at_x_eq_1 = this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._x)), this.ifm.makeNumber(1L));
        this._b_at_x_eq_0 = this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this._x)), this.ifm.makeNumber(0L));
        this._forall_x_bx_1 = this.qfm.forall(this._x, this._b_at_x_eq_1);
        this._forall_x_bx_0 = this.qfm.forall(this._x, this._b_at_x_eq_0);
    }

    @Test
    public void testForallArrayConjunct() throws SolverException, InterruptedException {
        BooleanFormula f = this.bfm.and(this.qfm.forall(this._x, this._b_at_x_eq_0), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(123L))), this.ifm.makeNumber(1L)));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isTrue();
        f = this.bfm.and(this.qfm.forall(this._x, this._b_at_x_eq_0), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(123L))), this.ifm.makeNumber(0L)));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
    }

    @Test
    public void testForallArrayDisjunct() throws SolverException, InterruptedException {
        BooleanFormula f = this.bfm.and(this.qfm.forall(this._x, this._b_at_x_eq_0), this.bfm.or(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(123L))), this.ifm.makeNumber(1L)), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(123L))), this.ifm.makeNumber(0L))));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
        f = this.bfm.or(this.qfm.forall(this._x, this._b_at_x_eq_0), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(123L))), this.ifm.makeNumber(1L)));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
    }

    @Test
    public void testNotExistsArrayConjunct() throws SolverException, InterruptedException {
        BooleanFormula f = this.bfm.and(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.qfm.exists(this._x, this.bfm.not(this._b_at_x_eq_0))), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(123L))), this.ifm.makeNumber(1L))}));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isTrue();
        f = this.bfm.and(this.bfm.not(this.qfm.exists(this._x, this.bfm.not(this._b_at_x_eq_0))), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(123L))), this.ifm.makeNumber(0L)));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
        f = this.bfm.and(this.bfm.not(this.qfm.exists(this._x, this._b_at_x_eq_0)), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(123L))), this.ifm.makeNumber(0L)));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isTrue();
    }

    @Test
    public void testNotExistsArrayDisjunct() throws SolverException, InterruptedException {
        BooleanFormula f = this.bfm.and(this.bfm.not(this.qfm.exists(this._x, this.bfm.not(this._b_at_x_eq_0))), this.bfm.or(this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(123L))), this.ifm.makeNumber(1L)), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(123L))), this.ifm.makeNumber(0L))));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
        f = this.bfm.or(Lists.newArrayList((Object[])new BooleanFormula[]{this.bfm.not(this.qfm.exists(this._x, this.bfm.not(this._b_at_x_eq_0))), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(123L))), this.ifm.makeNumber(1L))}));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
    }

    @Test
    public void testExistsArrayConjunct() throws SolverException, InterruptedException {
        BooleanFormula f = this.bfm.and(this.qfm.exists(this._x, this._b_at_x_eq_0), this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(123L))), this.ifm.makeNumber(1L)));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
        f = this.bfm.and(this.qfm.exists(this._x, this._b_at_x_eq_1), this._forall_x_bx_0);
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isTrue();
        f = this.bfm.and(this.qfm.exists(this._x, this._b_at_x_eq_0), this._forall_x_bx_0);
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
    }

    @Test
    public void testExistsArrayDisjunct() throws SolverException, InterruptedException {
        BooleanFormula f = this.bfm.or(this.qfm.exists(this._x, this._b_at_x_eq_0), this.qfm.forall(this._x, this._b_at_x_eq_1));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
        f = this.bfm.or(this.qfm.exists(this._x, this._b_at_x_eq_1), this.qfm.exists(this._x, this._b_at_x_eq_1));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
    }

    @Test
    public void testExistsRestrictedRange() throws SolverException, InterruptedException {
        BooleanFormula _exists_10_20_bx_0 = this.qfm.exists(this._x, this.ifm.makeNumber(10L), this.ifm.makeNumber(20L), this._b_at_x_eq_0);
        BooleanFormula _exists_10_20_bx_1 = this.qfm.exists(this._x, this.ifm.makeNumber(10L), this.ifm.makeNumber(20L), this._b_at_x_eq_1);
        BooleanFormula f = this.bfm.and(_exists_10_20_bx_0, this._forall_x_bx_0);
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
        f = this.bfm.and(_exists_10_20_bx_1, this._forall_x_bx_0);
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isTrue();
        f = this.bfm.and(_exists_10_20_bx_1, this._forall_x_bx_1);
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
        f = this.bfm.and(_exists_10_20_bx_1, this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(10L))), this.ifm.makeNumber(0L)));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
        f = this.bfm.and(_exists_10_20_bx_1, this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(1000L))), this.ifm.makeNumber(0L)));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
    }

    @Test
    public void testForallRestrictedRange() throws SolverException, InterruptedException {
        BooleanFormula _forall_10_20_bx_0 = this.qfm.forall(this._x, this.ifm.makeNumber(10L), this.ifm.makeNumber(20L), this._b_at_x_eq_0);
        BooleanFormula _forall_10_20_bx_1 = this.qfm.forall(this._x, this.ifm.makeNumber(10L), this.ifm.makeNumber(20L), this._b_at_x_eq_1);
        BooleanFormula f = this.bfm.and(_forall_10_20_bx_0, this.qfm.forall(this._x, this._b_at_x_eq_0));
        ((BooleanFormulaSubject)Truth.assert_().about(this.BooleanFormula()).that((Object)f)).isSatisfiable();
        f = this.bfm.and(_forall_10_20_bx_1, this.qfm.exists(this._x, this.ifm.makeNumber(15L), this.ifm.makeNumber(17L), this._b_at_x_eq_0));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isTrue();
        f = this.bfm.and(_forall_10_20_bx_1, this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(10L))), this.ifm.makeNumber(0L)));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isTrue();
        f = this.bfm.and(_forall_10_20_bx_1, this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(20L))), this.ifm.makeNumber(0L)));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isTrue();
        f = this.bfm.and(_forall_10_20_bx_1, this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(9L))), this.ifm.makeNumber(0L)));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
        f = this.bfm.and(_forall_10_20_bx_1, this.ifm.equal((NumeralFormula.IntegerFormula)((NumeralFormula)this.afm.select(this._b, this.ifm.makeNumber(21L))), this.ifm.makeNumber(0L)));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
        f = this.bfm.and(_forall_10_20_bx_1, this.qfm.forall(this._x, this.ifm.makeNumber(0L), this.ifm.makeNumber(20L), this._b_at_x_eq_0));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isTrue();
        f = this.bfm.and(_forall_10_20_bx_1, this.qfm.forall(this._x, this.ifm.makeNumber(0L), this.ifm.makeNumber(9L), this._b_at_x_eq_0));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
    }

    @Test
    public void testContradiction() throws SolverException, InterruptedException {
        BooleanFormula f = this.qfm.forall(this._x, this.ifm.equal(this._x, this.ifm.add(this._x, this.ifm.makeNumber(1L))));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isTrue();
        BooleanFormula g = this.qfm.exists(this._x, this.ifm.equal(this._x, this.ifm.add(this._x, this.ifm.makeNumber(1L))));
        Truth.assertThat((Boolean)this.solver.isUnsat(g)).isTrue();
    }

    @Test
    public void testSimple() throws SolverException, InterruptedException {
        BooleanFormula f = this.qfm.forall(this._x, this.ifm.equal(this.ifm.add(this._x, this.ifm.makeNumber(2L)), this.ifm.add(this.ifm.add(this._x, this.ifm.makeNumber(1L)), this.ifm.makeNumber(1L))));
        Truth.assertThat((Boolean)this.solver.isUnsat(f)).isFalse();
    }

    @Test
    public void testEquals() {
        BooleanFormula f1 = this.qfm.exists(this.ifm.makeVariable("x"), this.ifm.makeNumber(1L), this.ifm.makeNumber(2L), this._b_at_x_eq_1);
        BooleanFormula f2 = this.qfm.exists(this.ifm.makeVariable("x"), this.ifm.makeNumber(1L), this.ifm.makeNumber(2L), this._b_at_x_eq_1);
        Truth.assertThat((Object)f1).isEqualTo((Object)f2);
    }
}

