/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.UniqueIdGenerator;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BasicProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.UninterpretedFunctionDeclaration;
import org.sosy_lab.cpachecker.util.test.BooleanFormulaSubject;
import org.sosy_lab.cpachecker.util.test.ProverEnvironmentSubject;
import org.sosy_lab.cpachecker.util.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverStackTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public FormulaManagerFactory.Solvers solver;
    @Parameterized.Parameter(value=1)
    public boolean useInterpolatingEnvironment;
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final UniqueIdGenerator index = new UniqueIdGenerator();

    @Parameterized.Parameters(name="{0} (interpolation={1}}")
    public static List<Object[]> getAllCombinations() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (FormulaManagerFactory.Solvers solver : FormulaManagerFactory.Solvers.values()) {
            result.add(new Object[]{solver, false});
            result.add(new Object[]{solver, true});
        }
        return result;
    }

    @Override
    protected FormulaManagerFactory.Solvers solverToUse() {
        return this.solver;
    }

    private BasicProverEnvironment<?> newEnvironmentForTest(boolean generateUnsatCore) {
        if (this.useInterpolatingEnvironment) {
            return this.mgr.newProverEnvironmentWithInterpolation(false);
        }
        return this.mgr.newProverEnvironment(true, generateUnsatCore);
    }

    private void requireMultipleStackSupport() {
        TruthJUnit.assume().withFailureMessage("Solver does not support multiple stacks yet").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)FormulaManagerFactory.Solvers.SMTINTERPOL);
    }

    protected final void requireUfValuesInModel() {
        TruthJUnit.assume().withFailureMessage("Integration of solver does not support retrieving values for UFs from a model").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)FormulaManagerFactory.Solvers.Z3);
    }

    @Test
    public void simpleStackTestBool() throws SolverException, InterruptedException {
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(true);
        int i = index.getFreshId();
        BooleanFormula a = this.bmgr.makeVariable("bool_a" + i);
        BooleanFormula b = this.bmgr.makeVariable("bool_b" + i);
        BooleanFormula or = this.bmgr.or(a, b);
        stack.push(or);
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
        BooleanFormula c = this.bmgr.makeVariable("bool_c" + i);
        BooleanFormula d = this.bmgr.makeVariable("bool_d" + i);
        BooleanFormula and = this.bmgr.and(c, d);
        stack.push(and);
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
        BooleanFormula notOr = this.bmgr.not(or);
        stack.push(notOr);
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isUnsatisfiable();
        stack.pop();
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
        stack.pop();
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
        stack.push(and);
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
        stack.pop();
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
        stack.push(notOr);
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isUnsatisfiable();
        stack.pop();
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
        stack.pop();
    }

    @Test
    public void singleStackTestInteger() throws Exception {
        BasicProverEnvironment<?> env = this.newEnvironmentForTest(true);
        this.simpleStackTestNum(this.imgr, env);
    }

    @Test
    public void singleStackTestRational() throws Exception {
        this.requireRationals();
        BasicProverEnvironment<?> env = this.newEnvironmentForTest(true);
        this.simpleStackTestNum(this.rmgr, env);
    }

    private <X extends NumeralFormula, Y extends X> void simpleStackTestNum(NumeralFormulaManager<X, Y> nmgr, BasicProverEnvironment<?> stack) throws Exception {
        int i = index.getFreshId();
        Y a = nmgr.makeVariable("num_a" + i);
        Y b = nmgr.makeVariable("num_b" + i);
        BooleanFormula leqAB = nmgr.lessOrEquals(a, b);
        stack.push(leqAB);
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
        Y c = nmgr.makeVariable("num_c" + i);
        Y d = nmgr.makeVariable("num_d" + i);
        BooleanFormula eqCD = nmgr.lessOrEquals(c, d);
        stack.push(eqCD);
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
        BooleanFormula gtAB = nmgr.greaterThan(a, b);
        stack.push(gtAB);
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isUnsatisfiable();
        stack.pop();
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
        stack.pop();
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
        stack.push(eqCD);
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
        stack.pop();
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
        stack.push(gtAB);
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isUnsatisfiable();
        stack.pop();
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
        stack.pop();
    }

    @Test
    public void stackTest() throws Exception {
        BasicProverEnvironment<?> stack = this.newEnvironmentForTest(true);
        this.thrown.expect(RuntimeException.class);
        stack.pop();
    }

    @Test
    public void dualStackTest() throws Exception {
        this.requireMultipleStackSupport();
        BooleanFormula a = this.bmgr.makeVariable("bool_a");
        BooleanFormula not = this.bmgr.not(a);
        BasicProverEnvironment<?> stack1 = this.newEnvironmentForTest(true);
        stack1.push(a);
        stack1.push(a);
        BasicProverEnvironment<?> stack2 = this.newEnvironmentForTest(true);
        stack1.pop();
        stack1.pop();
        stack1.push(a);
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack1)).isSatisfiable();
        stack2.push(not);
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack2)).isSatisfiable();
        stack1.pop();
        stack2.pop();
    }

    @Test
    public void dualStackTest2() throws Exception {
        this.requireMultipleStackSupport();
        BooleanFormula a = this.bmgr.makeVariable("bool_a");
        BooleanFormula not = this.bmgr.not(a);
        BasicProverEnvironment<?> stack1 = this.newEnvironmentForTest(true);
        BasicProverEnvironment<?> stack2 = this.newEnvironmentForTest(true);
        stack1.push(a);
        stack1.push(this.bmgr.makeBoolean(true));
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack1)).isSatisfiable();
        stack2.push(not);
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack2)).isSatisfiable();
        stack1.pop();
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack1)).isSatisfiable();
        stack1.pop();
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack1)).isSatisfiable();
        stack2.pop();
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack2)).isSatisfiable();
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack1)).isSatisfiable();
    }

    @Test
    public void dualStackGlobalDeclarations() throws Exception {
        this.requireMultipleStackSupport();
        BasicProverEnvironment<?> stack1 = this.newEnvironmentForTest(true);
        stack1.push(this.bmgr.makeVariable("bool_a"));
        String varName = "bool_b";
        BooleanFormula b = this.bmgr.makeVariable("bool_b");
        stack1.push(b);
        ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack1)).isSatisfiable();
        stack1.pop();
        stack1.pop();
        stack1.close();
        ((BooleanFormulaSubject)Truth.assert_().about(this.BooleanFormula()).that((Object)b)).isEquivalentTo(this.bmgr.makeVariable("bool_b"));
    }

    @Test
    public void modelForUnsatFormula() throws Exception {
        try (BasicProverEnvironment<?> stack = this.newEnvironmentForTest(true);){
            stack.push(this.imgr.greaterThan(this.imgr.makeVariable("a"), this.imgr.makeNumber(0L)));
            stack.push(this.imgr.lessThan(this.imgr.makeVariable("a"), this.imgr.makeNumber(0L)));
            ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isUnsatisfiable();
            this.thrown.expect(Exception.class);
            stack.getModel();
        }
    }

    @Test
    public void modelForSatFormula() throws Exception {
        try (BasicProverEnvironment<?> stack = this.newEnvironmentForTest(false);){
            stack.push(this.imgr.greaterThan(this.imgr.makeVariable("a"), this.imgr.makeNumber(0L)));
            stack.push(this.imgr.lessThan(this.imgr.makeVariable("a"), this.imgr.makeNumber(2L)));
            ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
            Model model = stack.getModel();
            Model.Constant expectedVar = new Model.Constant("a", Model.TermType.Integer);
            Truth.assertThat((Collection)model.keySet()).containsExactly(new Object[]{expectedVar});
            Truth.assertThat((Map)((Object)model)).containsEntry((Object)expectedVar, (Object)BigInteger.ONE);
        }
    }

    @Test
    public void modelForSatFormulaWithLargeValue() throws Exception {
        try (BasicProverEnvironment<?> stack = this.newEnvironmentForTest(false);){
            BigInteger val = BigInteger.TEN.pow(1000);
            stack.push(this.imgr.equal(this.imgr.makeVariable("a"), this.imgr.makeNumber(val)));
            ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
            Model model = stack.getModel();
            Model.Constant expectedVar = new Model.Constant("a", Model.TermType.Integer);
            Truth.assertThat((Collection)model.keySet()).containsExactly(new Object[]{expectedVar});
            Truth.assertThat((Map)((Object)model)).containsEntry((Object)expectedVar, (Object)val);
        }
    }

    @Test
    public void modelForSatFormulaWithUF() throws Exception {
        try (BasicProverEnvironment<?> stack = this.newEnvironmentForTest(false);){
            NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
            NumeralFormula.IntegerFormula varA = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
            NumeralFormula.IntegerFormula varB = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b");
            stack.push(this.imgr.equal(varA, zero));
            stack.push(this.imgr.equal(varB, zero));
            UninterpretedFunctionDeclaration<NumeralFormula.IntegerFormula> uf = this.fmgr.declareUninterpretedFunction("uf", FormulaType.IntegerType, FormulaType.IntegerType);
            stack.push(this.imgr.equal((NumeralFormula)this.fmgr.callUninterpretedFunction(uf, (List<? extends Formula>)ImmutableList.of((Object)varA)), zero));
            stack.push(this.imgr.equal((NumeralFormula)this.fmgr.callUninterpretedFunction(uf, (List<? extends Formula>)ImmutableList.of((Object)varB)), zero));
            ((ProverEnvironmentSubject)Truth.assert_().about(SolverStackTest.ProverEnvironment()).that(stack)).isSatisfiable();
            Model model = stack.getModel();
            Model.Constant expectedVarA = new Model.Constant("a", Model.TermType.Integer);
            Model.Constant expectedVarB = new Model.Constant("b", Model.TermType.Integer);
            Truth.assertThat((Collection)model.keySet()).containsAllOf((Object)expectedVarA, (Object)expectedVarB, new Object[0]);
            Truth.assertThat((Map)((Object)model)).containsEntry((Object)expectedVarA, (Object)BigInteger.ZERO);
            Truth.assertThat((Map)((Object)model)).containsEntry((Object)expectedVarB, (Object)BigInteger.ZERO);
            this.requireUfValuesInModel();
            Model.Function expectedFunc = new Model.Function("uf", Model.TermType.Integer, new Object[]{BigInteger.ZERO});
            Truth.assertThat((Collection)model.keySet()).containsExactly(new Object[]{expectedVarA, expectedVarB, expectedFunc});
            Truth.assertThat((Map)((Object)model)).containsEntry((Object)expectedFunc, (Object)BigInteger.ZERO);
        }
    }
}

