/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates;

import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BitvectorFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.test.BooleanFormulaSubject;
import org.sosy_lab.cpachecker.util.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverTheoriesTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public FormulaManagerFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return FormulaManagerFactory.Solvers.values();
    }

    @Override
    protected FormulaManagerFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void intTest1() throws Exception {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_a");
        NumeralFormula.IntegerFormula num = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
        BooleanFormula f = this.imgr.equal(this.imgr.add(a, a), num);
        ((BooleanFormulaSubject)Truth.assert_().about(this.BooleanFormula()).that((Object)f)).isSatisfiable();
    }

    @Test
    public void intTest2() throws Exception {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("int_b");
        NumeralFormula.IntegerFormula num = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        BooleanFormula f = this.imgr.equal(this.imgr.add(a, a), num);
        ((BooleanFormulaSubject)Truth.assert_().about(this.BooleanFormula()).that((Object)f)).isUnsatisfiable();
    }

    @Test
    public void realTest() throws Exception {
        this.requireRationals();
        NumeralFormula.RationalFormula a = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("int_c");
        NumeralFormula.RationalFormula num = (NumeralFormula.RationalFormula)this.rmgr.makeNumber(1L);
        BooleanFormula f = this.rmgr.equal(this.rmgr.add(a, a), num);
        ((BooleanFormulaSubject)Truth.assert_().about(this.BooleanFormula()).that((Object)f)).isSatisfiable();
    }

    @Test
    public void quantifierEliminationTest1() throws Exception {
        this.requireQuantifiers();
        NumeralFormula.IntegerFormula var_B = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b");
        NumeralFormula.IntegerFormula var_C = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c");
        NumeralFormula.IntegerFormula num_2 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L);
        NumeralFormula.IntegerFormula num_1000 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1000L);
        BooleanFormula eq_c_2 = this.imgr.equal(var_C, num_2);
        NumeralFormula.IntegerFormula minus_b_c = (NumeralFormula.IntegerFormula)this.imgr.subtract(var_B, var_C);
        BooleanFormula gt_bMinusC_1000 = this.imgr.greaterThan(minus_b_c, num_1000);
        BooleanFormula and_cEq2_bMinusCgt1000 = this.bmgr.and(eq_c_2, gt_bMinusC_1000);
        BooleanFormula f = this.qmgr.exists(Lists.newArrayList((Object[])new Formula[]{var_C}), and_cEq2_bMinusCgt1000);
        BooleanFormula result = this.qmgr.eliminateQuantifiers(f);
        Truth.assertThat((String)result.toString()).doesNotContain((CharSequence)"exists");
        Truth.assertThat((String)result.toString()).doesNotContain((CharSequence)"c");
        BooleanFormula expected = this.imgr.greaterOrEquals(var_B, this.imgr.makeNumber(1003L));
        ((BooleanFormulaSubject)Truth.assert_().about(this.BooleanFormula()).that((Object)result)).isEquivalentTo(expected);
    }

    @Test
    @Ignore
    public void quantifierEliminationTest2() throws Exception {
        this.requireQuantifiers();
        NumeralFormula.IntegerFormula i1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("i@1");
        NumeralFormula.IntegerFormula j1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("j@1");
        NumeralFormula.IntegerFormula j2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("j@2");
        NumeralFormula.IntegerFormula a1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a@1");
        NumeralFormula.IntegerFormula _1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula _minus1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(-1L);
        NumeralFormula.IntegerFormula _1_plus_a1 = (NumeralFormula.IntegerFormula)this.imgr.add(_1, a1);
        BooleanFormula not_j1_eq_minus1 = this.bmgr.not(this.imgr.equal(j1, _minus1));
        BooleanFormula i1_eq_1_plus_a1 = this.imgr.equal(i1, _1_plus_a1);
        NumeralFormula.IntegerFormula j2_plus_a1 = (NumeralFormula.IntegerFormula)this.imgr.add(j2, a1);
        BooleanFormula j1_eq_j2_plus_a1 = this.imgr.equal(j1, j2_plus_a1);
        BooleanFormula fm = this.bmgr.and(Lists.newArrayList((Object[])new BooleanFormula[]{i1_eq_1_plus_a1, not_j1_eq_minus1, j1_eq_j2_plus_a1}));
        BooleanFormula q = this.qmgr.exists(Lists.newArrayList((Object[])new Formula[]{j1}), fm);
        BooleanFormula result = this.qmgr.eliminateQuantifiers(q);
        Truth.assertThat((String)result.toString()).doesNotContain((CharSequence)"exists");
        Truth.assertThat((String)result.toString()).doesNotContain((CharSequence)"j@1");
        BooleanFormula expected = this.bmgr.not(this.imgr.equal(i1, j2));
        ((BooleanFormulaSubject)Truth.assert_().about(this.BooleanFormula()).that((Object)result)).isEquivalentTo(expected);
    }

    @Test
    public void testGetFormulaType() {
        BooleanFormula _boolVar = this.bmgr.makeVariable("boolVar");
        Truth.assertThat(this.mgr.getFormulaType(_boolVar)).isEqualTo(FormulaType.BooleanType);
        NumeralFormula.IntegerFormula _intVar = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        Truth.assertThat(this.mgr.getFormulaType(_intVar)).isEqualTo(FormulaType.IntegerType);
        this.requireArrays();
        ArrayFormula _arrayVar = this.amgr.makeArray("b", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        Truth.assertThat(this.mgr.getFormulaType(_arrayVar)).isInstanceOf(FormulaType.ArrayFormulaType.class);
    }

    @Test
    public void testMakeIntArray() {
        this.requireArrays();
        NumeralFormula.IntegerFormula _i = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("i");
        NumeralFormula.IntegerFormula _1 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula _i_plus_1 = (NumeralFormula.IntegerFormula)this.imgr.add(_i, _1);
        ArrayFormula _b = this.amgr.makeArray("b", FormulaType.NumeralType.IntegerType, FormulaType.NumeralType.IntegerType);
        NumeralFormula.IntegerFormula _b_at_i_plus_1 = (NumeralFormula.IntegerFormula)this.amgr.select(_b, _i_plus_1);
        Truth.assertThat((String)_b_at_i_plus_1.toString()).comparesEqualTo((Comparable)((Object)"(select b (+ i 1))"));
    }

    @Test
    public void testMakeBitVectorArray() {
        this.requireArrays();
        BitvectorFormula _i = this.mgr.getBitvectorFormulaManager().makeVariable(64, "i");
        ArrayFormula _b = this.amgr.makeArray("b", FormulaType.getBitvectorTypeWithSize(64), FormulaType.getBitvectorTypeWithSize(32));
        BitvectorFormula _b_at_i = (BitvectorFormula)this.amgr.select(_b, _i);
        Truth.assertThat((String)_b_at_i.toString()).comparesEqualTo((Comparable)((Object)"(select b i)"));
    }
}

