/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.bdd;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.util.predicates.bdd.JavaBDDRegionManager;
import org.sosy_lab.cpachecker.util.predicates.bdd.SylvanBDDRegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;

@Options(prefix="bdd")
public class BDDManagerFactory {
    @Option(secure=true, name="package", description="Which BDD package should be used?\n- java:   JavaBDD (default, no dependencies, many features)\n- sylvan: Sylvan (only 64bit Linux, uses multiple threads)\n- cudd:   CUDD (native library required, reordering not supported)\n- micro:  MicroFactory (maximum number of BDD variables is 1024, slow, but less memory-comsumption)\n- buddy:  Buddy (native library required)\n- cal:    CAL (native library required)\n- jdd:    JDD", values={"JAVA", "SYLVAN", "CUDD", "MICRO", "BUDDY", "CAL", "JDD"}, toUppercase=true)
    private String bddPackage = "JAVA";
    private final Configuration config;
    private final LogManager logger;

    public BDDManagerFactory(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.config = pConfig;
        this.logger = pLogger;
    }

    public RegionManager createRegionManager() throws InvalidConfigurationException {
        if (this.bddPackage.equals("SYLVAN")) {
            return new SylvanBDDRegionManager(this.config, this.logger);
        }
        return new JavaBDDRegionManager(this.bddPackage, this.config, this.logger);
    }
}

