/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.bdd;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.PrintStream;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.predicates.bdd.JavaBDDRegion;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.RegionManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="bdd.javabdd")
class JavaBDDRegionManager
implements RegionManager {
    private static final Level LOG_LEVEL = Level.FINE;
    @Option(secure=true, description="Initial size of the BDD node table.")
    private int initTableSize = 10000;
    @Option(secure=true, description="Size of the BDD cache if cache ratio is not used.")
    private int cacheSize = 1000;
    @Option(secure=true, description="Size of the BDD cache in relation to the node table size (set to 0 to use fixed BDD cache size).")
    private double cacheRatio = 0.1;
    private final StatInt cleanupQueueSize = new StatInt(StatKind.AVG, "Size of BDD node cleanup queue");
    private final StatTimer cleanupTimer = new StatTimer("Time for BDD node cleanup");
    private final LogManager logger;
    private final BDDFactory factory;
    private final Region trueFormula;
    private final Region falseFormula;
    private int nextvar = 0;
    private int varcount = 100;
    private final ReferenceQueue<JavaBDDRegion> referenceQueue = new ReferenceQueue();
    private final Map<PhantomReference<JavaBDDRegion>, BDD> referenceMap = Maps.newIdentityHashMap();

    JavaBDDRegionManager(String bddPackage, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
        this.factory = BDDFactory.init((String)bddPackage.toLowerCase(), (int)this.initTableSize, (int)this.cacheSize);
        try {
            Method gcCallback = JavaBDDRegionManager.class.getDeclaredMethod("gcCallback", Integer.class, BDDFactory.GCStats.class);
            gcCallback.setAccessible(true);
            this.factory.registerGCCallback((Object)this, gcCallback);
            Method resizeCallback = JavaBDDRegionManager.class.getDeclaredMethod("resizeCallback", Integer.class, Integer.class);
            resizeCallback.setAccessible(true);
            this.factory.registerResizeCallback((Object)this, resizeCallback);
            Method reorderCallback = JavaBDDRegionManager.class.getDeclaredMethod("reorderCallback", Integer.class, BDDFactory.ReorderStats.class);
            reorderCallback.setAccessible(true);
            this.factory.registerReorderCallback((Object)this, reorderCallback);
            if (!this.logger.wouldBeLogged(LOG_LEVEL)) {
                this.factory.unregisterGCCallback((Object)this, gcCallback);
                this.factory.unregisterResizeCallback((Object)this, resizeCallback);
                this.factory.unregisterReorderCallback((Object)this, reorderCallback);
            }
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        this.factory.setVarNum(this.varcount);
        this.factory.setCacheRatio(this.cacheRatio);
        this.trueFormula = new JavaBDDRegion(this.factory.one());
        this.falseFormula = new JavaBDDRegion(this.factory.zero());
    }

    private void gcCallback(Integer pre, BDDFactory.GCStats stats) {
        if (this.logger.wouldBeLogged(LOG_LEVEL)) {
            switch (pre) {
                case 1: {
                    this.logger.log(LOG_LEVEL, new Object[]{"Starting BDD Garbage Collection"});
                    break;
                }
                case 0: {
                    this.logger.log(LOG_LEVEL, new Object[]{"Finished BDD", stats});
                    break;
                }
                default: {
                    this.logger.log(LOG_LEVEL, new Object[]{stats});
                }
            }
        }
    }

    private void resizeCallback(Integer oldSize, Integer newSize) {
        this.logger.log(LOG_LEVEL, new Object[]{"BDD node table resized from", oldSize, "to", newSize});
    }

    private void reorderCallback(Integer pre, BDDFactory.ReorderStats stats) {
        if (this.logger.wouldBeLogged(LOG_LEVEL)) {
            switch (pre) {
                case 1: {
                    this.logger.log(LOG_LEVEL, new Object[]{"Starting BDD Reordering"});
                    break;
                }
                case 0: {
                    this.logger.log(LOG_LEVEL, new Object[]{"Finished BDD Reordering:", stats});
                    break;
                }
                default: {
                    this.logger.log(LOG_LEVEL, new Object[]{stats});
                }
            }
        }
    }

    @Override
    public void printStatistics(PrintStream out) {
        try {
            BDDFactory.GCStats stats = this.factory.getGCStats();
            StatisticsWriter.writingStatisticsTo(out).put("Number of BDD nodes", this.factory.getNodeNum()).put("Size of BDD node table", this.factory.getNodeTableSize()).put(this.cleanupQueueSize).put(this.cleanupTimer).put("Time for BDD garbage collection", TimeSpan.ofMillis((long)stats.sumtime).formatAs(TimeUnit.SECONDS) + " (in " + stats.num + " runs)");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private BDD createNewVar() {
        if (this.nextvar >= this.varcount) {
            this.varcount = (int)((double)this.varcount * 1.5);
            this.factory.setVarNum(this.varcount);
        }
        BDD ret = this.factory.ithVar(this.nextvar++);
        return ret;
    }

    @Override
    public JavaBDDRegion createPredicate() {
        this.cleanupReferences();
        return this.wrap(this.createNewVar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupReferences() {
        this.cleanupTimer.start();
        try {
            PhantomReference ref;
            int count = 0;
            while ((ref = (PhantomReference)this.referenceQueue.poll()) != null) {
                ++count;
                BDD bdd = this.referenceMap.remove(ref);
                assert (bdd != null);
                bdd.free();
            }
            this.cleanupQueueSize.setNextValue(count);
        }
        finally {
            this.cleanupTimer.stop();
        }
    }

    private JavaBDDRegion wrap(BDD bdd) {
        JavaBDDRegion region = new JavaBDDRegion(bdd);
        PhantomReference<JavaBDDRegion> ref = new PhantomReference<JavaBDDRegion>(region, this.referenceQueue);
        this.referenceMap.put(ref, bdd);
        return region;
    }

    private BDD unwrap(Region region) {
        return ((JavaBDDRegion)region).getBDD();
    }

    @Override
    public boolean entails(Region pF1, Region pF2) {
        this.cleanupReferences();
        BDD imp = this.unwrap(pF1).imp(this.unwrap(pF2));
        boolean result = imp.isOne();
        imp.free();
        return result;
    }

    @Override
    public Region makeTrue() {
        this.cleanupReferences();
        return this.trueFormula;
    }

    @Override
    public Region makeFalse() {
        this.cleanupReferences();
        return this.falseFormula;
    }

    @Override
    public Region makeAnd(Region pF1, Region pF2) {
        this.cleanupReferences();
        return this.wrap(this.unwrap(pF1).and(this.unwrap(pF2)));
    }

    @Override
    public Region makeNot(Region pF) {
        this.cleanupReferences();
        return this.wrap(this.unwrap(pF).not());
    }

    @Override
    public Region makeOr(Region pF1, Region pF2) {
        this.cleanupReferences();
        return this.wrap(this.unwrap(pF1).or(this.unwrap(pF2)));
    }

    @Override
    public Region makeEqual(Region pF1, Region pF2) {
        this.cleanupReferences();
        return this.wrap(this.unwrap(pF1).biimp(this.unwrap(pF2)));
    }

    @Override
    public Region makeUnequal(Region pF1, Region pF2) {
        this.cleanupReferences();
        return this.wrap(this.unwrap(pF1).xor(this.unwrap(pF2)));
    }

    @Override
    public Region makeIte(Region pF1, Region pF2, Region pF3) {
        this.cleanupReferences();
        return this.wrap(this.unwrap(pF1).ite(this.unwrap(pF2), this.unwrap(pF3)));
    }

    @Override
    public Triple<Region, Region, Region> getIfThenElse(Region pF) {
        this.cleanupReferences();
        BDD f = this.unwrap(pF);
        JavaBDDRegion predicate = this.wrap(this.factory.ithVar(f.var()));
        JavaBDDRegion fThen = this.wrap(f.high());
        JavaBDDRegion fElse = this.wrap(f.low());
        return Triple.of((Object)predicate, (Object)fThen, (Object)fElse);
    }

    @Override
    public Region makeExists(Region pF1, Region ... pF2) {
        this.cleanupReferences();
        if (pF2.length == 0) {
            return pF1;
        }
        BDD f = this.unwrap(pF2[0]).id();
        for (int i = 1; i < pF2.length; ++i) {
            f.andWith(this.unwrap(pF2[i]).id());
        }
        JavaBDDRegion result = this.wrap(this.unwrap(pF1).exist(f));
        f.free();
        return result;
    }

    @Override
    public Set<Region> extractPredicates(Region pF) {
        this.cleanupReferences();
        BDD f = this.unwrap(pF);
        int[] vars = f.scanSet();
        if (vars == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder predicateBuilder = ImmutableSet.builder();
        for (int var : vars) {
            predicateBuilder.add((Object)this.wrap(this.factory.ithVar(var)));
        }
        return predicateBuilder.build();
    }

    @Override
    public RegionManager.RegionBuilder builder(ShutdownNotifier pShutdownNotifier) {
        return new BDDRegionBuilder(pShutdownNotifier);
    }

    @Override
    public Region fromFormula(BooleanFormula pF, FormulaManagerView fmgr, Function<BooleanFormula, Region> atomToRegion) {
        this.cleanupReferences();
        BooleanFormulaManagerView bfmgr = fmgr.getBooleanFormulaManager();
        if (bfmgr.isFalse(pF)) {
            return this.makeFalse();
        }
        if (bfmgr.isTrue(pF)) {
            return this.makeTrue();
        }
        try (FormulaToRegionConverter converter = new FormulaToRegionConverter(fmgr, atomToRegion);){
            JavaBDDRegion javaBDDRegion = this.wrap((BDD)converter.visit(pF));
            return javaBDDRegion;
        }
    }

    @Override
    public String getVersion() {
        return this.factory.getVersion();
    }

    private class FormulaToRegionConverter
    extends BooleanFormulaManagerView.BooleanFormulaVisitor<BDD>
    implements AutoCloseable {
        private final Function<BooleanFormula, Region> atomToRegion;
        private final Map<BooleanFormula, BDD> cache;

        FormulaToRegionConverter(FormulaManagerView pFmgr, Function<BooleanFormula, Region> pAtomToRegion) {
            super(pFmgr);
            this.cache = new HashMap<BooleanFormula, BDD>();
            this.atomToRegion = pAtomToRegion;
        }

        @Override
        protected BDD visitTrue() {
            return JavaBDDRegionManager.this.factory.one();
        }

        @Override
        protected BDD visitFalse() {
            return JavaBDDRegionManager.this.factory.zero();
        }

        @Override
        public BDD visitAtom(BooleanFormula pAtom) {
            return ((JavaBDDRegion)this.atomToRegion.apply((Object)pAtom)).getBDD().id();
        }

        private BDD convert(BooleanFormula pOperand) {
            BDD operand = this.cache.get(pOperand);
            if (operand == null) {
                operand = (BDD)this.visit(pOperand);
                this.cache.put(pOperand, operand);
            }
            return operand.id();
        }

        @Override
        public void close() {
            for (BDD bdd : this.cache.values()) {
                bdd.free();
            }
            this.cache.clear();
        }

        @Override
        public BDD visitNot(BooleanFormula pOperand) {
            BDD operand = this.convert(pOperand);
            BDD result = operand.not();
            operand.free();
            return result;
        }

        private BDD visitBinary(BooleanFormula pOperand1, BooleanFormula pOperand2, BDDFactory.BDDOp operator) {
            BDD operand1 = this.convert(pOperand1);
            BDD operand2 = this.convert(pOperand2);
            return operand1.applyWith(operand2, operator);
        }

        private BDD visitMulti(BDDFactory.BDDOp operator, BooleanFormula ... pOperands) {
            Preconditions.checkArgument((pOperands.length >= 2 ? 1 : 0) != 0);
            BDD result = this.convert(pOperands[0]);
            for (int i = 1; i < pOperands.length; ++i) {
                result = result.applyWith(this.convert(pOperands[i]), operator);
            }
            return result;
        }

        @Override
        public BDD visitAnd(BooleanFormula ... pOperands) {
            return this.visitMulti(BDDFactory.and, pOperands);
        }

        @Override
        public BDD visitOr(BooleanFormula ... pOperands) {
            return this.visitMulti(BDDFactory.or, pOperands);
        }

        @Override
        public BDD visitEquivalence(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            return this.visitBinary(pOperand1, pOperand2, BDDFactory.biimp);
        }

        @Override
        protected BDD visitImplication(BooleanFormula pOperand1, BooleanFormula pOperand2) {
            return this.visitBinary(pOperand1, pOperand2, BDDFactory.imp);
        }

        @Override
        public BDD visitIfThenElse(BooleanFormula pCondition, BooleanFormula pThenFormula, BooleanFormula pElseFormula) {
            BDD condition = this.convert(pCondition);
            BDD thenBDD = this.convert(pThenFormula);
            BDD elseBDD = this.convert(pElseFormula);
            BDD result = condition.ite(thenBDD, elseBDD);
            condition.free();
            thenBDD.free();
            elseBDD.free();
            return result;
        }
    }

    private class BDDRegionBuilder
    implements RegionManager.RegionBuilder {
        private final ShutdownNotifier shutdownNotifier;
        private BDD currentCube = null;
        private final List<BDD> cubes = new ArrayList<BDD>();

        private BDDRegionBuilder(ShutdownNotifier pShutdownNotifier) {
            this.shutdownNotifier = pShutdownNotifier;
        }

        @Override
        public void startNewConjunction() {
            Preconditions.checkState((this.currentCube == null ? 1 : 0) != 0);
            this.currentCube = JavaBDDRegionManager.this.factory.one();
        }

        @Override
        public void addPositiveRegion(Region r) {
            Preconditions.checkState((this.currentCube != null ? 1 : 0) != 0);
            this.currentCube.andWith(((JavaBDDRegion)r).getBDD().id());
        }

        @Override
        public void addNegativeRegion(Region r) {
            Preconditions.checkState((this.currentCube != null ? 1 : 0) != 0);
            this.currentCube.andWith(((JavaBDDRegion)r).getBDD().not());
        }

        @Override
        public void finishConjunction() {
            Preconditions.checkState((this.currentCube != null ? 1 : 0) != 0);
            for (int i = 0; i < this.cubes.size(); ++i) {
                BDD cubeAtI = this.cubes.get(i);
                if (cubeAtI == null) {
                    this.cubes.set(i, this.currentCube);
                    this.currentCube = null;
                    return;
                }
                this.currentCube.orWith(cubeAtI);
                this.cubes.set(i, null);
            }
            if (this.currentCube != null) {
                this.cubes.add(this.currentCube);
                this.currentCube = null;
            }
        }

        @Override
        public Region getResult() throws InterruptedException {
            Preconditions.checkState((this.currentCube == null ? 1 : 0) != 0);
            if (this.cubes.isEmpty()) {
                return JavaBDDRegionManager.this.falseFormula;
            }
            this.buildBalancedOr();
            return JavaBDDRegionManager.this.wrap(((BDD)Iterables.getOnlyElement(this.cubes)).id());
        }

        private void buildBalancedOr() throws InterruptedException {
            BDD result = JavaBDDRegionManager.this.factory.zero();
            for (BDD cube : this.cubes) {
                if (cube == null) continue;
                this.shutdownNotifier.shutdownIfNecessary();
                result.orWith(cube);
            }
            this.cubes.clear();
            this.cubes.add(result);
            assert (this.cubes.size() == 1);
        }

        @Override
        public void close() {
            Preconditions.checkState((this.currentCube == null ? 1 : 0) != 0);
            for (BDD bdd : this.cubes) {
                bdd.free();
            }
            this.cubes.clear();
        }
    }
}

