/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BitvectorFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FloatingPointFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;

public abstract class FormulaType<T extends Formula> {
    public static final FormulaType<NumeralFormula.RationalFormula> RationalType = new NumeralType<NumeralFormula.RationalFormula>(){

        @Override
        public boolean isRationalType() {
            return true;
        }

        @Override
        public String toString() {
            return "Rational";
        }
    };
    public static final FormulaType<NumeralFormula.IntegerFormula> IntegerType = new NumeralType<NumeralFormula.IntegerFormula>(){

        @Override
        public boolean isIntegerType() {
            return true;
        }

        @Override
        public String toString() {
            return "Integer";
        }
    };
    public static final FormulaType<BooleanFormula> BooleanType = new FormulaType<BooleanFormula>(){

        @Override
        public boolean isBooleanType() {
            return true;
        }

        @Override
        public String toString() {
            return "Boolean";
        }
    };
    private static final FloatingPointType SINGLE_PRECISION_FP_TYPE = new FloatingPointType(8, 23);
    private static final FloatingPointType DOUBLE_PRECISION_FP_TYPE = new FloatingPointType(11, 52);

    private FormulaType() {
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean isBitvectorType() {
        return false;
    }

    public boolean isBooleanType() {
        return false;
    }

    public boolean isFloatingPointType() {
        return false;
    }

    public boolean isNumeralType() {
        return false;
    }

    public boolean isRationalType() {
        return false;
    }

    public boolean isIntegerType() {
        return false;
    }

    public abstract String toString();

    public static BitvectorType getBitvectorTypeWithSize(int size) {
        return BitvectorType.getBitvectorType(size);
    }

    public static FloatingPointType getFloatingPointType(int exponentSize, int mantissaSize) {
        return new FloatingPointType(exponentSize, mantissaSize);
    }

    public static FloatingPointType getSinglePrecisionFloatingPointType() {
        return SINGLE_PRECISION_FP_TYPE;
    }

    public static FloatingPointType getDoublePrecisionFloatingPointType() {
        return DOUBLE_PRECISION_FP_TYPE;
    }

    public static <TD extends Formula, TR extends Formula> ArrayFormulaType<TD, TR> getArrayType(FormulaType<TD> pDomainSort, FormulaType<TR> pRangeSort) {
        return new ArrayFormulaType<TD, TR>(pDomainSort, pRangeSort);
    }

    public static final class FloatingPointType
    extends FormulaType<FloatingPointFormula> {
        private final int exponentSize;
        private final int mantissaSize;

        private FloatingPointType(int pExponentSize, int pMantissaSize) {
            this.exponentSize = pExponentSize;
            this.mantissaSize = pMantissaSize;
        }

        @Override
        public boolean isFloatingPointType() {
            return true;
        }

        public int getExponentSize() {
            return this.exponentSize;
        }

        public int getMantissaSize() {
            return this.mantissaSize;
        }

        public int hashCode() {
            return (31 + this.exponentSize) * 31 + this.mantissaSize;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FloatingPointType)) {
                return false;
            }
            FloatingPointType other = (FloatingPointType)obj;
            return this.exponentSize == other.exponentSize && this.mantissaSize == other.mantissaSize;
        }

        @Override
        public String toString() {
            return "FloatingPoint<exp=" + this.exponentSize + ",mant=" + this.mantissaSize + ">";
        }
    }

    public static final class ArrayFormulaType<TI extends Formula, TE extends Formula>
    extends FormulaType<ArrayFormula<TI, TE>> {
        private final FormulaType<TE> elementType;
        private final FormulaType<TI> indexType;

        public ArrayFormulaType(FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
            this.indexType = (FormulaType)Preconditions.checkNotNull(pIndexType);
            this.elementType = (FormulaType)Preconditions.checkNotNull(pElementType);
        }

        public FormulaType<? extends Formula> getElementType() {
            return this.elementType;
        }

        public FormulaType<? extends Formula> getIndexType() {
            return this.indexType;
        }

        @Override
        public boolean isArrayType() {
            return true;
        }

        @Override
        public String toString() {
            return "Array";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.elementType.hashCode();
            result = 31 * result + this.indexType.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ArrayFormulaType)) {
                return false;
            }
            ArrayFormulaType other = (ArrayFormulaType)obj;
            if (!this.elementType.equals(other.elementType)) {
                return false;
            }
            return this.indexType.equals(other.indexType);
        }
    }

    public static final class BitvectorType
    extends FormulaType<BitvectorFormula> {
        private final int size;
        private static Map<Integer, BitvectorType> table = new HashMap<Integer, BitvectorType>();

        private BitvectorType(int size) {
            this.size = size;
        }

        private static BitvectorType getBitvectorType(int size) {
            int hashValue = size;
            BitvectorType value = table.get(hashValue);
            if (value == null) {
                value = new BitvectorType(size);
                table.put(hashValue, value);
            }
            return value;
        }

        @Override
        public boolean isBitvectorType() {
            return true;
        }

        public int getSize() {
            return this.size;
        }

        public BitvectorType withSize(int size) {
            return BitvectorType.getBitvectorType(size);
        }

        @Override
        public String toString() {
            return "Bitvector<" + this.getSize() + ">";
        }
    }

    public static abstract class NumeralType<T extends NumeralFormula>
    extends FormulaType<T> {
        @Override
        public final boolean isNumeralType() {
            return true;
        }
    }
}

