/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces;

import com.google.common.base.Function;
import java.io.PrintStream;
import java.util.Set;
import org.sosy_lab.common.Triple;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Region;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;

public interface RegionManager {
    public boolean entails(Region var1, Region var2) throws SolverException, InterruptedException;

    public Region makeTrue();

    public Region makeFalse();

    public Region makeNot(Region var1);

    public Region makeAnd(Region var1, Region var2);

    public Region makeOr(Region var1, Region var2);

    public Region makeEqual(Region var1, Region var2);

    public Region makeUnequal(Region var1, Region var2);

    public Region makeIte(Region var1, Region var2, Region var3);

    public Region makeExists(Region var1, Region ... var2);

    public Region createPredicate();

    public Set<Region> extractPredicates(Region var1);

    public Region fromFormula(BooleanFormula var1, FormulaManagerView var2, Function<BooleanFormula, Region> var3);

    public Triple<Region, Region, Region> getIfThenElse(Region var1);

    public void printStatistics(PrintStream var1);

    public String getVersion();

    public RegionBuilder builder(ShutdownNotifier var1);

    public static interface RegionBuilder
    extends AutoCloseable {
        public void startNewConjunction();

        public void addPositiveRegion(Region var1);

        public void addNegativeRegion(Region var1);

        public void finishConjunction();

        public Region getResult() throws InterruptedException;

        @Override
        public void close();
    }
}

