/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;

public abstract class UninterpretedFunctionDeclaration<T extends Formula> {
    private final FormulaType<T> returnType;
    private final List<FormulaType<?>> argumentTypes;

    protected UninterpretedFunctionDeclaration(FormulaType<T> pReturnType, List<FormulaType<?>> pArgumentTypes) {
        this.returnType = (FormulaType)Preconditions.checkNotNull(pReturnType);
        this.argumentTypes = ImmutableList.copyOf(pArgumentTypes);
    }

    public List<FormulaType<?>> getArgumentTypes() {
        return this.argumentTypes;
    }

    public FormulaType<T> getReturnType() {
        return this.returnType;
    }

    public String toString() {
        return "(" + this.returnType.toString() + ") func(" + Joiner.on((char)',').join(this.argumentTypes) + ")";
    }
}

