/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl;

import java.math.BigInteger;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BitvectorFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BitvectorFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.FormulaCreator;

public abstract class AbstractBitvectorFormulaManager<TFormulaInfo, TType, TEnv>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv>
implements BitvectorFormulaManager {
    protected AbstractBitvectorFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv> pCreator) {
        super(pCreator);
    }

    private BitvectorFormula wrap(TFormulaInfo pTerm) {
        return this.getFormulaCreator().encapsulateBitvector(pTerm);
    }

    @Override
    public BitvectorFormula negate(BitvectorFormula pNumber) {
        Object param1 = this.extractInfo(pNumber);
        return this.wrap(this.negate(param1));
    }

    protected abstract TFormulaInfo negate(TFormulaInfo var1);

    @Override
    public BitvectorFormula add(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Can't add bitvectors with different sizes (" + this.getLength(pNumber1) + " and " + this.getLength(pNumber2) + ")";
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrap(this.add(param1, param2));
    }

    protected abstract TFormulaInfo add(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BitvectorFormula subtract(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Can't subtract bitvectors with different sizes (" + this.getLength(pNumber1) + " and " + this.getLength(pNumber2) + ")";
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrap(this.subtract(param1, param2));
    }

    protected abstract TFormulaInfo subtract(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BitvectorFormula divide(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean signed) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Can't divide bitvectors with different sizes (" + this.getLength(pNumber1) + " and " + this.getLength(pNumber2) + ")";
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrap(this.divide(param1, param2, signed));
    }

    protected abstract TFormulaInfo divide(TFormulaInfo var1, TFormulaInfo var2, boolean var3);

    @Override
    public BitvectorFormula modulo(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean signed) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Can't modulo bitvectors with different sizes (" + this.getLength(pNumber1) + " and " + this.getLength(pNumber2) + ")";
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrap(this.modulo(param1, param2, signed));
    }

    protected abstract TFormulaInfo modulo(TFormulaInfo var1, TFormulaInfo var2, boolean var3);

    @Override
    public BooleanFormula modularCongruence(BitvectorFormula pNumber1, BitvectorFormula pNumber2, long pModulo) {
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.modularCongruence(param1, param2, pModulo));
    }

    protected abstract TFormulaInfo modularCongruence(TFormulaInfo var1, TFormulaInfo var2, long var3);

    @Override
    public BitvectorFormula multiply(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Can't multiply bitvectors with different sizes (" + this.getLength(pNumber1) + " and " + this.getLength(pNumber2) + ")";
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrap(this.multiply(param1, param2));
    }

    protected abstract TFormulaInfo multiply(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula equal(BitvectorFormula pNumber1, BitvectorFormula pNumber2) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Can't compare bitvectors with different sizes (" + this.getLength(pNumber1) + " and " + this.getLength(pNumber2) + ")";
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.equal(param1, param2));
    }

    protected abstract TFormulaInfo equal(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula greaterThan(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean signed) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Can't compare bitvectors with different sizes (" + this.getLength(pNumber1) + " and " + this.getLength(pNumber2) + ")";
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.greaterThan(param1, param2, signed));
    }

    protected abstract TFormulaInfo greaterThan(TFormulaInfo var1, TFormulaInfo var2, boolean var3);

    @Override
    public BooleanFormula greaterOrEquals(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean signed) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Can't compare bitvectors with different sizes (" + this.getLength(pNumber1) + " and " + this.getLength(pNumber2) + ")";
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.greaterOrEquals(param1, param2, signed));
    }

    protected abstract TFormulaInfo greaterOrEquals(TFormulaInfo var1, TFormulaInfo var2, boolean var3);

    @Override
    public BooleanFormula lessThan(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean signed) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Can't compare bitvectors with different sizes (" + this.getLength(pNumber1) + " and " + this.getLength(pNumber2) + ")";
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.lessThan(param1, param2, signed));
    }

    protected abstract TFormulaInfo lessThan(TFormulaInfo var1, TFormulaInfo var2, boolean var3);

    @Override
    public BooleanFormula lessOrEquals(BitvectorFormula pNumber1, BitvectorFormula pNumber2, boolean signed) {
        assert (this.getLength(pNumber1) == this.getLength(pNumber2)) : "Can't compare bitvectors with different sizes (" + this.getLength(pNumber1) + " and " + this.getLength(pNumber2) + ")";
        Object param1 = this.extractInfo(pNumber1);
        Object param2 = this.extractInfo(pNumber2);
        return this.wrapBool(this.lessOrEquals(param1, param2, signed));
    }

    protected abstract TFormulaInfo lessOrEquals(TFormulaInfo var1, TFormulaInfo var2, boolean var3);

    @Override
    public boolean isEqual(BooleanFormula pNumber) {
        Object param = this.extractInfo(pNumber);
        return this.isEqual(param);
    }

    protected abstract boolean isEqual(TFormulaInfo var1);

    @Override
    public BitvectorFormula not(BitvectorFormula pBits) {
        Object param1 = this.extractInfo(pBits);
        return this.wrap(this.not(param1));
    }

    protected abstract TFormulaInfo not(TFormulaInfo var1);

    @Override
    public BitvectorFormula and(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        assert (this.getLength(pBits1) == this.getLength(pBits2));
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.and(param1, param2));
    }

    protected abstract TFormulaInfo and(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BitvectorFormula or(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        assert (this.getLength(pBits1) == this.getLength(pBits2));
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.or(param1, param2));
    }

    protected abstract TFormulaInfo or(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BitvectorFormula xor(BitvectorFormula pBits1, BitvectorFormula pBits2) {
        assert (this.getLength(pBits1) == this.getLength(pBits2));
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.xor(param1, param2));
    }

    protected abstract TFormulaInfo xor(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BitvectorFormula makeBitvector(int pLength, long i) {
        return this.wrap(this.makeBitvectorImpl(pLength, i));
    }

    protected abstract TFormulaInfo makeBitvectorImpl(int var1, long var2);

    @Override
    public BitvectorFormula makeBitvector(int pLength, BigInteger i) {
        return this.wrap(this.makeBitvectorImpl(pLength, i));
    }

    protected abstract TFormulaInfo makeBitvectorImpl(int var1, BigInteger var2);

    @Override
    public BitvectorFormula makeVariable(int pLength, String pVar) {
        return this.wrap(this.makeVariableImpl(pLength, pVar));
    }

    protected abstract TFormulaInfo makeVariableImpl(int var1, String var2);

    @Override
    public BitvectorFormula shiftRight(BitvectorFormula pNumber, BitvectorFormula toShift, boolean signed) {
        Object param1 = this.extractInfo(pNumber);
        Object param2 = this.extractInfo(toShift);
        return this.wrap(this.shiftRight(param1, param2, signed));
    }

    protected abstract TFormulaInfo shiftRight(TFormulaInfo var1, TFormulaInfo var2, boolean var3);

    @Override
    public BitvectorFormula shiftLeft(BitvectorFormula pNumber, BitvectorFormula toShift) {
        Object param1 = this.extractInfo(pNumber);
        Object param2 = this.extractInfo(toShift);
        return this.wrap(this.shiftLeft(param1, param2));
    }

    protected abstract TFormulaInfo shiftLeft(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public final BitvectorFormula concat(BitvectorFormula pNumber, BitvectorFormula pAppend) {
        Object param1 = this.extractInfo(pNumber);
        Object param2 = this.extractInfo(pAppend);
        return this.wrap(this.concat(param1, param2));
    }

    protected abstract TFormulaInfo concat(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public final BitvectorFormula extract(BitvectorFormula pNumber, int pMsb, int pLsb) {
        Object param = this.extractInfo(pNumber);
        return this.wrap(this.extract(param, pMsb, pLsb));
    }

    protected abstract TFormulaInfo extract(TFormulaInfo var1, int var2, int var3);

    @Override
    public final BitvectorFormula extend(BitvectorFormula pNumber, int pExtensionBits, boolean pSigned) {
        Object param = this.extractInfo(pNumber);
        return this.wrap(this.extend(param, pExtensionBits, pSigned));
    }

    protected abstract TFormulaInfo extend(TFormulaInfo var1, int var2, boolean var3);

    @Override
    public int getLength(BitvectorFormula pNumber) {
        FormulaType<?> type = this.getFormulaCreator().getFormulaType(pNumber);
        return ((FormulaType.BitvectorType)type).getSize();
    }
}

