/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.FormulaCreator;

public abstract class AbstractBooleanFormulaManager<TFormulaInfo, TType, TEnv>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv>
implements BooleanFormulaManager {
    protected AbstractBooleanFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv> pCreator) {
        super(pCreator);
    }

    @Override
    public boolean isBoolean(Formula f) {
        return f instanceof BooleanFormula;
    }

    private BooleanFormula wrap(TFormulaInfo formulaInfo) {
        return this.getFormulaCreator().encapsulateBoolean(formulaInfo);
    }

    @Override
    public BooleanFormula makeVariable(String pVar) {
        return this.wrap(this.makeVariableImpl(pVar));
    }

    protected abstract TFormulaInfo makeVariableImpl(String var1);

    @Override
    public BooleanFormula makeBoolean(boolean value) {
        return this.wrap(this.makeBooleanImpl(value));
    }

    protected abstract TFormulaInfo makeBooleanImpl(boolean var1);

    @Override
    public BooleanFormula not(BooleanFormula pBits) {
        Object param1 = this.extractInfo(pBits);
        return this.wrap(this.not(param1));
    }

    protected abstract TFormulaInfo not(TFormulaInfo var1);

    @Override
    public BooleanFormula and(BooleanFormula pBits1, BooleanFormula pBits2) {
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.and(param1, param2));
    }

    protected abstract TFormulaInfo and(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula and(List<BooleanFormula> pBits) {
        if (pBits.isEmpty()) {
            return this.makeBoolean(true);
        }
        if (pBits.size() == 1) {
            return pBits.get(0);
        }
        TFormulaInfo result = this.andImpl(Lists.transform(pBits, (Function)this.extractor));
        return this.wrap(result);
    }

    protected TFormulaInfo andImpl(List<TFormulaInfo> pParams) {
        TFormulaInfo result = this.makeBooleanImpl(true);
        for (TFormulaInfo formula : pParams) {
            result = this.and(result, formula);
        }
        return result;
    }

    @Override
    public BooleanFormula or(BooleanFormula pBits1, BooleanFormula pBits2) {
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.or(param1, param2));
    }

    protected abstract TFormulaInfo or(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula xor(BooleanFormula pBits1, BooleanFormula pBits2) {
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.xor(param1, param2));
    }

    @Override
    public BooleanFormula or(List<BooleanFormula> pBits) {
        if (pBits.isEmpty()) {
            return this.makeBoolean(false);
        }
        if (pBits.size() == 1) {
            return pBits.get(0);
        }
        TFormulaInfo result = this.orImpl(Lists.transform(pBits, (Function)this.extractor));
        return this.wrap(result);
    }

    protected TFormulaInfo orImpl(List<TFormulaInfo> pParams) {
        TFormulaInfo result = this.makeBooleanImpl(false);
        for (TFormulaInfo formula : pParams) {
            result = this.or(result, formula);
        }
        return result;
    }

    protected abstract TFormulaInfo xor(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public boolean isNot(BooleanFormula pBits) {
        Object param = this.extractInfo(pBits);
        return this.isNot(param);
    }

    protected abstract boolean isNot(TFormulaInfo var1);

    @Override
    public boolean isAnd(BooleanFormula pBits) {
        Object param = this.extractInfo(pBits);
        return this.isAnd(param);
    }

    protected abstract boolean isAnd(TFormulaInfo var1);

    @Override
    public boolean isOr(BooleanFormula pBits) {
        Object param = this.extractInfo(pBits);
        return this.isOr(param);
    }

    protected abstract boolean isOr(TFormulaInfo var1);

    @Override
    public boolean isXor(BooleanFormula pBits) {
        Object param = this.extractInfo(pBits);
        return this.isXor(param);
    }

    protected abstract boolean isXor(TFormulaInfo var1);

    @Override
    public final BooleanFormula equivalence(BooleanFormula pBits1, BooleanFormula pBits2) {
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.equivalence(param1, param2));
    }

    protected abstract TFormulaInfo equivalence(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public final boolean isTrue(BooleanFormula pBits) {
        return this.isTrue(this.extractInfo(pBits));
    }

    protected abstract boolean isTrue(TFormulaInfo var1);

    @Override
    public final boolean isFalse(BooleanFormula pBits) {
        return this.isFalse(this.extractInfo(pBits));
    }

    protected abstract boolean isFalse(TFormulaInfo var1);

    @Override
    public final <T extends Formula> T ifThenElse(BooleanFormula pBits, T f1, T f2) {
        FormulaType<?> t2;
        FormulaType<?> t1 = this.getFormulaCreator().getFormulaType(f1);
        if (!t1.equals(t2 = this.getFormulaCreator().getFormulaType(f2))) {
            throw new IllegalArgumentException("Cannot create if-then-else formula with branches of different types: " + f1 + " is of type " + t1 + "; " + f2 + " is of type " + t2);
        }
        Object result = this.ifThenElse(this.extractInfo(pBits), this.extractInfo(f1), this.extractInfo(f2));
        return (T)this.getFormulaCreator().encapsulate(t1, result);
    }

    protected abstract TFormulaInfo ifThenElse(TFormulaInfo var1, TFormulaInfo var2, TFormulaInfo var3);

    @Override
    public boolean isEquivalence(BooleanFormula pFormula) {
        return this.isEquivalence(this.extractInfo(pFormula));
    }

    protected abstract boolean isEquivalence(TFormulaInfo var1);

    @Override
    public boolean isImplication(BooleanFormula pFormula) {
        return this.isImplication(this.extractInfo(pFormula));
    }

    protected abstract boolean isImplication(TFormulaInfo var1);

    @Override
    public <T extends Formula> boolean isIfThenElse(T pF) {
        return this.isIfThenElse(this.extractInfo(pF));
    }

    protected abstract boolean isIfThenElse(TFormulaInfo var1);
}

