/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl;

import com.google.common.base.Preconditions;
import org.sosy_lab.common.Appender;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FloatingPointFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractArrayFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractBitvectorFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractFloatingPointFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractFunctionFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractQuantifiedFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractUnsafeFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.FormulaCreator;
import org.sosy_lab.cpachecker.util.predicates.matching.SmtAstMatcher;

public abstract class AbstractFormulaManager<TFormulaInfo, TType, TEnv>
implements FormulaManager {
    private final AbstractArrayFormulaManager<TFormulaInfo, TType, TEnv> arrayManager;
    private final AbstractBooleanFormulaManager<TFormulaInfo, TType, TEnv> booleanManager;
    private final AbstractNumeralFormulaManager<TFormulaInfo, TType, TEnv, NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> integerManager;
    private final AbstractNumeralFormulaManager<TFormulaInfo, TType, TEnv, NumeralFormula, NumeralFormula.RationalFormula> rationalManager;
    private final AbstractBitvectorFormulaManager<TFormulaInfo, TType, TEnv> bitvectorManager;
    private final AbstractFloatingPointFormulaManager<TFormulaInfo, TType, TEnv> floatingPointManager;
    private final AbstractFunctionFormulaManager<TFormulaInfo, ?, TType, TEnv> functionManager;
    private final AbstractUnsafeFormulaManager<TFormulaInfo, TType, TEnv> unsafeManager;
    private final AbstractQuantifiedFormulaManager<TFormulaInfo, TType, TEnv> quantifiedManager;
    private final FormulaCreator<TFormulaInfo, TType, TEnv> formulaCreator;

    protected AbstractFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv> pFormulaCreator, AbstractUnsafeFormulaManager<TFormulaInfo, TType, TEnv> unsafeManager, AbstractFunctionFormulaManager<TFormulaInfo, ?, TType, TEnv> functionManager, AbstractBooleanFormulaManager<TFormulaInfo, TType, TEnv> booleanManager, AbstractNumeralFormulaManager<TFormulaInfo, TType, TEnv, NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> pIntegerManager, AbstractNumeralFormulaManager<TFormulaInfo, TType, TEnv, NumeralFormula, NumeralFormula.RationalFormula> pRationalManager, AbstractBitvectorFormulaManager<TFormulaInfo, TType, TEnv> bitvectorManager, AbstractFloatingPointFormulaManager<TFormulaInfo, TType, TEnv> floatingPointManager, AbstractQuantifiedFormulaManager<TFormulaInfo, TType, TEnv> quantifiedManager, AbstractArrayFormulaManager<TFormulaInfo, TType, TEnv> arrayManager) {
        if (functionManager == null || booleanManager == null || unsafeManager == null) {
            throw new IllegalArgumentException("boolean, function and unsafe manager instances have to be valid!");
        }
        this.arrayManager = arrayManager;
        this.quantifiedManager = quantifiedManager;
        this.functionManager = functionManager;
        this.booleanManager = booleanManager;
        this.integerManager = pIntegerManager;
        this.rationalManager = pRationalManager;
        this.bitvectorManager = bitvectorManager;
        this.floatingPointManager = floatingPointManager;
        this.unsafeManager = unsafeManager;
        this.formulaCreator = pFormulaCreator;
        if (booleanManager.getFormulaCreator() != this.formulaCreator || unsafeManager.getFormulaCreator() != this.formulaCreator || functionManager.getFormulaCreator() != this.formulaCreator || this.integerManager != null && this.integerManager.getFormulaCreator() != this.formulaCreator || this.rationalManager != null && this.rationalManager.getFormulaCreator() != this.formulaCreator || bitvectorManager != null && bitvectorManager.getFormulaCreator() != this.formulaCreator || floatingPointManager != null && floatingPointManager.getFormulaCreator() != this.formulaCreator) {
            throw new IllegalArgumentException("The creator instances must match across the managers!");
        }
    }

    public final FormulaCreator<TFormulaInfo, TType, TEnv> getFormulaCreator() {
        return this.formulaCreator;
    }

    public AbstractNumeralFormulaManager<TFormulaInfo, TType, TEnv, NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> getIntegerFormulaManager() {
        if (this.integerManager == null) {
            throw new UnsupportedOperationException();
        }
        return this.integerManager;
    }

    public AbstractNumeralFormulaManager<TFormulaInfo, TType, TEnv, NumeralFormula, NumeralFormula.RationalFormula> getRationalFormulaManager() {
        if (this.rationalManager == null) {
            throw new UnsupportedOperationException();
        }
        return this.rationalManager;
    }

    @Override
    public AbstractBooleanFormulaManager<TFormulaInfo, TType, TEnv> getBooleanFormulaManager() {
        return this.booleanManager;
    }

    @Override
    public AbstractBitvectorFormulaManager<TFormulaInfo, TType, TEnv> getBitvectorFormulaManager() {
        if (this.bitvectorManager == null) {
            throw new UnsupportedOperationException();
        }
        return this.bitvectorManager;
    }

    @Override
    public FloatingPointFormulaManager getFloatingPointFormulaManager() {
        if (this.floatingPointManager == null) {
            throw new UnsupportedOperationException();
        }
        return this.floatingPointManager;
    }

    @Override
    public AbstractFunctionFormulaManager<TFormulaInfo, ?, TType, TEnv> getFunctionFormulaManager() {
        return this.functionManager;
    }

    @Override
    public AbstractUnsafeFormulaManager<TFormulaInfo, TType, TEnv> getUnsafeFormulaManager() {
        return this.unsafeManager;
    }

    @Override
    public AbstractQuantifiedFormulaManager<TFormulaInfo, TType, TEnv> getQuantifiedFormulaManager() {
        return this.quantifiedManager;
    }

    @Override
    public ArrayFormulaManager getArrayFormulaManager() {
        return this.arrayManager;
    }

    public abstract Appender dumpFormula(TFormulaInfo var1);

    @Override
    public Appender dumpFormula(Formula t) {
        return this.dumpFormula(this.formulaCreator.extractInfo(t));
    }

    @Override
    public final <T extends Formula> FormulaType<T> getFormulaType(T formula) {
        return this.formulaCreator.getFormulaType((Formula)Preconditions.checkNotNull(formula));
    }

    public final TEnv getEnvironment() {
        return this.getFormulaCreator().getEnv();
    }

    public final TFormulaInfo extractInfo(Formula f) {
        return this.formulaCreator.extractInfo(f);
    }

    @Override
    public SmtAstMatcher getSmtAstMatcher() {
        throw new UnsupportedOperationException("There is not yet an implementation for formula-ast matching for this solver!");
    }
}

