/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FunctionFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.UninterpretedFunctionDeclaration;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractUninterpretedFunctionDeclaration;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractUnsafeFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.FormulaCreator;

public abstract class AbstractFunctionFormulaManager<TFormulaInfo, TFunctionDecl, TType, TEnv>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv>
implements FunctionFormulaManager {
    private final AbstractUnsafeFormulaManager<TFormulaInfo, TType, TEnv> unsafeManager;

    protected AbstractFunctionFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv> pCreator, AbstractUnsafeFormulaManager<TFormulaInfo, TType, TEnv> unsafeManager) {
        super(pCreator);
        this.unsafeManager = unsafeManager;
    }

    protected abstract TFunctionDecl declareUninterpretedFunctionImpl(String var1, TType var2, List<TType> var3);

    @Override
    public final <T extends Formula> UninterpretedFunctionDeclaration<T> declareUninterpretedFunction(String pName, FormulaType<T> pReturnType, List<FormulaType<?>> pArgTypes) {
        ArrayList argTypes = new ArrayList(pArgTypes.size());
        for (FormulaType<?> argtype : pArgTypes) {
            argTypes.add(this.toSolverType(argtype));
        }
        return new AbstractUninterpretedFunctionDeclaration<T, TFunctionDecl>(pReturnType, this.declareUninterpretedFunctionImpl(pName, this.toSolverType(pReturnType), argTypes), pArgTypes);
    }

    @Override
    public <T extends Formula> UninterpretedFunctionDeclaration<T> declareUninterpretedFunction(String pName, FormulaType<T> pReturnType, FormulaType<?> ... pArgs) {
        return this.declareUninterpretedFunction(pName, pReturnType, Arrays.asList(pArgs));
    }

    protected abstract TFormulaInfo createUninterpretedFunctionCallImpl(TFunctionDecl var1, List<TFormulaInfo> var2);

    @Override
    public final <T extends Formula> T callUninterpretedFunction(UninterpretedFunctionDeclaration<T> pFunc, List<? extends Formula> pArgs) {
        FormulaType<T> retType = pFunc.getReturnType();
        List list = Lists.transform(pArgs, (Function)this.extractor);
        TFormulaInfo formulaInfo = this.createUninterpretedFunctionCallImpl(pFunc, list);
        return this.unsafeManager.typeFormula(retType, formulaInfo);
    }

    final <T extends Formula> TFormulaInfo createUninterpretedFunctionCallImpl(UninterpretedFunctionDeclaration<T> pFunc, List<TFormulaInfo> pArgs) {
        AbstractUninterpretedFunctionDeclaration func = (AbstractUninterpretedFunctionDeclaration)pFunc;
        return this.createUninterpretedFunctionCallImpl(func.getFuncDecl(), pArgs);
    }
}

