/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.UninterpretedFunctionDeclaration;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractFunctionFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.FormulaCreator;

public abstract class AbstractNumeralFormulaManager<TFormulaInfo, TType, TEnv, ParamFormulaType extends NumeralFormula, ResultFormulaType extends NumeralFormula>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv>
implements NumeralFormulaManager<ParamFormulaType, ResultFormulaType> {
    private static final String UF_MULTIPLY_NAME = "_*_";
    private static final String UF_DIVIDE_NAME = "_/_";
    private static final String UF_MODULO_NAME = "_%_";
    private final AbstractFunctionFormulaManager<TFormulaInfo, ?, TType, TEnv> functionManager;
    private final UninterpretedFunctionDeclaration<ResultFormulaType> multUfDecl;
    private final UninterpretedFunctionDeclaration<ResultFormulaType> divUfDecl;
    private final UninterpretedFunctionDeclaration<ResultFormulaType> modUfDecl;

    protected AbstractNumeralFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv> pCreator, AbstractFunctionFormulaManager<TFormulaInfo, ?, TType, TEnv> pFunctionManager) {
        super(pCreator);
        this.functionManager = pFunctionManager;
        FormulaType resultType = this.getFormulaType();
        this.multUfDecl = this.functionManager.declareUninterpretedFunction(resultType + "_" + UF_MULTIPLY_NAME, resultType, resultType, resultType);
        this.divUfDecl = this.functionManager.declareUninterpretedFunction(resultType + "_" + UF_DIVIDE_NAME, resultType, resultType, resultType);
        this.modUfDecl = this.functionManager.declareUninterpretedFunction(resultType + "_" + UF_MODULO_NAME, resultType, resultType, resultType);
    }

    private TFormulaInfo makeUf(UninterpretedFunctionDeclaration<?> decl, TFormulaInfo t1, TFormulaInfo t2) {
        return this.functionManager.createUninterpretedFunctionCallImpl(decl, (List<TFormulaInfo>)ImmutableList.of(t1, t2));
    }

    protected ResultFormulaType wrap(TFormulaInfo pTerm) {
        return (ResultFormulaType)((NumeralFormula)this.getFormulaCreator().encapsulate(this.getFormulaType(), pTerm));
    }

    @Override
    public ResultFormulaType makeNumber(long i) {
        return this.wrap(this.makeNumberImpl(i));
    }

    protected abstract TFormulaInfo makeNumberImpl(long var1);

    @Override
    public ResultFormulaType makeNumber(BigInteger i) {
        return this.wrap(this.makeNumberImpl(i));
    }

    protected abstract TFormulaInfo makeNumberImpl(BigInteger var1);

    @Override
    public ResultFormulaType makeNumber(String i) {
        return this.wrap(this.makeNumberImpl(i));
    }

    protected abstract TFormulaInfo makeNumberImpl(String var1);

    @Override
    public ResultFormulaType makeNumber(double pNumber) {
        return this.wrap(this.makeNumberImpl(pNumber));
    }

    protected abstract TFormulaInfo makeNumberImpl(double var1);

    @Override
    public ResultFormulaType makeNumber(BigDecimal pNumber) {
        return this.wrap(this.makeNumberImpl(pNumber));
    }

    protected abstract TFormulaInfo makeNumberImpl(BigDecimal var1);

    protected final TFormulaInfo decimalAsInteger(BigDecimal val) {
        if (val.scale() <= 0) {
            return this.makeNumberImpl(AbstractNumeralFormulaManager.convertBigDecimalToBigInteger(val));
        }
        BigDecimal n = val.movePointRight(val.scale());
        BigInteger numerator = AbstractNumeralFormulaManager.convertBigDecimalToBigInteger(n);
        BigDecimal d = BigDecimal.ONE.scaleByPowerOfTen(val.scale());
        BigInteger denominator = AbstractNumeralFormulaManager.convertBigDecimalToBigInteger(d);
        assert (denominator.signum() > 0);
        return this.divide(this.makeNumberImpl(numerator), this.makeNumberImpl(denominator));
    }

    private static BigInteger convertBigDecimalToBigInteger(BigDecimal d) throws NumberFormatException {
        try {
            return d.toBigIntegerExact();
        }
        catch (ArithmeticException e) {
            NumberFormatException nfe = new NumberFormatException("Cannot represent BigDecimal " + d + " as BigInteger");
            nfe.initCause(e);
            throw nfe;
        }
    }

    @Override
    public ResultFormulaType makeVariable(String pVar) {
        return this.wrap(this.makeVariableImpl(pVar));
    }

    protected abstract TFormulaInfo makeVariableImpl(String var1);

    @Override
    public ResultFormulaType negate(ParamFormulaType pNumber) {
        Object param1 = this.extractInfo((Formula)pNumber);
        return this.wrap(this.negate((TFormulaInfo)param1));
    }

    @Override
    protected abstract TFormulaInfo negate(TFormulaInfo var1);

    @Override
    public ResultFormulaType add(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrap(this.add((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    @Override
    protected abstract TFormulaInfo add(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public ResultFormulaType sum(List<ParamFormulaType> operands) {
        return this.wrap(this.sumImpl(Lists.transform(operands, (Function)this.extractor)));
    }

    protected TFormulaInfo sumImpl(List<TFormulaInfo> operands) {
        TFormulaInfo result = this.makeNumberImpl(0L);
        for (TFormulaInfo operand : operands) {
            result = this.add(result, operand);
        }
        return result;
    }

    @Override
    public ResultFormulaType subtract(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrap(this.subtract((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    @Override
    protected abstract TFormulaInfo subtract(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public ResultFormulaType divide(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrap(this.divide((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    @Override
    protected TFormulaInfo divide(TFormulaInfo pParam1, TFormulaInfo pParam2) {
        return this.makeUf(this.divUfDecl, pParam1, pParam2);
    }

    @Override
    public ResultFormulaType modulo(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrap(this.modulo((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    @Override
    protected TFormulaInfo modulo(TFormulaInfo pParam1, TFormulaInfo pParam2) {
        return this.makeUf(this.modUfDecl, pParam1, pParam2);
    }

    @Override
    public BooleanFormula modularCongruence(ParamFormulaType pNumber1, ParamFormulaType pNumber2, long pModulo) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrapBool(this.modularCongruence((TFormulaInfo)param1, (TFormulaInfo)param2, pModulo));
    }

    protected abstract TFormulaInfo modularCongruence(TFormulaInfo var1, TFormulaInfo var2, long var3);

    @Override
    public ResultFormulaType multiply(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrap(this.multiply((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    @Override
    protected TFormulaInfo multiply(TFormulaInfo pParam1, TFormulaInfo pParam2) {
        return this.makeUf(this.multUfDecl, pParam1, pParam2);
    }

    @Override
    public BooleanFormula equal(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrapBool(this.equal((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    protected abstract TFormulaInfo equal(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula greaterThan(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrapBool(this.greaterThan((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    protected abstract TFormulaInfo greaterThan(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula greaterOrEquals(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrapBool(this.greaterOrEquals((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    protected abstract TFormulaInfo greaterOrEquals(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula lessThan(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrapBool(this.lessThan((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    protected abstract TFormulaInfo lessThan(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula lessOrEquals(ParamFormulaType pNumber1, ParamFormulaType pNumber2) {
        Object param1 = this.extractInfo((Formula)pNumber1);
        Object param2 = this.extractInfo((Formula)pNumber2);
        return this.wrapBool(this.lessOrEquals((TFormulaInfo)param1, (TFormulaInfo)param2));
    }

    protected abstract TFormulaInfo lessOrEquals(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public boolean isEqual(BooleanFormula pNumber) {
        Object param = this.extractInfo(pNumber);
        return this.isEqual(param);
    }

    protected abstract boolean isEqual(TFormulaInfo var1);
}

