/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.Formula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaType;
import org.sosy_lab.cpachecker.util.predicates.interfaces.UnsafeFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.basicimpl.FormulaCreator;

public abstract class AbstractUnsafeFormulaManager<TFormulaInfo, TType, TEnv>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv>
implements UnsafeFormulaManager {
    protected AbstractUnsafeFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv> creator) {
        super(creator);
    }

    private <T extends Formula> T encapsulateWithTypeOf(T f, TFormulaInfo e) {
        FormulaType<?> type = this.getFormulaCreator().getFormulaType(f);
        return (T)this.typeFormula(type, e);
    }

    @Override
    public <T extends Formula> T typeFormula(FormulaType<T> type, Formula f) {
        Object formulaInfo = this.extractInfo(f);
        return this.typeFormula(type, formulaInfo);
    }

    final <T extends Formula> T typeFormula(FormulaType<T> type, TFormulaInfo formulaInfo) {
        return this.getFormulaCreator().encapsulate(type, formulaInfo);
    }

    protected List<TFormulaInfo> getArguments(TFormulaInfo pT) {
        int arity = this.getArity(pT);
        ArrayList<TFormulaInfo> rets = new ArrayList<TFormulaInfo>(arity);
        for (int i = 0; i < arity; ++i) {
            rets.add(this.getArg(pT, i));
        }
        return rets;
    }

    @Override
    public boolean isAtom(Formula pF) {
        Object t = this.extractInfo(pF);
        return this.isAtom(t);
    }

    protected abstract boolean isAtom(TFormulaInfo var1);

    @Override
    public boolean isLiteral(Formula pF) {
        Object t = this.extractInfo(pF);
        return this.isLiteral(t);
    }

    protected abstract boolean isLiteral(TFormulaInfo var1);

    @Override
    public int getArity(Formula pF) {
        Object t = this.extractInfo(pF);
        return this.getArity(t);
    }

    protected abstract int getArity(TFormulaInfo var1);

    @Override
    public Formula getArg(Formula pF, int pN) {
        assert (0 <= pN && pN < this.getArity(pF)) : String.format("index %d out of bounds %d", pN, this.getArity(pF));
        Object t = this.extractInfo(pF);
        Object arg = this.getArg(t, pN);
        return this.typeFormula(this.getFormulaCreator().getFormulaType(arg), arg);
    }

    protected abstract TFormulaInfo getArg(TFormulaInfo var1, int var2);

    @Override
    public boolean isVariable(Formula pF) {
        Object t = this.extractInfo(pF);
        return this.isVariable(t);
    }

    protected abstract boolean isVariable(TFormulaInfo var1);

    @Override
    public boolean isFreeVariable(Formula pF) {
        Object t = this.extractInfo(pF);
        return this.isFreeVariable(t);
    }

    protected abstract boolean isFreeVariable(TFormulaInfo var1);

    @Override
    public boolean isBoundVariable(Formula pF) {
        Object t = this.extractInfo(pF);
        return this.isBoundVariable(t);
    }

    protected abstract boolean isBoundVariable(TFormulaInfo var1);

    @Override
    public boolean isQuantification(Formula pF) {
        Object t = this.extractInfo(pF);
        return this.isQuantification(t);
    }

    protected abstract boolean isQuantification(TFormulaInfo var1);

    @Override
    public BooleanFormula getQuantifiedBody(Formula pQuantifiedFormula) {
        Preconditions.checkArgument((boolean)this.isQuantification(pQuantifiedFormula));
        Object t = this.extractInfo(pQuantifiedFormula);
        Object result = this.getQuantifiedBody(t);
        return this.getFormulaCreator().encapsulateBoolean(result);
    }

    protected abstract TFormulaInfo getQuantifiedBody(TFormulaInfo var1);

    @Override
    public boolean isNumber(Formula pF) {
        Object t = this.extractInfo(pF);
        return this.isNumber(t);
    }

    @Override
    public BooleanFormula replaceQuantifiedBody(BooleanFormula pF, BooleanFormula pNewBody) {
        Preconditions.checkArgument((boolean)this.isQuantification(pF));
        Object f = this.extractInfo(pF);
        Object body = this.extractInfo(pNewBody);
        Object result = this.replaceQuantifiedBody(f, body);
        return this.getFormulaCreator().encapsulateBoolean(result);
    }

    protected abstract TFormulaInfo replaceQuantifiedBody(TFormulaInfo var1, TFormulaInfo var2);

    protected abstract boolean isNumber(TFormulaInfo var1);

    @Override
    public boolean isUF(Formula pF) {
        Object t = this.extractInfo(pF);
        return this.isUF(t);
    }

    protected abstract boolean isUF(TFormulaInfo var1);

    @Override
    public String getName(Formula pF) {
        Object t = this.extractInfo(pF);
        return this.getName(t);
    }

    protected abstract String getName(TFormulaInfo var1);

    @Override
    public <T extends Formula> T replaceArgsAndName(T f, String newName, List<Formula> args) {
        return this.encapsulateWithTypeOf(f, this.replaceArgsAndName(this.extractInfo(f), newName, Lists.transform(args, (Function)this.extractor)));
    }

    protected TFormulaInfo replaceArgsAndName(TFormulaInfo pTerm, String pNewName, List<TFormulaInfo> newArgs) {
        TFormulaInfo withNewArgs = this.replaceArgs(pTerm, newArgs);
        return this.replaceName(withNewArgs, pNewName);
    }

    @Override
    public <T extends Formula> T replaceArgs(T pF, List<Formula> pArgs) {
        assert (pArgs.size() == this.getArity(pF)) : "number of args must match arity.";
        return this.encapsulateWithTypeOf(pF, this.replaceArgs(this.extractInfo(pF), Lists.transform(pArgs, (Function)this.extractor)));
    }

    protected abstract TFormulaInfo replaceArgs(TFormulaInfo var1, List<TFormulaInfo> var2);

    @Override
    public <T extends Formula> T replaceName(T pF, String pNewName) {
        return this.encapsulateWithTypeOf(pF, this.replaceName(this.extractInfo(pF), pNewName));
    }

    protected abstract TFormulaInfo replaceName(TFormulaInfo var1, String var2);

    public <ResultFormulaType extends Formula, ParamFormulaType extends Formula> ResultFormulaType substitute(ResultFormulaType f, List<ParamFormulaType> changeFrom, List<ParamFormulaType> changeTo) {
        Object newExpression = this.substitute(this.getFormulaCreator().extractInfo(f), Lists.transform(changeFrom, (Function)this.extractor), Lists.transform(changeTo, (Function)this.extractor));
        FormulaType<?> type = this.getFormulaCreator().getFormulaType(f);
        return (ResultFormulaType)this.getFormulaCreator().encapsulate(type, newExpression);
    }

    protected abstract TFormulaInfo substitute(TFormulaInfo var1, List<TFormulaInfo> var2, List<TFormulaInfo> var3);

    @Override
    public <T1 extends Formula, T2 extends Formula> T1 substitute(T1 pF, Map<T2, T2> pFromToMapping) {
        ArrayList fromList = Lists.newArrayList(pFromToMapping.keySet());
        ArrayList toList = Lists.newArrayList(pFromToMapping.values());
        return this.substitute((TFormulaInfo)pF, fromList, toList);
    }

    @Override
    public <T extends Formula> T simplify(T f) {
        return this.encapsulateWithTypeOf(f, this.simplify(this.extractInfo(f)));
    }

    protected abstract TFormulaInfo simplify(TFormulaInfo var1);

    protected static class QuantifiedVariable {
        final FormulaType<?> variableType;
        final String nameInFormula;
        final int deBruijnIndex;

        public QuantifiedVariable(FormulaType<?> pVariableType, String pNameInFormula, int pDeBruijnIndex) {
            this.variableType = pVariableType;
            this.nameInFormula = pNameInFormula;
            this.deBruijnIndex = pDeBruijnIndex;
        }

        public String getDeBruijnName() {
            return "?" + this.deBruijnIndex;
        }
    }
}

